package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecordDetail invokes the rtc.DescribeRecordDetail API synchronously
// api document: https://help.aliyun.com/api/rtc/describerecorddetail.html
func (client *Client) DescribeRecordDetail(request *DescribeRecordDetailRequest) (response *DescribeRecordDetailResponse, err error) {
	response = CreateDescribeRecordDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecordDetailWithChan invokes the rtc.DescribeRecordDetail API asynchronously
// api document: https://help.aliyun.com/api/rtc/describerecorddetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecordDetailWithChan(request *DescribeRecordDetailRequest) (<-chan *DescribeRecordDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeRecordDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecordDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecordDetailWithCallback invokes the rtc.DescribeRecordDetail API asynchronously
// api document: https://help.aliyun.com/api/rtc/describerecorddetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecordDetailWithCallback(request *DescribeRecordDetailRequest, callback func(response *DescribeRecordDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecordDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecordDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecordDetailRequest is the request struct for api DescribeRecordDetail
type DescribeRecordDetailRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	RecordId  string           `position:"Query" name:"RecordId"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRecordDetailResponse is the response struct for api DescribeRecordDetail
type DescribeRecordDetailResponse struct {
	*responses.BaseResponse
	RequestId         string                                  `json:"RequestId" xml:"RequestId"`
	Duration          Duration                                `json:"Duration" xml:"Duration"`
	RecordDetailInfos RecordDetailInfosInDescribeRecordDetail `json:"RecordDetailInfos" xml:"RecordDetailInfos"`
}

// CreateDescribeRecordDetailRequest creates a request to invoke DescribeRecordDetail API
func CreateDescribeRecordDetailRequest() (request *DescribeRecordDetailRequest) {
	request = &DescribeRecordDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRecordDetail", "rtc", "openAPI")
	return
}

// CreateDescribeRecordDetailResponse creates a response to parse from DescribeRecordDetail response
func CreateDescribeRecordDetailResponse() (response *DescribeRecordDetailResponse) {
	response = &DescribeRecordDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
