// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package synapse

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/synapse/mgmt/2019-06-01-preview/synapse"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActualState = original.ActualState

const (
	Disabled  ActualState = original.Disabled
	Disabling ActualState = original.Disabling
	Enabled   ActualState = original.Enabled
	Enabling  ActualState = original.Enabling
	Unknown   ActualState = original.Unknown
)

type BlobAuditingPolicyState = original.BlobAuditingPolicyState

const (
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = original.BlobAuditingPolicyStateDisabled
	BlobAuditingPolicyStateEnabled  BlobAuditingPolicyState = original.BlobAuditingPolicyStateEnabled
)

type ColumnDataType = original.ColumnDataType

const (
	Bigint           ColumnDataType = original.Bigint
	Binary           ColumnDataType = original.Binary
	Bit              ColumnDataType = original.Bit
	Char             ColumnDataType = original.Char
	Date             ColumnDataType = original.Date
	Datetime         ColumnDataType = original.Datetime
	Datetime2        ColumnDataType = original.Datetime2
	Datetimeoffset   ColumnDataType = original.Datetimeoffset
	Decimal          ColumnDataType = original.Decimal
	Float            ColumnDataType = original.Float
	Geography        ColumnDataType = original.Geography
	Geometry         ColumnDataType = original.Geometry
	Hierarchyid      ColumnDataType = original.Hierarchyid
	Image            ColumnDataType = original.Image
	Int              ColumnDataType = original.Int
	Money            ColumnDataType = original.Money
	Nchar            ColumnDataType = original.Nchar
	Ntext            ColumnDataType = original.Ntext
	Numeric          ColumnDataType = original.Numeric
	Nvarchar         ColumnDataType = original.Nvarchar
	Real             ColumnDataType = original.Real
	Smalldatetime    ColumnDataType = original.Smalldatetime
	Smallint         ColumnDataType = original.Smallint
	Smallmoney       ColumnDataType = original.Smallmoney
	SQLVariant       ColumnDataType = original.SQLVariant
	Sysname          ColumnDataType = original.Sysname
	Text             ColumnDataType = original.Text
	Time             ColumnDataType = original.Time
	Timestamp        ColumnDataType = original.Timestamp
	Tinyint          ColumnDataType = original.Tinyint
	Uniqueidentifier ColumnDataType = original.Uniqueidentifier
	Varbinary        ColumnDataType = original.Varbinary
	Varchar          ColumnDataType = original.Varchar
	XML              ColumnDataType = original.XML
)

type DesiredState = original.DesiredState

const (
	DesiredStateDisabled DesiredState = original.DesiredStateDisabled
	DesiredStateEnabled  DesiredState = original.DesiredStateEnabled
)

type GeoBackupPolicyState = original.GeoBackupPolicyState

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = original.GeoBackupPolicyStateDisabled
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = original.GeoBackupPolicyStateEnabled
)

type ManagementOperationState = original.ManagementOperationState

const (
	CancelInProgress ManagementOperationState = original.CancelInProgress
	Cancelled        ManagementOperationState = original.Cancelled
	Failed           ManagementOperationState = original.Failed
	InProgress       ManagementOperationState = original.InProgress
	Pending          ManagementOperationState = original.Pending
	Succeeded        ManagementOperationState = original.Succeeded
)

type NodeSize = original.NodeSize

const (
	Large  NodeSize = original.Large
	Medium NodeSize = original.Medium
	None   NodeSize = original.None
	Small  NodeSize = original.Small
)

type NodeSizeFamily = original.NodeSizeFamily

const (
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = original.NodeSizeFamilyMemoryOptimized
	NodeSizeFamilyNone            NodeSizeFamily = original.NodeSizeFamilyNone
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCanceled   OperationStatus = original.OperationStatusCanceled
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateDeleteError  ProvisioningState = original.ProvisioningStateDeleteError
	ProvisioningStateDeleting     ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed       ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateProvisioning ProvisioningState = original.ProvisioningStateProvisioning
	ProvisioningStateSucceeded    ProvisioningState = original.ProvisioningStateSucceeded
)

type QueryAggregationFunction = original.QueryAggregationFunction

const (
	Avg QueryAggregationFunction = original.Avg
	Max QueryAggregationFunction = original.Max
	Min QueryAggregationFunction = original.Min
	Sum QueryAggregationFunction = original.Sum
)

type QueryExecutionType = original.QueryExecutionType

const (
	Aborted   QueryExecutionType = original.Aborted
	Any       QueryExecutionType = original.Any
	Exception QueryExecutionType = original.Exception
	Irregular QueryExecutionType = original.Irregular
	Regular   QueryExecutionType = original.Regular
)

type QueryMetricUnit = original.QueryMetricUnit

const (
	KB           QueryMetricUnit = original.KB
	Microseconds QueryMetricUnit = original.Microseconds
	Percentage   QueryMetricUnit = original.Percentage
)

type QueryObservedMetricType = original.QueryObservedMetricType

const (
	CPU            QueryObservedMetricType = original.CPU
	Duration       QueryObservedMetricType = original.Duration
	ExecutionCount QueryObservedMetricType = original.ExecutionCount
	Io             QueryObservedMetricType = original.Io
	Logio          QueryObservedMetricType = original.Logio
)

type ReplicationRole = original.ReplicationRole

const (
	Copy                 ReplicationRole = original.Copy
	NonReadableSecondary ReplicationRole = original.NonReadableSecondary
	Primary              ReplicationRole = original.Primary
	Secondary            ReplicationRole = original.Secondary
	Source               ReplicationRole = original.Source
)

type ReplicationState = original.ReplicationState

const (
	CATCHUP   ReplicationState = original.CATCHUP
	PENDING   ReplicationState = original.PENDING
	SEEDING   ReplicationState = original.SEEDING
	SUSPENDED ReplicationState = original.SUSPENDED
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone           ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
)

type RestorePointType = original.RestorePointType

const (
	CONTINUOUS RestorePointType = original.CONTINUOUS
	DISCRETE   RestorePointType = original.DISCRETE
)

type SecurityAlertPolicyState = original.SecurityAlertPolicyState

const (
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = original.SecurityAlertPolicyStateDisabled
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = original.SecurityAlertPolicyStateEnabled
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = original.SecurityAlertPolicyStateNew
)

type TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatus

const (
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusDisabled
	TransparentDataEncryptionStatusEnabled  TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusEnabled
)

type VulnerabilityAssessmentPolicyBaselineName = original.VulnerabilityAssessmentPolicyBaselineName

const (
	Default VulnerabilityAssessmentPolicyBaselineName = original.Default
	Master  VulnerabilityAssessmentPolicyBaselineName = original.Master
)

type VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanState

const (
	VulnerabilityAssessmentScanStateFailed      VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateFailed
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateFailedToRun
	VulnerabilityAssessmentScanStateInProgress  VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateInProgress
	VulnerabilityAssessmentScanStatePassed      VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStatePassed
)

type VulnerabilityAssessmentScanTriggerType = original.VulnerabilityAssessmentScanTriggerType

const (
	OnDemand  VulnerabilityAssessmentScanTriggerType = original.OnDemand
	Recurring VulnerabilityAssessmentScanTriggerType = original.Recurring
)

type AadAdminProperties = original.AadAdminProperties
type AutoPauseProperties = original.AutoPauseProperties
type AutoScaleProperties = original.AutoScaleProperties
type AvailableRpOperation = original.AvailableRpOperation
type AvailableRpOperationDisplayInfo = original.AvailableRpOperationDisplayInfo
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BigDataPoolPatchInfo = original.BigDataPoolPatchInfo
type BigDataPoolResourceInfo = original.BigDataPoolResourceInfo
type BigDataPoolResourceInfoListResult = original.BigDataPoolResourceInfoListResult
type BigDataPoolResourceInfoListResultIterator = original.BigDataPoolResourceInfoListResultIterator
type BigDataPoolResourceInfoListResultPage = original.BigDataPoolResourceInfoListResultPage
type BigDataPoolResourceProperties = original.BigDataPoolResourceProperties
type BigDataPoolsClient = original.BigDataPoolsClient
type BigDataPoolsCreateOrUpdateFuture = original.BigDataPoolsCreateOrUpdateFuture
type BigDataPoolsDeleteFuture = original.BigDataPoolsDeleteFuture
type CheckNameAvailabilityRequest = original.CheckNameAvailabilityRequest
type CheckNameAvailabilityResponse = original.CheckNameAvailabilityResponse
type CreateSQLPoolRestorePointDefinition = original.CreateSQLPoolRestorePointDefinition
type DataLakeStorageAccountDetails = original.DataLakeStorageAccountDetails
type DataWarehouseUserActivities = original.DataWarehouseUserActivities
type DataWarehouseUserActivitiesProperties = original.DataWarehouseUserActivitiesProperties
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorContract = original.ErrorContract
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type GeoBackupPolicy = original.GeoBackupPolicy
type GeoBackupPolicyProperties = original.GeoBackupPolicyProperties
type IPFirewallRuleInfo = original.IPFirewallRuleInfo
type IPFirewallRuleInfoListResult = original.IPFirewallRuleInfoListResult
type IPFirewallRuleInfoListResultIterator = original.IPFirewallRuleInfoListResultIterator
type IPFirewallRuleInfoListResultPage = original.IPFirewallRuleInfoListResultPage
type IPFirewallRuleProperties = original.IPFirewallRuleProperties
type IPFirewallRulesClient = original.IPFirewallRulesClient
type IPFirewallRulesCreateOrUpdateFuture = original.IPFirewallRulesCreateOrUpdateFuture
type IPFirewallRulesDeleteFuture = original.IPFirewallRulesDeleteFuture
type IPFirewallRulesReplaceAllFuture = original.IPFirewallRulesReplaceAllFuture
type LibraryRequirements = original.LibraryRequirements
type ListAvailableRpOperation = original.ListAvailableRpOperation
type ManagedIdentity = original.ManagedIdentity
type ManagedIdentitySQLControlSettingsModel = original.ManagedIdentitySQLControlSettingsModel
type ManagedIdentitySQLControlSettingsModelProperties = original.ManagedIdentitySQLControlSettingsModelProperties
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity = original.ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity
type MetadataSyncConfig = original.MetadataSyncConfig
type MetadataSyncConfigProperties = original.MetadataSyncConfigProperties
type OperationMetaLogSpecification = original.OperationMetaLogSpecification
type OperationMetaMetricDimensionSpecification = original.OperationMetaMetricDimensionSpecification
type OperationMetaMetricSpecification = original.OperationMetaMetricSpecification
type OperationMetaPropertyInfo = original.OperationMetaPropertyInfo
type OperationMetaServiceSpecification = original.OperationMetaServiceSpecification
type OperationResource = original.OperationResource
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type QueryInterval = original.QueryInterval
type QueryMetric = original.QueryMetric
type QueryStatistic = original.QueryStatistic
type ReplaceAllFirewallRulesOperationResponse = original.ReplaceAllFirewallRulesOperationResponse
type ReplaceAllIPFirewallRulesRequest = original.ReplaceAllIPFirewallRulesRequest
type ReplicationLink = original.ReplicationLink
type ReplicationLinkListResult = original.ReplicationLinkListResult
type ReplicationLinkListResultIterator = original.ReplicationLinkListResultIterator
type ReplicationLinkListResultPage = original.ReplicationLinkListResultPage
type ReplicationLinkProperties = original.ReplicationLinkProperties
type Resource = original.Resource
type ResourceMoveDefinition = original.ResourceMoveDefinition
type RestorePoint = original.RestorePoint
type RestorePointListResult = original.RestorePointListResult
type RestorePointListResultIterator = original.RestorePointListResultIterator
type RestorePointListResultPage = original.RestorePointListResultPage
type RestorePointProperties = original.RestorePointProperties
type SQLPool = original.SQLPool
type SQLPoolBlobAuditingPoliciesClient = original.SQLPoolBlobAuditingPoliciesClient
type SQLPoolBlobAuditingPolicy = original.SQLPoolBlobAuditingPolicy
type SQLPoolBlobAuditingPolicyProperties = original.SQLPoolBlobAuditingPolicyProperties
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResult
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage
type SQLPoolColumn = original.SQLPoolColumn
type SQLPoolColumnListResult = original.SQLPoolColumnListResult
type SQLPoolColumnListResultIterator = original.SQLPoolColumnListResultIterator
type SQLPoolColumnListResultPage = original.SQLPoolColumnListResultPage
type SQLPoolColumnProperties = original.SQLPoolColumnProperties
type SQLPoolConnectionPoliciesClient = original.SQLPoolConnectionPoliciesClient
type SQLPoolConnectionPolicy = original.SQLPoolConnectionPolicy
type SQLPoolConnectionPolicyProperties = original.SQLPoolConnectionPolicyProperties
type SQLPoolDataWarehouseUserActivitiesClient = original.SQLPoolDataWarehouseUserActivitiesClient
type SQLPoolGeoBackupPoliciesClient = original.SQLPoolGeoBackupPoliciesClient
type SQLPoolInfoListResult = original.SQLPoolInfoListResult
type SQLPoolInfoListResultIterator = original.SQLPoolInfoListResultIterator
type SQLPoolInfoListResultPage = original.SQLPoolInfoListResultPage
type SQLPoolMetadataSyncConfigsClient = original.SQLPoolMetadataSyncConfigsClient
type SQLPoolOperation = original.SQLPoolOperation
type SQLPoolOperationProperties = original.SQLPoolOperationProperties
type SQLPoolOperationResultsClient = original.SQLPoolOperationResultsClient
type SQLPoolOperationsClient = original.SQLPoolOperationsClient
type SQLPoolPatchInfo = original.SQLPoolPatchInfo
type SQLPoolReplicationLinksClient = original.SQLPoolReplicationLinksClient
type SQLPoolResourceProperties = original.SQLPoolResourceProperties
type SQLPoolRestorePointsClient = original.SQLPoolRestorePointsClient
type SQLPoolRestorePointsCreateFuture = original.SQLPoolRestorePointsCreateFuture
type SQLPoolSchema = original.SQLPoolSchema
type SQLPoolSchemaListResult = original.SQLPoolSchemaListResult
type SQLPoolSchemaListResultIterator = original.SQLPoolSchemaListResultIterator
type SQLPoolSchemaListResultPage = original.SQLPoolSchemaListResultPage
type SQLPoolSchemasClient = original.SQLPoolSchemasClient
type SQLPoolSecurityAlertPoliciesClient = original.SQLPoolSecurityAlertPoliciesClient
type SQLPoolSecurityAlertPolicy = original.SQLPoolSecurityAlertPolicy
type SQLPoolSensitivityLabelsClient = original.SQLPoolSensitivityLabelsClient
type SQLPoolTable = original.SQLPoolTable
type SQLPoolTableColumnsClient = original.SQLPoolTableColumnsClient
type SQLPoolTableListResult = original.SQLPoolTableListResult
type SQLPoolTableListResultIterator = original.SQLPoolTableListResultIterator
type SQLPoolTableListResultPage = original.SQLPoolTableListResultPage
type SQLPoolTablesClient = original.SQLPoolTablesClient
type SQLPoolTransparentDataEncryptionsClient = original.SQLPoolTransparentDataEncryptionsClient
type SQLPoolUsage = original.SQLPoolUsage
type SQLPoolUsageListResult = original.SQLPoolUsageListResult
type SQLPoolUsageListResultIterator = original.SQLPoolUsageListResultIterator
type SQLPoolUsageListResultPage = original.SQLPoolUsageListResultPage
type SQLPoolUsagesClient = original.SQLPoolUsagesClient
type SQLPoolVulnerabilityAssessment = original.SQLPoolVulnerabilityAssessment
type SQLPoolVulnerabilityAssessmentListResult = original.SQLPoolVulnerabilityAssessmentListResult
type SQLPoolVulnerabilityAssessmentListResultIterator = original.SQLPoolVulnerabilityAssessmentListResultIterator
type SQLPoolVulnerabilityAssessmentListResultPage = original.SQLPoolVulnerabilityAssessmentListResultPage
type SQLPoolVulnerabilityAssessmentProperties = original.SQLPoolVulnerabilityAssessmentProperties
type SQLPoolVulnerabilityAssessmentRuleBaseline = original.SQLPoolVulnerabilityAssessmentRuleBaseline
type SQLPoolVulnerabilityAssessmentRuleBaselineItem = original.SQLPoolVulnerabilityAssessmentRuleBaselineItem
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties = original.SQLPoolVulnerabilityAssessmentRuleBaselineProperties
type SQLPoolVulnerabilityAssessmentRuleBaselinesClient = original.SQLPoolVulnerabilityAssessmentRuleBaselinesClient
type SQLPoolVulnerabilityAssessmentScanExportProperties = original.SQLPoolVulnerabilityAssessmentScanExportProperties
type SQLPoolVulnerabilityAssessmentScansClient = original.SQLPoolVulnerabilityAssessmentScansClient
type SQLPoolVulnerabilityAssessmentScansExport = original.SQLPoolVulnerabilityAssessmentScansExport
type SQLPoolVulnerabilityAssessmentScansInitiateScanFuture = original.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture
type SQLPoolVulnerabilityAssessmentsClient = original.SQLPoolVulnerabilityAssessmentsClient
type SQLPoolsClient = original.SQLPoolsClient
type SQLPoolsCreateFuture = original.SQLPoolsCreateFuture
type SQLPoolsDeleteFuture = original.SQLPoolsDeleteFuture
type SQLPoolsPauseFuture = original.SQLPoolsPauseFuture
type SQLPoolsResumeFuture = original.SQLPoolsResumeFuture
type SecurityAlertPolicyProperties = original.SecurityAlertPolicyProperties
type SensitivityLabel = original.SensitivityLabel
type SensitivityLabelListResult = original.SensitivityLabelListResult
type SensitivityLabelListResultIterator = original.SensitivityLabelListResultIterator
type SensitivityLabelListResultPage = original.SensitivityLabelListResultPage
type SensitivityLabelProperties = original.SensitivityLabelProperties
type SetObject = original.SetObject
type Sku = original.Sku
type TopQueries = original.TopQueries
type TopQueriesListResult = original.TopQueriesListResult
type TrackedResource = original.TrackedResource
type TransparentDataEncryption = original.TransparentDataEncryption
type TransparentDataEncryptionProperties = original.TransparentDataEncryptionProperties
type VirtualNetworkProfile = original.VirtualNetworkProfile
type VulnerabilityAssessmentRecurringScansProperties = original.VulnerabilityAssessmentRecurringScansProperties
type VulnerabilityAssessmentScanError = original.VulnerabilityAssessmentScanError
type VulnerabilityAssessmentScanRecord = original.VulnerabilityAssessmentScanRecord
type VulnerabilityAssessmentScanRecordListResult = original.VulnerabilityAssessmentScanRecordListResult
type VulnerabilityAssessmentScanRecordListResultIterator = original.VulnerabilityAssessmentScanRecordListResultIterator
type VulnerabilityAssessmentScanRecordListResultPage = original.VulnerabilityAssessmentScanRecordListResultPage
type VulnerabilityAssessmentScanRecordProperties = original.VulnerabilityAssessmentScanRecordProperties
type Workspace = original.Workspace
type WorkspaceAadAdminInfo = original.WorkspaceAadAdminInfo
type WorkspaceAadAdminsClient = original.WorkspaceAadAdminsClient
type WorkspaceAadAdminsCreateOrUpdateFuture = original.WorkspaceAadAdminsCreateOrUpdateFuture
type WorkspaceAadAdminsDeleteFuture = original.WorkspaceAadAdminsDeleteFuture
type WorkspaceInfoListResult = original.WorkspaceInfoListResult
type WorkspaceInfoListResultIterator = original.WorkspaceInfoListResultIterator
type WorkspaceInfoListResultPage = original.WorkspaceInfoListResultPage
type WorkspaceManagedIdentitySQLControlSettingsClient = original.WorkspaceManagedIdentitySQLControlSettingsClient
type WorkspacePatchInfo = original.WorkspacePatchInfo
type WorkspacePatchProperties = original.WorkspacePatchProperties
type WorkspaceProperties = original.WorkspaceProperties
type WorkspacesClient = original.WorkspacesClient
type WorkspacesCreateOrUpdateFuture = original.WorkspacesCreateOrUpdateFuture
type WorkspacesDeleteFuture = original.WorkspacesDeleteFuture
type WorkspacesUpdateFuture = original.WorkspacesUpdateFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewBigDataPoolResourceInfoListResultIterator(page BigDataPoolResourceInfoListResultPage) BigDataPoolResourceInfoListResultIterator {
	return original.NewBigDataPoolResourceInfoListResultIterator(page)
}
func NewBigDataPoolResourceInfoListResultPage(getNextPage func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)) BigDataPoolResourceInfoListResultPage {
	return original.NewBigDataPoolResourceInfoListResultPage(getNextPage)
}
func NewBigDataPoolsClient(subscriptionID string) BigDataPoolsClient {
	return original.NewBigDataPoolsClient(subscriptionID)
}
func NewBigDataPoolsClientWithBaseURI(baseURI string, subscriptionID string) BigDataPoolsClient {
	return original.NewBigDataPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIPFirewallRuleInfoListResultIterator(page IPFirewallRuleInfoListResultPage) IPFirewallRuleInfoListResultIterator {
	return original.NewIPFirewallRuleInfoListResultIterator(page)
}
func NewIPFirewallRuleInfoListResultPage(getNextPage func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)) IPFirewallRuleInfoListResultPage {
	return original.NewIPFirewallRuleInfoListResultPage(getNextPage)
}
func NewIPFirewallRulesClient(subscriptionID string) IPFirewallRulesClient {
	return original.NewIPFirewallRulesClient(subscriptionID)
}
func NewIPFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) IPFirewallRulesClient {
	return original.NewIPFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewReplicationLinkListResultIterator(page ReplicationLinkListResultPage) ReplicationLinkListResultIterator {
	return original.NewReplicationLinkListResultIterator(page)
}
func NewReplicationLinkListResultPage(getNextPage func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)) ReplicationLinkListResultPage {
	return original.NewReplicationLinkListResultPage(getNextPage)
}
func NewRestorePointListResultIterator(page RestorePointListResultPage) RestorePointListResultIterator {
	return original.NewRestorePointListResultIterator(page)
}
func NewRestorePointListResultPage(getNextPage func(context.Context, RestorePointListResult) (RestorePointListResult, error)) RestorePointListResultPage {
	return original.NewRestorePointListResultPage(getNextPage)
}
func NewSQLPoolBlobAuditingPoliciesClient(subscriptionID string) SQLPoolBlobAuditingPoliciesClient {
	return original.NewSQLPoolBlobAuditingPoliciesClient(subscriptionID)
}
func NewSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolBlobAuditingPoliciesClient {
	return original.NewSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator {
	return original.NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page)
}
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(getNextPage func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)) SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage {
	return original.NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(getNextPage)
}
func NewSQLPoolColumnListResultIterator(page SQLPoolColumnListResultPage) SQLPoolColumnListResultIterator {
	return original.NewSQLPoolColumnListResultIterator(page)
}
func NewSQLPoolColumnListResultPage(getNextPage func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)) SQLPoolColumnListResultPage {
	return original.NewSQLPoolColumnListResultPage(getNextPage)
}
func NewSQLPoolConnectionPoliciesClient(subscriptionID string) SQLPoolConnectionPoliciesClient {
	return original.NewSQLPoolConnectionPoliciesClient(subscriptionID)
}
func NewSQLPoolConnectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolConnectionPoliciesClient {
	return original.NewSQLPoolConnectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolDataWarehouseUserActivitiesClient(subscriptionID string) SQLPoolDataWarehouseUserActivitiesClient {
	return original.NewSQLPoolDataWarehouseUserActivitiesClient(subscriptionID)
}
func NewSQLPoolDataWarehouseUserActivitiesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolDataWarehouseUserActivitiesClient {
	return original.NewSQLPoolDataWarehouseUserActivitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolGeoBackupPoliciesClient(subscriptionID string) SQLPoolGeoBackupPoliciesClient {
	return original.NewSQLPoolGeoBackupPoliciesClient(subscriptionID)
}
func NewSQLPoolGeoBackupPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolGeoBackupPoliciesClient {
	return original.NewSQLPoolGeoBackupPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolInfoListResultIterator(page SQLPoolInfoListResultPage) SQLPoolInfoListResultIterator {
	return original.NewSQLPoolInfoListResultIterator(page)
}
func NewSQLPoolInfoListResultPage(getNextPage func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)) SQLPoolInfoListResultPage {
	return original.NewSQLPoolInfoListResultPage(getNextPage)
}
func NewSQLPoolMetadataSyncConfigsClient(subscriptionID string) SQLPoolMetadataSyncConfigsClient {
	return original.NewSQLPoolMetadataSyncConfigsClient(subscriptionID)
}
func NewSQLPoolMetadataSyncConfigsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolMetadataSyncConfigsClient {
	return original.NewSQLPoolMetadataSyncConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolOperationResultsClient(subscriptionID string) SQLPoolOperationResultsClient {
	return original.NewSQLPoolOperationResultsClient(subscriptionID)
}
func NewSQLPoolOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolOperationResultsClient {
	return original.NewSQLPoolOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolOperationsClient(subscriptionID string) SQLPoolOperationsClient {
	return original.NewSQLPoolOperationsClient(subscriptionID)
}
func NewSQLPoolOperationsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolOperationsClient {
	return original.NewSQLPoolOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolReplicationLinksClient(subscriptionID string) SQLPoolReplicationLinksClient {
	return original.NewSQLPoolReplicationLinksClient(subscriptionID)
}
func NewSQLPoolReplicationLinksClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolReplicationLinksClient {
	return original.NewSQLPoolReplicationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolRestorePointsClient(subscriptionID string) SQLPoolRestorePointsClient {
	return original.NewSQLPoolRestorePointsClient(subscriptionID)
}
func NewSQLPoolRestorePointsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolRestorePointsClient {
	return original.NewSQLPoolRestorePointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSchemaListResultIterator(page SQLPoolSchemaListResultPage) SQLPoolSchemaListResultIterator {
	return original.NewSQLPoolSchemaListResultIterator(page)
}
func NewSQLPoolSchemaListResultPage(getNextPage func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)) SQLPoolSchemaListResultPage {
	return original.NewSQLPoolSchemaListResultPage(getNextPage)
}
func NewSQLPoolSchemasClient(subscriptionID string) SQLPoolSchemasClient {
	return original.NewSQLPoolSchemasClient(subscriptionID)
}
func NewSQLPoolSchemasClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSchemasClient {
	return original.NewSQLPoolSchemasClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSecurityAlertPoliciesClient(subscriptionID string) SQLPoolSecurityAlertPoliciesClient {
	return original.NewSQLPoolSecurityAlertPoliciesClient(subscriptionID)
}
func NewSQLPoolSecurityAlertPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSecurityAlertPoliciesClient {
	return original.NewSQLPoolSecurityAlertPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSensitivityLabelsClient(subscriptionID string) SQLPoolSensitivityLabelsClient {
	return original.NewSQLPoolSensitivityLabelsClient(subscriptionID)
}
func NewSQLPoolSensitivityLabelsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSensitivityLabelsClient {
	return original.NewSQLPoolSensitivityLabelsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTableColumnsClient(subscriptionID string) SQLPoolTableColumnsClient {
	return original.NewSQLPoolTableColumnsClient(subscriptionID)
}
func NewSQLPoolTableColumnsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTableColumnsClient {
	return original.NewSQLPoolTableColumnsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTableListResultIterator(page SQLPoolTableListResultPage) SQLPoolTableListResultIterator {
	return original.NewSQLPoolTableListResultIterator(page)
}
func NewSQLPoolTableListResultPage(getNextPage func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)) SQLPoolTableListResultPage {
	return original.NewSQLPoolTableListResultPage(getNextPage)
}
func NewSQLPoolTablesClient(subscriptionID string) SQLPoolTablesClient {
	return original.NewSQLPoolTablesClient(subscriptionID)
}
func NewSQLPoolTablesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTablesClient {
	return original.NewSQLPoolTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTransparentDataEncryptionsClient(subscriptionID string) SQLPoolTransparentDataEncryptionsClient {
	return original.NewSQLPoolTransparentDataEncryptionsClient(subscriptionID)
}
func NewSQLPoolTransparentDataEncryptionsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTransparentDataEncryptionsClient {
	return original.NewSQLPoolTransparentDataEncryptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolUsageListResultIterator(page SQLPoolUsageListResultPage) SQLPoolUsageListResultIterator {
	return original.NewSQLPoolUsageListResultIterator(page)
}
func NewSQLPoolUsageListResultPage(getNextPage func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)) SQLPoolUsageListResultPage {
	return original.NewSQLPoolUsageListResultPage(getNextPage)
}
func NewSQLPoolUsagesClient(subscriptionID string) SQLPoolUsagesClient {
	return original.NewSQLPoolUsagesClient(subscriptionID)
}
func NewSQLPoolUsagesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolUsagesClient {
	return original.NewSQLPoolUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentListResultIterator(page SQLPoolVulnerabilityAssessmentListResultPage) SQLPoolVulnerabilityAssessmentListResultIterator {
	return original.NewSQLPoolVulnerabilityAssessmentListResultIterator(page)
}
func NewSQLPoolVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)) SQLPoolVulnerabilityAssessmentListResultPage {
	return original.NewSQLPoolVulnerabilityAssessmentListResultPage(getNextPage)
}
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string) SQLPoolVulnerabilityAssessmentRuleBaselinesClient {
	return original.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentRuleBaselinesClient {
	return original.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return original.NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return original.NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentsClient(subscriptionID string) SQLPoolVulnerabilityAssessmentsClient {
	return original.NewSQLPoolVulnerabilityAssessmentsClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentsClient {
	return original.NewSQLPoolVulnerabilityAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolsClient(subscriptionID string) SQLPoolsClient {
	return original.NewSQLPoolsClient(subscriptionID)
}
func NewSQLPoolsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolsClient {
	return original.NewSQLPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return original.NewSensitivityLabelListResultIterator(page)
}
func NewSensitivityLabelListResultPage(getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return original.NewSensitivityLabelListResultPage(getNextPage)
}
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return original.NewVulnerabilityAssessmentScanRecordListResultIterator(page)
}
func NewVulnerabilityAssessmentScanRecordListResultPage(getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return original.NewVulnerabilityAssessmentScanRecordListResultPage(getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceAadAdminsClient(subscriptionID string) WorkspaceAadAdminsClient {
	return original.NewWorkspaceAadAdminsClient(subscriptionID)
}
func NewWorkspaceAadAdminsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceAadAdminsClient {
	return original.NewWorkspaceAadAdminsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceInfoListResultIterator(page WorkspaceInfoListResultPage) WorkspaceInfoListResultIterator {
	return original.NewWorkspaceInfoListResultIterator(page)
}
func NewWorkspaceInfoListResultPage(getNextPage func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)) WorkspaceInfoListResultPage {
	return original.NewWorkspaceInfoListResultPage(getNextPage)
}
func NewWorkspaceManagedIdentitySQLControlSettingsClient(subscriptionID string) WorkspaceManagedIdentitySQLControlSettingsClient {
	return original.NewWorkspaceManagedIdentitySQLControlSettingsClient(subscriptionID)
}
func NewWorkspaceManagedIdentitySQLControlSettingsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedIdentitySQLControlSettingsClient {
	return original.NewWorkspaceManagedIdentitySQLControlSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspacesClient(subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClient(subscriptionID)
}
func NewWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleActualStateValues() []ActualState {
	return original.PossibleActualStateValues()
}
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return original.PossibleBlobAuditingPolicyStateValues()
}
func PossibleColumnDataTypeValues() []ColumnDataType {
	return original.PossibleColumnDataTypeValues()
}
func PossibleDesiredStateValues() []DesiredState {
	return original.PossibleDesiredStateValues()
}
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return original.PossibleGeoBackupPolicyStateValues()
}
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return original.PossibleManagementOperationStateValues()
}
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return original.PossibleNodeSizeFamilyValues()
}
func PossibleNodeSizeValues() []NodeSize {
	return original.PossibleNodeSizeValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return original.PossibleQueryAggregationFunctionValues()
}
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return original.PossibleQueryExecutionTypeValues()
}
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return original.PossibleQueryMetricUnitValues()
}
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return original.PossibleQueryObservedMetricTypeValues()
}
func PossibleReplicationRoleValues() []ReplicationRole {
	return original.PossibleReplicationRoleValues()
}
func PossibleReplicationStateValues() []ReplicationState {
	return original.PossibleReplicationStateValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRestorePointTypeValues() []RestorePointType {
	return original.PossibleRestorePointTypeValues()
}
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return original.PossibleSecurityAlertPolicyStateValues()
}
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return original.PossibleTransparentDataEncryptionStatusValues()
}
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return original.PossibleVulnerabilityAssessmentPolicyBaselineNameValues()
}
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return original.PossibleVulnerabilityAssessmentScanStateValues()
}
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return original.PossibleVulnerabilityAssessmentScanTriggerTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
