package api

/************************************************
  generated by IDE. for [PrivateHostAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件リセット
func (api *PrivateHostAPI) Reset() *PrivateHostAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *PrivateHostAPI) Offset(offset int) *PrivateHostAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *PrivateHostAPI) Limit(limit int) *PrivateHostAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *PrivateHostAPI) Include(key string) *PrivateHostAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *PrivateHostAPI) Exclude(key string) *PrivateHostAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *PrivateHostAPI) FilterBy(key string, value interface{}) *PrivateHostAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *PrivateHostAPI) FilterMultiBy(key string, value interface{}) *PrivateHostAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *PrivateHostAPI) WithNameLike(name string) *PrivateHostAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *PrivateHostAPI) WithTag(tag string) *PrivateHostAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *PrivateHostAPI) WithTags(tags []string) *PrivateHostAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *PrivateHostAPI) WithSizeGib(size int) *PrivateHostAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *PrivateHostAPI) WithSharedScope() *PrivateHostAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *PrivateHostAPI) WithUserScope() *PrivateHostAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *PrivateHostAPI) SortBy(key string, reverse bool) *PrivateHostAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *PrivateHostAPI) SortByName(reverse bool) *PrivateHostAPI {
	api.sortByName(reverse)
	return api
}

// func (api *PrivateHostAPI) SortBySize(reverse bool) *PrivateHostAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件リセット
func (api *PrivateHostAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *PrivateHostAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *PrivateHostAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *PrivateHostAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *PrivateHostAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *PrivateHostAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *PrivateHostAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *PrivateHostAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *PrivateHostAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *PrivateHostAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *PrivateHostAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *PrivateHostAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *PrivateHostAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *PrivateHostAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *PrivateHostAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *PrivateHostAPI) SortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *PrivateHostAPI) New() *sacloud.PrivateHost {
	return &sacloud.PrivateHost{}
}

// Create 新規作成
func (api *PrivateHostAPI) Create(value *sacloud.PrivateHost) (*sacloud.PrivateHost, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *PrivateHostAPI) Read(id int64) (*sacloud.PrivateHost, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *PrivateHostAPI) Update(id int64, value *sacloud.PrivateHost) (*sacloud.PrivateHost, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *PrivateHostAPI) Delete(id int64) (*sacloud.PrivateHost, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *PrivateHostAPI) setStateValue(setFunc func(*sacloud.Request)) *PrivateHostAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *PrivateHostAPI) request(f func(*sacloud.Response) error) (*sacloud.PrivateHost, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.PrivateHost, nil
}

func (api *PrivateHostAPI) createRequest(value *sacloud.PrivateHost) *sacloud.Request {
	req := &sacloud.Request{}
	req.PrivateHost = value
	return req
}
