package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeviceShowList invokes the cloudwf.DeviceShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceshowlist.html
func (client *Client) DeviceShowList(request *DeviceShowListRequest) (response *DeviceShowListResponse, err error) {
	response = CreateDeviceShowListResponse()
	err = client.DoAction(request, response)
	return
}

// DeviceShowListWithChan invokes the cloudwf.DeviceShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceShowListWithChan(request *DeviceShowListRequest) (<-chan *DeviceShowListResponse, <-chan error) {
	responseChan := make(chan *DeviceShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeviceShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeviceShowListWithCallback invokes the cloudwf.DeviceShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceShowListWithCallback(request *DeviceShowListRequest, callback func(response *DeviceShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeviceShowListResponse
		var err error
		defer close(result)
		response, err = client.DeviceShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeviceShowListRequest is the request struct for api DeviceShowList
type DeviceShowListRequest struct {
	*requests.RpcRequest
	Dirc       string           `position:"Query" name:"Dirc"`
	Page       requests.Integer `position:"Query" name:"Page"`
	Per        requests.Integer `position:"Query" name:"Per"`
	DeviceType requests.Integer `position:"Query" name:"DeviceType"`
	Sid        requests.Integer `position:"Query" name:"Sid"`
}

// DeviceShowListResponse is the response struct for api DeviceShowList
type DeviceShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeviceShowListRequest creates a request to invoke DeviceShowList API
func CreateDeviceShowListRequest() (request *DeviceShowListRequest) {
	request = &DeviceShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeviceShowList", "cloudwf", "openAPI")
	return
}

// CreateDeviceShowListResponse creates a response to parse from DeviceShowList response
func CreateDeviceShowListResponse() (response *DeviceShowListResponse) {
	response = &DeviceShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
