package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainExtension invokes the slb.DeleteDomainExtension API synchronously
// api document: https://help.aliyun.com/api/slb/deletedomainextension.html
func (client *Client) DeleteDomainExtension(request *DeleteDomainExtensionRequest) (response *DeleteDomainExtensionResponse, err error) {
	response = CreateDeleteDomainExtensionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainExtensionWithChan invokes the slb.DeleteDomainExtension API asynchronously
// api document: https://help.aliyun.com/api/slb/deletedomainextension.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDomainExtensionWithChan(request *DeleteDomainExtensionRequest) (<-chan *DeleteDomainExtensionResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainExtensionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainExtension(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainExtensionWithCallback invokes the slb.DeleteDomainExtension API asynchronously
// api document: https://help.aliyun.com/api/slb/deletedomainextension.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDomainExtensionWithCallback(request *DeleteDomainExtensionRequest, callback func(response *DeleteDomainExtensionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainExtensionResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainExtension(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainExtensionRequest is the request struct for api DeleteDomainExtension
type DeleteDomainExtensionRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
	DomainExtensionId    string           `position:"Query" name:"DomainExtensionId"`
}

// DeleteDomainExtensionResponse is the response struct for api DeleteDomainExtension
type DeleteDomainExtensionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDomainExtensionRequest creates a request to invoke DeleteDomainExtension API
func CreateDeleteDomainExtensionRequest() (request *DeleteDomainExtensionRequest) {
	request = &DeleteDomainExtensionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DeleteDomainExtension", "slb", "openAPI")
	return
}

// CreateDeleteDomainExtensionResponse creates a response to parse from DeleteDomainExtension response
func CreateDeleteDomainExtensionResponse() (response *DeleteDomainExtensionResponse) {
	response = &DeleteDomainExtensionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
