package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExpressConnect invokes the vpc.DeleteExpressConnect API synchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpressconnect.html
func (client *Client) DeleteExpressConnect(request *DeleteExpressConnectRequest) (response *DeleteExpressConnectResponse, err error) {
	response = CreateDeleteExpressConnectResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExpressConnectWithChan invokes the vpc.DeleteExpressConnect API asynchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpressconnect.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteExpressConnectWithChan(request *DeleteExpressConnectRequest) (<-chan *DeleteExpressConnectResponse, <-chan error) {
	responseChan := make(chan *DeleteExpressConnectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExpressConnect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExpressConnectWithCallback invokes the vpc.DeleteExpressConnect API asynchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpressconnect.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteExpressConnectWithCallback(request *DeleteExpressConnectRequest, callback func(response *DeleteExpressConnectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExpressConnectResponse
		var err error
		defer close(result)
		response, err = client.DeleteExpressConnect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExpressConnectRequest is the request struct for api DeleteExpressConnect
type DeleteExpressConnectRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Force                requests.Boolean `position:"Query" name:"Force"`
	RouterInterfaceId    string           `position:"Query" name:"RouterInterfaceId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteExpressConnectResponse is the response struct for api DeleteExpressConnect
type DeleteExpressConnectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExpressConnectRequest creates a request to invoke DeleteExpressConnect API
func CreateDeleteExpressConnectRequest() (request *DeleteExpressConnectRequest) {
	request = &DeleteExpressConnectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteExpressConnect", "vpc", "openAPI")
	return
}

// CreateDeleteExpressConnectResponse creates a response to parse from DeleteExpressConnect response
func CreateDeleteExpressConnectResponse() (response *DeleteExpressConnectResponse) {
	response = &DeleteExpressConnectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
