package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DryRunRebuildAppEnv invokes the webplus.DryRunRebuildAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/dryrunrebuildappenv.html
func (client *Client) DryRunRebuildAppEnv(request *DryRunRebuildAppEnvRequest) (response *DryRunRebuildAppEnvResponse, err error) {
	response = CreateDryRunRebuildAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// DryRunRebuildAppEnvWithChan invokes the webplus.DryRunRebuildAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/dryrunrebuildappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DryRunRebuildAppEnvWithChan(request *DryRunRebuildAppEnvRequest) (<-chan *DryRunRebuildAppEnvResponse, <-chan error) {
	responseChan := make(chan *DryRunRebuildAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DryRunRebuildAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DryRunRebuildAppEnvWithCallback invokes the webplus.DryRunRebuildAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/dryrunrebuildappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DryRunRebuildAppEnvWithCallback(request *DryRunRebuildAppEnvRequest, callback func(response *DryRunRebuildAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DryRunRebuildAppEnvResponse
		var err error
		defer close(result)
		response, err = client.DryRunRebuildAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DryRunRebuildAppEnvRequest is the request struct for api DryRunRebuildAppEnv
type DryRunRebuildAppEnvRequest struct {
	*requests.RoaRequest
	EnvId string `position:"Body" name:"EnvId"`
}

// DryRunRebuildAppEnvResponse is the response struct for api DryRunRebuildAppEnv
type DryRunRebuildAppEnvResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	DryRunInfo DryRunInfo `json:"DryRunInfo" xml:"DryRunInfo"`
}

// CreateDryRunRebuildAppEnvRequest creates a request to invoke DryRunRebuildAppEnv API
func CreateDryRunRebuildAppEnvRequest() (request *DryRunRebuildAppEnvRequest) {
	request = &DryRunRebuildAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DryRunRebuildAppEnv", "/pop/v1/wam/appEnv/dryRunRebuild", "webx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDryRunRebuildAppEnvResponse creates a response to parse from DryRunRebuildAppEnv response
func CreateDryRunRebuildAppEnvResponse() (response *DryRunRebuildAppEnvResponse) {
	response = &DryRunRebuildAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
