package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateUser invokes the baas.OperateUser API synchronously
// api document: https://help.aliyun.com/api/baas/operateuser.html
func (client *Client) OperateUser(request *OperateUserRequest) (response *OperateUserResponse, err error) {
	response = CreateOperateUserResponse()
	err = client.DoAction(request, response)
	return
}

// OperateUserWithChan invokes the baas.OperateUser API asynchronously
// api document: https://help.aliyun.com/api/baas/operateuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateUserWithChan(request *OperateUserRequest) (<-chan *OperateUserResponse, <-chan error) {
	responseChan := make(chan *OperateUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateUserWithCallback invokes the baas.OperateUser API asynchronously
// api document: https://help.aliyun.com/api/baas/operateuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateUserWithCallback(request *OperateUserRequest, callback func(response *OperateUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateUserResponse
		var err error
		defer close(result)
		response, err = client.OperateUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateUserRequest is the request struct for api OperateUser
type OperateUserRequest struct {
	*requests.RpcRequest
	Bizid     string           `position:"Body" name:"Bizid"`
	Bid       string           `position:"Body" name:"Bid"`
	Operation requests.Integer `position:"Body" name:"Operation"`
	UserName  string           `position:"Body" name:"UserName"`
}

// OperateUserResponse is the response struct for api OperateUser
type OperateUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateOperateUserRequest creates a request to invoke OperateUser API
func CreateOperateUserRequest() (request *OperateUserRequest) {
	request = &OperateUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "OperateUser", "", "")
	return
}

// CreateOperateUserResponse creates a response to parse from OperateUser response
func CreateOperateUserResponse() (response *OperateUserResponse) {
	response = &OperateUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
