package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEnduserStatus invokes the bssopenapi.QueryEnduserStatus API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryenduserstatus.html
func (client *Client) QueryEnduserStatus(request *QueryEnduserStatusRequest) (response *QueryEnduserStatusResponse, err error) {
	response = CreateQueryEnduserStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEnduserStatusWithChan invokes the bssopenapi.QueryEnduserStatus API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryenduserstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryEnduserStatusWithChan(request *QueryEnduserStatusRequest) (<-chan *QueryEnduserStatusResponse, <-chan error) {
	responseChan := make(chan *QueryEnduserStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEnduserStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEnduserStatusWithCallback invokes the bssopenapi.QueryEnduserStatus API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryenduserstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryEnduserStatusWithCallback(request *QueryEnduserStatusRequest, callback func(response *QueryEnduserStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEnduserStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryEnduserStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEnduserStatusRequest is the request struct for api QueryEnduserStatus
type QueryEnduserStatusRequest struct {
	*requests.RpcRequest
	Uid            requests.Integer `position:"Query" name:"Uid"`
	PrimaryAccount string           `position:"Query" name:"PrimaryAccount"`
	Status         string           `position:"Query" name:"Status"`
	BusinessType   string           `position:"Query" name:"BusinessType"`
}

// QueryEnduserStatusResponse is the response struct for api QueryEnduserStatus
type QueryEnduserStatusResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      string                    `json:"Code" xml:"Code"`
	Message   string                    `json:"Message" xml:"Message"`
	Success   bool                      `json:"Success" xml:"Success"`
	Count     int                       `json:"Count" xml:"Count"`
	Datas     DatasInQueryEnduserStatus `json:"Datas" xml:"Datas"`
}

// CreateQueryEnduserStatusRequest creates a request to invoke QueryEnduserStatus API
func CreateQueryEnduserStatusRequest() (request *QueryEnduserStatusRequest) {
	request = &QueryEnduserStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryEnduserStatus", "", "")
	return
}

// CreateQueryEnduserStatusResponse creates a response to parse from QueryEnduserStatus response
func CreateQueryEnduserStatusResponse() (response *QueryEnduserStatusResponse) {
	response = &QueryEnduserStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
