package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDrdsInstance invokes the drds.CreateDrdsInstance API synchronously
// api document: https://help.aliyun.com/api/drds/createdrdsinstance.html
func (client *Client) CreateDrdsInstance(request *CreateDrdsInstanceRequest) (response *CreateDrdsInstanceResponse, err error) {
	response = CreateCreateDrdsInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDrdsInstanceWithChan invokes the drds.CreateDrdsInstance API asynchronously
// api document: https://help.aliyun.com/api/drds/createdrdsinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDrdsInstanceWithChan(request *CreateDrdsInstanceRequest) (<-chan *CreateDrdsInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateDrdsInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDrdsInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDrdsInstanceWithCallback invokes the drds.CreateDrdsInstance API asynchronously
// api document: https://help.aliyun.com/api/drds/createdrdsinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDrdsInstanceWithCallback(request *CreateDrdsInstanceRequest, callback func(response *CreateDrdsInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDrdsInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateDrdsInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDrdsInstanceRequest is the request struct for api CreateDrdsInstance
type CreateDrdsInstanceRequest struct {
	*requests.RpcRequest
	IsAutoRenew    requests.Boolean `position:"Query" name:"IsAutoRenew"`
	Quantity       requests.Integer `position:"Query" name:"Quantity"`
	ClientToken    string           `position:"Query" name:"ClientToken"`
	Description    string           `position:"Query" name:"Description"`
	Specification  string           `position:"Query" name:"Specification"`
	Type           string           `position:"Query" name:"Type"`
	VswitchId      string           `position:"Query" name:"VswitchId"`
	Duration       requests.Integer `position:"Query" name:"Duration"`
	IsHa           requests.Boolean `position:"Query" name:"IsHa"`
	InstanceSeries string           `position:"Query" name:"InstanceSeries"`
	VpcId          string           `position:"Query" name:"VpcId"`
	ZoneId         string           `position:"Query" name:"ZoneId"`
	PayType        string           `position:"Query" name:"PayType"`
	PricingCycle   string           `position:"Query" name:"PricingCycle"`
}

// CreateDrdsInstanceResponse is the response struct for api CreateDrdsInstance
type CreateDrdsInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDrdsInstanceRequest creates a request to invoke CreateDrdsInstance API
func CreateCreateDrdsInstanceRequest() (request *CreateDrdsInstanceRequest) {
	request = &CreateDrdsInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "CreateDrdsInstance", "", "")
	return
}

// CreateCreateDrdsInstanceResponse creates a response to parse from CreateDrdsInstance response
func CreateCreateDrdsInstanceResponse() (response *CreateDrdsInstanceResponse) {
	response = &CreateDrdsInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
