//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobDetail invokes the dts.DescribeMigrationJobDetail API synchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobdetail.html
func (client *Client) DescribeMigrationJobDetail(request *DescribeMigrationJobDetailRequest) (response *DescribeMigrationJobDetailResponse, err error) {
	response = CreateDescribeMigrationJobDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobDetailWithChan invokes the dts.DescribeMigrationJobDetail API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobDetailWithChan(request *DescribeMigrationJobDetailRequest) (<-chan *DescribeMigrationJobDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobDetailWithCallback invokes the dts.DescribeMigrationJobDetail API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobDetailWithCallback(request *DescribeMigrationJobDetailRequest, callback func(response *DescribeMigrationJobDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobDetailRequest is the request struct for api DescribeMigrationJobDetail
type DescribeMigrationJobDetailRequest struct {
	*requests.RpcRequest
	PageSize       requests.Integer                        `position:"Query" name:"PageSize"`
	PageNum        requests.Integer                        `position:"Query" name:"PageNum"`
	MigrationJobId string                                  `position:"Query" name:"MigrationJobId"`
	ClientToken    string                                  `position:"Query" name:"ClientToken"`
	OwnerId        string                                  `position:"Query" name:"OwnerId"`
	MigrationMode  DescribeMigrationJobDetailMigrationMode `position:"Query" name:"MigrationMode" type:"Struct"`
}

type DescribeMigrationJobDetailMigrationMode struct {
	StructureInitialization requests.Boolean `name:"StructureInitialization"`
	DataInitialization      requests.Boolean `name:"DataInitialization"`
	DataSynchronization     requests.Boolean `name:"DataSynchronization"`
}

// DescribeMigrationJobDetailResponse is the response struct for api DescribeMigrationJobDetail
type DescribeMigrationJobDetailResponse struct {
	*responses.BaseResponse
	PageNumber                        int                                                          `json:"PageNumber" xml:"PageNumber"`
	TotalRecordCount                  int64                                                        `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount                   int                                                          `json:"PageRecordCount" xml:"PageRecordCount"`
	StructureInitializationDetailList DescribeMigrationJobDetailStructureInitializationDetailList0 `json:"StructureInitializationDetailList" xml:"StructureInitializationDetailList"`
	DataInitializationDetailList      DescribeMigrationJobDetailDataInitializationDetailList0      `json:"DataInitializationDetailList" xml:"DataInitializationDetailList"`
	DataSynchronizationDetailList     DescribeMigrationJobDetailDataSynchronizationDetailList0     `json:"DataSynchronizationDetailList" xml:"DataSynchronizationDetailList"`
}

type DescribeMigrationJobDetailStructureInitializationDetailList0 struct {
	StructureInitializationDetail []DescribeMigrationJobDetailStructureInitializationDetail1 `json:"StructureInitializationDetail" xml:"StructureInitializationDetail"`
}

type DescribeMigrationJobDetailStructureInitializationDetail1 struct {
	ObjectName             string                                      `json:"ObjectName" xml:"ObjectName"`
	ObjectType             string                                      `json:"ObjectType" xml:"ObjectType"`
	SourceOwnerDBName      string                                      `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string                                      `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string                                      `json:"Status" xml:"Status"`
	ErrorMessage           string                                      `json:"ErrorMessage" xml:"ErrorMessage"`
	ObjectDefinition       string                                      `json:"ObjectDefinition" xml:"ObjectDefinition"`
	ConstraintList         []DescribeMigrationJobDetailConstraintList1 `json:"ConstraintList" xml:"ConstraintList"`
}

type DescribeMigrationJobDetailDataInitializationDetailList0 struct {
	DataInitializationDetail []DescribeMigrationJobDetailDataInitializationDetail1 `json:"DataInitializationDetail" xml:"DataInitializationDetail"`
}

type DescribeMigrationJobDetailDataInitializationDetail1 struct {
	TableName              string `json:"TableName" xml:"TableName"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
	TotalRowNum            string `json:"TotalRowNum" xml:"TotalRowNum"`
	FinishRowNum           string `json:"FinishRowNum" xml:"FinishRowNum"`
	MigrationTime          string `json:"MigrationTime" xml:"MigrationTime"`
}

type DescribeMigrationJobDetailDataSynchronizationDetailList0 struct {
	DataSynchronizationDetail []DescribeMigrationJobDetailDataSynchronizationDetail1 `json:"DataSynchronizationDetail" xml:"DataSynchronizationDetail"`
}

type DescribeMigrationJobDetailDataSynchronizationDetail1 struct {
	TableName              string `json:"TableName" xml:"TableName"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
}

type DescribeMigrationJobDetailConstraintList1 struct {
	StructureInitializationDetail []DescribeMigrationJobDetailStructureInitializationDetail2 `json:"StructureInitializationDetail" xml:"StructureInitializationDetail"`
}

type DescribeMigrationJobDetailStructureInitializationDetail2 struct {
	ObjectName             string `json:"ObjectName" xml:"ObjectName"`
	ObjectType             string `json:"ObjectType" xml:"ObjectType"`
	SourceOwnerDBName      string `json:"SourceOwnerDBName" xml:"SourceOwnerDBName"`
	DestinationOwnerDBName string `json:"DestinationOwnerDBName" xml:"DestinationOwnerDBName"`
	Status                 string `json:"Status" xml:"Status"`
	ErrorMessage           string `json:"ErrorMessage" xml:"ErrorMessage"`
	ObjectDefinition       string `json:"ObjectDefinition" xml:"ObjectDefinition"`
}

// CreateDescribeMigrationJobDetailRequest creates a request to invoke DescribeMigrationJobDetail API
func CreateDescribeMigrationJobDetailRequest() (request *DescribeMigrationJobDetailRequest) {
	request = &DescribeMigrationJobDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeMigrationJobDetail", "dts", "openAPI")
	return
}

// CreateDescribeMigrationJobDetailResponse creates a response to parse from DescribeMigrationJobDetail response
func CreateDescribeMigrationJobDetailResponse() (response *DescribeMigrationJobDetailResponse) {
	response = &DescribeMigrationJobDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
