package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePornBatchDetectJob invokes the imm.DeletePornBatchDetectJob API synchronously
// api document: https://help.aliyun.com/api/imm/deletepornbatchdetectjob.html
func (client *Client) DeletePornBatchDetectJob(request *DeletePornBatchDetectJobRequest) (response *DeletePornBatchDetectJobResponse, err error) {
	response = CreateDeletePornBatchDetectJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePornBatchDetectJobWithChan invokes the imm.DeletePornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/deletepornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePornBatchDetectJobWithChan(request *DeletePornBatchDetectJobRequest) (<-chan *DeletePornBatchDetectJobResponse, <-chan error) {
	responseChan := make(chan *DeletePornBatchDetectJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePornBatchDetectJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePornBatchDetectJobWithCallback invokes the imm.DeletePornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/deletepornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePornBatchDetectJobWithCallback(request *DeletePornBatchDetectJobRequest, callback func(response *DeletePornBatchDetectJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePornBatchDetectJobResponse
		var err error
		defer close(result)
		response, err = client.DeletePornBatchDetectJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePornBatchDetectJobRequest is the request struct for api DeletePornBatchDetectJob
type DeletePornBatchDetectJobRequest struct {
	*requests.RpcRequest
	JobId   string `position:"Query" name:"JobId"`
	Project string `position:"Query" name:"Project"`
}

// DeletePornBatchDetectJobResponse is the response struct for api DeletePornBatchDetectJob
type DeletePornBatchDetectJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePornBatchDetectJobRequest creates a request to invoke DeletePornBatchDetectJob API
func CreateDeletePornBatchDetectJobRequest() (request *DeletePornBatchDetectJobRequest) {
	request = &DeletePornBatchDetectJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeletePornBatchDetectJob", "imm", "openAPI")
	return
}

// CreateDeletePornBatchDetectJobResponse creates a response to parse from DeletePornBatchDetectJob response
func CreateDeletePornBatchDetectJobResponse() (response *DeletePornBatchDetectJobResponse) {
	response = &DeletePornBatchDetectJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
