/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"time"

	v2alpha1 "github.com/submariner-io/lighthouse/pkg/apis/lighthouse.submariner.io/v2alpha1"
	scheme "github.com/submariner-io/lighthouse/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceExportsGetter has a method to return a ServiceExportInterface.
// A group's client should implement this interface.
type ServiceExportsGetter interface {
	ServiceExports(namespace string) ServiceExportInterface
}

// ServiceExportInterface has methods to work with ServiceExport resources.
type ServiceExportInterface interface {
	Create(*v2alpha1.ServiceExport) (*v2alpha1.ServiceExport, error)
	Update(*v2alpha1.ServiceExport) (*v2alpha1.ServiceExport, error)
	UpdateStatus(*v2alpha1.ServiceExport) (*v2alpha1.ServiceExport, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v2alpha1.ServiceExport, error)
	List(opts v1.ListOptions) (*v2alpha1.ServiceExportList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v2alpha1.ServiceExport, err error)
	ServiceExportExpansion
}

// serviceExports implements ServiceExportInterface
type serviceExports struct {
	client rest.Interface
	ns     string
}

// newServiceExports returns a ServiceExports
func newServiceExports(c *LighthouseV2alpha1Client, namespace string) *serviceExports {
	return &serviceExports{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the serviceExport, and returns the corresponding serviceExport object, and an error if there is any.
func (c *serviceExports) Get(name string, options v1.GetOptions) (result *v2alpha1.ServiceExport, err error) {
	result = &v2alpha1.ServiceExport{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("serviceexports").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceExports that match those selectors.
func (c *serviceExports) List(opts v1.ListOptions) (result *v2alpha1.ServiceExportList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.ServiceExportList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("serviceexports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceExports.
func (c *serviceExports) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("serviceexports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a serviceExport and creates it.  Returns the server's representation of the serviceExport, and an error, if there is any.
func (c *serviceExports) Create(serviceExport *v2alpha1.ServiceExport) (result *v2alpha1.ServiceExport, err error) {
	result = &v2alpha1.ServiceExport{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("serviceexports").
		Body(serviceExport).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceExport and updates it. Returns the server's representation of the serviceExport, and an error, if there is any.
func (c *serviceExports) Update(serviceExport *v2alpha1.ServiceExport) (result *v2alpha1.ServiceExport, err error) {
	result = &v2alpha1.ServiceExport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("serviceexports").
		Name(serviceExport.Name).
		Body(serviceExport).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceExports) UpdateStatus(serviceExport *v2alpha1.ServiceExport) (result *v2alpha1.ServiceExport, err error) {
	result = &v2alpha1.ServiceExport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("serviceexports").
		Name(serviceExport.Name).
		SubResource("status").
		Body(serviceExport).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceExport and deletes it. Returns an error if one occurs.
func (c *serviceExports) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("serviceexports").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceExports) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("serviceexports").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceExport.
func (c *serviceExports) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v2alpha1.ServiceExport, err error) {
	result = &v2alpha1.ServiceExport{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("serviceexports").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
