package api

/************************************************
  generated by IDE. for [NFSAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *NFSAPI) Reset() *NFSAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *NFSAPI) Offset(offset int) *NFSAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *NFSAPI) Limit(limit int) *NFSAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *NFSAPI) Include(key string) *NFSAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *NFSAPI) Exclude(key string) *NFSAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *NFSAPI) FilterBy(key string, value interface{}) *NFSAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *NFSAPI) FilterMultiBy(key string, value interface{}) *NFSAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *NFSAPI) WithNameLike(name string) *NFSAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *NFSAPI) WithTag(tag string) *NFSAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *NFSAPI) WithTags(tags []string) *NFSAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *NFSAPI) WithSizeGib(size int) *NFSAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *NFSAPI) WithSharedScope() *NFSAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *NFSAPI) WithUserScope() *NFSAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *NFSAPI) SortBy(key string, reverse bool) *NFSAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *NFSAPI) SortByName(reverse bool) *NFSAPI {
	api.sortByName(reverse)
	return api
}

// func (api *NFSAPI) SortBySize(reverse bool) *NFSAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *NFSAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *NFSAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *NFSAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *NFSAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *NFSAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *NFSAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *NFSAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *NFSAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *NFSAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *NFSAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *NFSAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *NFSAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *NFSAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *NFSAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *NFSAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *NFSAPI) SortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// func (api *NFSAPI) New() *sacloud.NFS {
// 	return &sacloud.NFS{}
// }

// func (api *NFSAPI) Create(value *sacloud.NFS) (*sacloud.NFS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// func (api *NFSAPI) Read(id string) (*sacloud.NFS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.read(id, nil, res)
// 	})
// }

// func (api *NFSAPI) Update(id string, value *sacloud.NFS) (*sacloud.NFS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *NFSAPI) Delete(id string) (*sacloud.NFS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *NFSAPI) setStateValue(setFunc func(*sacloud.Request)) *NFSAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

//func (api *NFSAPI) request(f func(*sacloud.Response) error) (*sacloud.NFS, error) {
//	res := &sacloud.Response{}
//	err := f(res)
//	if err != nil {
//		return nil, err
//	}
//	return res.NFS, nil
//}
//
//func (api *NFSAPI) createRequest(value *sacloud.NFS) *sacloud.Request {
//	req := &sacloud.Request{}
//	req.NFS = value
//	return req
//}
