// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/openshift/assisted-service/models"
)

// DownloadClusterISOHeadersReader is a Reader for the DownloadClusterISOHeaders structure.
type DownloadClusterISOHeadersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DownloadClusterISOHeadersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadClusterISOHeadersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDownloadClusterISOHeadersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDownloadClusterISOHeadersUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadClusterISOHeadersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDownloadClusterISOHeadersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewDownloadClusterISOHeadersMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDownloadClusterISOHeadersConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadClusterISOHeadersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadClusterISOHeadersOK creates a DownloadClusterISOHeadersOK with default headers values
func NewDownloadClusterISOHeadersOK() *DownloadClusterISOHeadersOK {
	return &DownloadClusterISOHeadersOK{}
}

/*DownloadClusterISOHeadersOK handles this case with default header values.

Success.
*/
type DownloadClusterISOHeadersOK struct {
	/*Size of the ISO in bytes
	 */
	ContentLength int64
}

func (o *DownloadClusterISOHeadersOK) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersOK ", 200)
}

func (o *DownloadClusterISOHeadersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response header Content-Length
	contentLength, err := swag.ConvertInt64(response.GetHeader("Content-Length"))
	if err != nil {
		return errors.InvalidType("Content-Length", "header", "int64", response.GetHeader("Content-Length"))
	}
	o.ContentLength = contentLength

	return nil
}

// NewDownloadClusterISOHeadersBadRequest creates a DownloadClusterISOHeadersBadRequest with default headers values
func NewDownloadClusterISOHeadersBadRequest() *DownloadClusterISOHeadersBadRequest {
	return &DownloadClusterISOHeadersBadRequest{}
}

/*DownloadClusterISOHeadersBadRequest handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersBadRequest struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersBadRequest) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersBadRequest  %+v", 400, o.Payload)
}

func (o *DownloadClusterISOHeadersBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersUnauthorized creates a DownloadClusterISOHeadersUnauthorized with default headers values
func NewDownloadClusterISOHeadersUnauthorized() *DownloadClusterISOHeadersUnauthorized {
	return &DownloadClusterISOHeadersUnauthorized{}
}

/*DownloadClusterISOHeadersUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadClusterISOHeadersUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadClusterISOHeadersUnauthorized) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadClusterISOHeadersUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterISOHeadersUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersForbidden creates a DownloadClusterISOHeadersForbidden with default headers values
func NewDownloadClusterISOHeadersForbidden() *DownloadClusterISOHeadersForbidden {
	return &DownloadClusterISOHeadersForbidden{}
}

/*DownloadClusterISOHeadersForbidden handles this case with default header values.

Forbidden.
*/
type DownloadClusterISOHeadersForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadClusterISOHeadersForbidden) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersForbidden  %+v", 403, o.Payload)
}

func (o *DownloadClusterISOHeadersForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterISOHeadersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersNotFound creates a DownloadClusterISOHeadersNotFound with default headers values
func NewDownloadClusterISOHeadersNotFound() *DownloadClusterISOHeadersNotFound {
	return &DownloadClusterISOHeadersNotFound{}
}

/*DownloadClusterISOHeadersNotFound handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersNotFound struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersNotFound) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersNotFound  %+v", 404, o.Payload)
}

func (o *DownloadClusterISOHeadersNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersMethodNotAllowed creates a DownloadClusterISOHeadersMethodNotAllowed with default headers values
func NewDownloadClusterISOHeadersMethodNotAllowed() *DownloadClusterISOHeadersMethodNotAllowed {
	return &DownloadClusterISOHeadersMethodNotAllowed{}
}

/*DownloadClusterISOHeadersMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type DownloadClusterISOHeadersMethodNotAllowed struct {
}

func (o *DownloadClusterISOHeadersMethodNotAllowed) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersMethodNotAllowed ", 405)
}

func (o *DownloadClusterISOHeadersMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDownloadClusterISOHeadersConflict creates a DownloadClusterISOHeadersConflict with default headers values
func NewDownloadClusterISOHeadersConflict() *DownloadClusterISOHeadersConflict {
	return &DownloadClusterISOHeadersConflict{}
}

/*DownloadClusterISOHeadersConflict handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersConflict struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersConflict) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersConflict  %+v", 409, o.Payload)
}

func (o *DownloadClusterISOHeadersConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersInternalServerError creates a DownloadClusterISOHeadersInternalServerError with default headers values
func NewDownloadClusterISOHeadersInternalServerError() *DownloadClusterISOHeadersInternalServerError {
	return &DownloadClusterISOHeadersInternalServerError{}
}

/*DownloadClusterISOHeadersInternalServerError handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersInternalServerError) Error() string {
	return fmt.Sprintf("[HEAD /v1/clusters/{cluster_id}/downloads/image][%d] downloadClusterISOHeadersInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadClusterISOHeadersInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
