// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/openshift/assisted-service/models"
)

// DownloadInfraEnvDiscoveryImageHeadersReader is a Reader for the DownloadInfraEnvDiscoveryImageHeaders structure.
type DownloadInfraEnvDiscoveryImageHeadersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DownloadInfraEnvDiscoveryImageHeadersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadInfraEnvDiscoveryImageHeadersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDownloadInfraEnvDiscoveryImageHeadersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDownloadInfraEnvDiscoveryImageHeadersUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadInfraEnvDiscoveryImageHeadersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDownloadInfraEnvDiscoveryImageHeadersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewDownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDownloadInfraEnvDiscoveryImageHeadersConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadInfraEnvDiscoveryImageHeadersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewDownloadInfraEnvDiscoveryImageHeadersNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadInfraEnvDiscoveryImageHeadersOK creates a DownloadInfraEnvDiscoveryImageHeadersOK with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersOK() *DownloadInfraEnvDiscoveryImageHeadersOK {
	return &DownloadInfraEnvDiscoveryImageHeadersOK{}
}

/*DownloadInfraEnvDiscoveryImageHeadersOK handles this case with default header values.

Success.
*/
type DownloadInfraEnvDiscoveryImageHeadersOK struct {
	/*Size of the ISO in bytes
	 */
	ContentLength int64
}

func (o *DownloadInfraEnvDiscoveryImageHeadersOK) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersOK ", 200)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response header Content-Length
	contentLength, err := swag.ConvertInt64(response.GetHeader("Content-Length"))
	if err != nil {
		return errors.InvalidType("Content-Length", "header", "int64", response.GetHeader("Content-Length"))
	}
	o.ContentLength = contentLength

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersBadRequest creates a DownloadInfraEnvDiscoveryImageHeadersBadRequest with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersBadRequest() *DownloadInfraEnvDiscoveryImageHeadersBadRequest {
	return &DownloadInfraEnvDiscoveryImageHeadersBadRequest{}
}

/*DownloadInfraEnvDiscoveryImageHeadersBadRequest handles this case with default header values.

Error.
*/
type DownloadInfraEnvDiscoveryImageHeadersBadRequest struct {
	Payload *models.Error
}

func (o *DownloadInfraEnvDiscoveryImageHeadersBadRequest) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersBadRequest  %+v", 400, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersUnauthorized creates a DownloadInfraEnvDiscoveryImageHeadersUnauthorized with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersUnauthorized() *DownloadInfraEnvDiscoveryImageHeadersUnauthorized {
	return &DownloadInfraEnvDiscoveryImageHeadersUnauthorized{}
}

/*DownloadInfraEnvDiscoveryImageHeadersUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadInfraEnvDiscoveryImageHeadersUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadInfraEnvDiscoveryImageHeadersUnauthorized) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersForbidden creates a DownloadInfraEnvDiscoveryImageHeadersForbidden with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersForbidden() *DownloadInfraEnvDiscoveryImageHeadersForbidden {
	return &DownloadInfraEnvDiscoveryImageHeadersForbidden{}
}

/*DownloadInfraEnvDiscoveryImageHeadersForbidden handles this case with default header values.

Forbidden.
*/
type DownloadInfraEnvDiscoveryImageHeadersForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadInfraEnvDiscoveryImageHeadersForbidden) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersForbidden  %+v", 403, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersNotFound creates a DownloadInfraEnvDiscoveryImageHeadersNotFound with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersNotFound() *DownloadInfraEnvDiscoveryImageHeadersNotFound {
	return &DownloadInfraEnvDiscoveryImageHeadersNotFound{}
}

/*DownloadInfraEnvDiscoveryImageHeadersNotFound handles this case with default header values.

Error.
*/
type DownloadInfraEnvDiscoveryImageHeadersNotFound struct {
	Payload *models.Error
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotFound) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersNotFound  %+v", 404, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed creates a DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed() *DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed {
	return &DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed{}
}

/*DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed struct {
}

func (o *DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersMethodNotAllowed ", 405)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersConflict creates a DownloadInfraEnvDiscoveryImageHeadersConflict with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersConflict() *DownloadInfraEnvDiscoveryImageHeadersConflict {
	return &DownloadInfraEnvDiscoveryImageHeadersConflict{}
}

/*DownloadInfraEnvDiscoveryImageHeadersConflict handles this case with default header values.

Error.
*/
type DownloadInfraEnvDiscoveryImageHeadersConflict struct {
	Payload *models.Error
}

func (o *DownloadInfraEnvDiscoveryImageHeadersConflict) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersConflict  %+v", 409, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersInternalServerError creates a DownloadInfraEnvDiscoveryImageHeadersInternalServerError with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersInternalServerError() *DownloadInfraEnvDiscoveryImageHeadersInternalServerError {
	return &DownloadInfraEnvDiscoveryImageHeadersInternalServerError{}
}

/*DownloadInfraEnvDiscoveryImageHeadersInternalServerError handles this case with default header values.

Error.
*/
type DownloadInfraEnvDiscoveryImageHeadersInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadInfraEnvDiscoveryImageHeadersInternalServerError) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadInfraEnvDiscoveryImageHeadersNotImplemented creates a DownloadInfraEnvDiscoveryImageHeadersNotImplemented with default headers values
func NewDownloadInfraEnvDiscoveryImageHeadersNotImplemented() *DownloadInfraEnvDiscoveryImageHeadersNotImplemented {
	return &DownloadInfraEnvDiscoveryImageHeadersNotImplemented{}
}

/*DownloadInfraEnvDiscoveryImageHeadersNotImplemented handles this case with default header values.

Not implemented.
*/
type DownloadInfraEnvDiscoveryImageHeadersNotImplemented struct {
	Payload *models.Error
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotImplemented) Error() string {
	return fmt.Sprintf("[HEAD /v2/infra-envs/{infra_env_id}/downloads/image][%d] downloadInfraEnvDiscoveryImageHeadersNotImplemented  %+v", 501, o.Payload)
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotImplemented) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadInfraEnvDiscoveryImageHeadersNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
