// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// InstallClusterReader is a Reader for the InstallCluster structure.
type InstallClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InstallClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewInstallClusterAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewInstallClusterBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewInstallClusterUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewInstallClusterForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewInstallClusterNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewInstallClusterMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewInstallClusterConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewInstallClusterInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewInstallClusterAccepted creates a InstallClusterAccepted with default headers values
func NewInstallClusterAccepted() *InstallClusterAccepted {
	return &InstallClusterAccepted{}
}

/*InstallClusterAccepted handles this case with default header values.

Success.
*/
type InstallClusterAccepted struct {
	Payload *models.Cluster
}

func (o *InstallClusterAccepted) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterAccepted  %+v", 202, o.Payload)
}

func (o *InstallClusterAccepted) GetPayload() *models.Cluster {
	return o.Payload
}

func (o *InstallClusterAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Cluster)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterBadRequest creates a InstallClusterBadRequest with default headers values
func NewInstallClusterBadRequest() *InstallClusterBadRequest {
	return &InstallClusterBadRequest{}
}

/*InstallClusterBadRequest handles this case with default header values.

Error.
*/
type InstallClusterBadRequest struct {
	Payload *models.Error
}

func (o *InstallClusterBadRequest) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterBadRequest  %+v", 400, o.Payload)
}

func (o *InstallClusterBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallClusterBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterUnauthorized creates a InstallClusterUnauthorized with default headers values
func NewInstallClusterUnauthorized() *InstallClusterUnauthorized {
	return &InstallClusterUnauthorized{}
}

/*InstallClusterUnauthorized handles this case with default header values.

Unauthorized.
*/
type InstallClusterUnauthorized struct {
	Payload *models.InfraError
}

func (o *InstallClusterUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterUnauthorized  %+v", 401, o.Payload)
}

func (o *InstallClusterUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *InstallClusterUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterForbidden creates a InstallClusterForbidden with default headers values
func NewInstallClusterForbidden() *InstallClusterForbidden {
	return &InstallClusterForbidden{}
}

/*InstallClusterForbidden handles this case with default header values.

Forbidden.
*/
type InstallClusterForbidden struct {
	Payload *models.InfraError
}

func (o *InstallClusterForbidden) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterForbidden  %+v", 403, o.Payload)
}

func (o *InstallClusterForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *InstallClusterForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterNotFound creates a InstallClusterNotFound with default headers values
func NewInstallClusterNotFound() *InstallClusterNotFound {
	return &InstallClusterNotFound{}
}

/*InstallClusterNotFound handles this case with default header values.

Error.
*/
type InstallClusterNotFound struct {
	Payload *models.Error
}

func (o *InstallClusterNotFound) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterNotFound  %+v", 404, o.Payload)
}

func (o *InstallClusterNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallClusterNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterMethodNotAllowed creates a InstallClusterMethodNotAllowed with default headers values
func NewInstallClusterMethodNotAllowed() *InstallClusterMethodNotAllowed {
	return &InstallClusterMethodNotAllowed{}
}

/*InstallClusterMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type InstallClusterMethodNotAllowed struct {
	Payload *models.Error
}

func (o *InstallClusterMethodNotAllowed) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterMethodNotAllowed  %+v", 405, o.Payload)
}

func (o *InstallClusterMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallClusterMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterConflict creates a InstallClusterConflict with default headers values
func NewInstallClusterConflict() *InstallClusterConflict {
	return &InstallClusterConflict{}
}

/*InstallClusterConflict handles this case with default header values.

Error.
*/
type InstallClusterConflict struct {
	Payload *models.Error
}

func (o *InstallClusterConflict) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterConflict  %+v", 409, o.Payload)
}

func (o *InstallClusterConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallClusterConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInstallClusterInternalServerError creates a InstallClusterInternalServerError with default headers values
func NewInstallClusterInternalServerError() *InstallClusterInternalServerError {
	return &InstallClusterInternalServerError{}
}

/*InstallClusterInternalServerError handles this case with default header values.

Error.
*/
type InstallClusterInternalServerError struct {
	Payload *models.Error
}

func (o *InstallClusterInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v1/clusters/{cluster_id}/actions/install][%d] installClusterInternalServerError  %+v", 500, o.Payload)
}

func (o *InstallClusterInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *InstallClusterInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
