// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the installer client
type API interface {
	/*
	   BindHost Bind host to a cluster*/
	BindHost(ctx context.Context, params *BindHostParams) (*BindHostOK, error)
	/*
	   CancelInstallation Cancels an ongoing installation.*/
	CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error)
	/*
	   CompleteInstallation Agent API to mark a finalizing installation as complete.*/
	CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error)
	/*
	   DeregisterCluster Deletes an OpenShift cluster definition.*/
	DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error)
	/*
	   DeregisterHost Deregisters an OpenShift host.*/
	DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error)
	/*
	   DeregisterInfraEnv Deletes an InfraEnv.*/
	DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error)
	/*
	   DisableHost Disables a host for inclusion in the cluster.*/
	DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error)
	/*
	   DownloadClusterFiles Downloads files relating to the installed/installing cluster.*/
	DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error)
	/*
	   DownloadClusterISO Downloads the OpenShift per-cluster Discovery ISO.*/
	DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error)
	/*
	   DownloadClusterISOHeaders Downloads the OpenShift per-cluster Discovery ISO Headers only.*/
	DownloadClusterISOHeaders(ctx context.Context, params *DownloadClusterISOHeadersParams) (*DownloadClusterISOHeadersOK, error)
	/*
	   DownloadClusterKubeconfig Downloads the kubeconfig file for this cluster.*/
	DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error)
	/*
	   DownloadClusterLogs Download cluster logs.*/
	DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error)
	/*
	   DownloadHostIgnition Downloads the customized ignition file for this host, produces octet string*/
	DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error)
	/*
	   DownloadHostLogs Download host logs.*/
	DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error)
	/*
	   DownloadInfraEnvDiscoveryImage Downloads the discovery image.*/
	DownloadInfraEnvDiscoveryImage(ctx context.Context, params *DownloadInfraEnvDiscoveryImageParams, writer io.Writer) (*DownloadInfraEnvDiscoveryImageOK, error)
	/*
	   DownloadInfraEnvDiscoveryImageHeaders Downloads the discovery image Headers only.*/
	DownloadInfraEnvDiscoveryImageHeaders(ctx context.Context, params *DownloadInfraEnvDiscoveryImageHeadersParams) (*DownloadInfraEnvDiscoveryImageHeadersOK, error)
	/*
	   DownloadMinimalInitrd Get the initial ramdisk for minimal ISO based installations.
	*/
	DownloadMinimalInitrd(ctx context.Context, params *DownloadMinimalInitrdParams, writer io.Writer) (*DownloadMinimalInitrdOK, *DownloadMinimalInitrdNoContent, error)
	/*
	   EnableHost Enables a host for inclusion in the cluster.*/
	EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error)
	/*
	   GenerateClusterISO Creates a new OpenShift per-cluster Discovery ISO.*/
	GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error)
	/*
	   GetCluster Retrieves the details of the OpenShift cluster.*/
	GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error)
	/*
	   GetClusterDefaultConfig Get the default values for various cluster properties.*/
	GetClusterDefaultConfig(ctx context.Context, params *GetClusterDefaultConfigParams) (*GetClusterDefaultConfigOK, error)
	/*
	   GetClusterHostRequirements Get host requirements of a cluster.*/
	GetClusterHostRequirements(ctx context.Context, params *GetClusterHostRequirementsParams) (*GetClusterHostRequirementsOK, error)
	/*
	   GetClusterInstallConfig Get the cluster's install config YAML.*/
	GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error)
	/*
	   GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.*/
	GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error)
	/*
	   GetCredentials Get the cluster admin credentials.*/
	GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error)
	/*
	   GetDiscoveryIgnition Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.
	   Used to test the validity of the discovery ignition when it is being overridden.
	   For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign
	*/
	GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error)
	/*
	   GetFreeAddresses Retrieves the free address list for a network.*/
	GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error)
	/*
	   GetHost Retrieves the details of the OpenShift host.*/
	GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error)
	/*
	   GetHostIgnition Get the customized ignition file for this host as a string*/
	GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error)
	/*
	   GetInfraEnv Retrieves the details of the InfraEnv.*/
	GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error)
	/*
	   GetPreflightRequirements Get preflight requirements for a cluster.*/
	GetPreflightRequirements(ctx context.Context, params *GetPreflightRequirementsParams) (*GetPreflightRequirementsOK, error)
	/*
	   GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.*/
	GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error)
	/*
	   InstallCluster Installs the OpenShift cluster.*/
	InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error)
	/*
	   InstallHost install specific host for day2 cluster.*/
	InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error)
	/*
	   InstallHosts Installs the OpenShift cluster.*/
	InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error)
	/*
	   ListClusters Retrieves the list of OpenShift clusters.*/
	ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error)
	/*
	   ListHosts Retrieves the list of OpenShift hosts.*/
	ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error)
	/*
	   ListInfraEnvs Retrieves the list of InfraEnvs.*/
	ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error)
	/*
	   RegisterAddHostsCluster Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.*/
	RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error)
	/*
	   RegisterCluster Creates a new OpenShift cluster definition.*/
	RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error)
	/*
	   RegisterInfraEnv Creates a new OpenShift Discovery ISO.*/
	RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error)
	/*
	   ResetCluster Resets a failed installation.*/
	ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error)
	/*
	   ResetHost reset a failed host for day2 cluster.*/
	ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error)
	/*
	   ResetHostValidation resets failed host validation

	   Reset failed host validation.  It may be performed on any host validation with persistent validation result.*/
	ResetHostValidation(ctx context.Context, params *ResetHostValidationParams) (*ResetHostValidationOK, error)
	/*
	   UnbindHost Unbind host to a cluster*/
	UnbindHost(ctx context.Context, params *UnbindHostParams) (*UnbindHostOK, error)
	/*
	   UpdateCluster Updates an OpenShift cluster definition.*/
	UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error)
	/*
	   UpdateClusterInstallConfig Override values in the install config.*/
	UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error)
	/*
	   UpdateClusterLogsProgress Update log collection state and progress.*/
	UpdateClusterLogsProgress(ctx context.Context, params *UpdateClusterLogsProgressParams) (*UpdateClusterLogsProgressNoContent, error)
	/*
	   UpdateDiscoveryIgnition Override values in the discovery ignition config.*/
	UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error)
	/*
	   UpdateHostIgnition Patch the ignition file for this host*/
	UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error)
	/*
	   UpdateHostInstallProgress Update installation progress.*/
	UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error)
	/*
	   UpdateHostInstallerArgs Updates a host's installer arguments.*/
	UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error)
	/*
	   UpdateHostLogsProgress Update log collection state and progress.*/
	UpdateHostLogsProgress(ctx context.Context, params *UpdateHostLogsProgressParams) (*UpdateHostLogsProgressNoContent, error)
	/*
	   UpdateInfraEnv Updates an InfraEnv.*/
	UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error)
	/*
	   UploadClusterIngressCert Transfer the ingress certificate for the cluster.*/
	UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error)
	/*
	   UploadHostLogs Agent API to upload logs.*/
	UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error)
	/*
	   UploadLogs Agent API to upload logs.*/
	UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error)
	/*
	   V2CancelInstallation Cancels an ongoing installation.*/
	V2CancelInstallation(ctx context.Context, params *V2CancelInstallationParams) (*V2CancelInstallationAccepted, error)
	/*
	   V2DownloadClusterCredentials Downloads credentials relating to the installed/installing cluster.*/
	V2DownloadClusterCredentials(ctx context.Context, params *V2DownloadClusterCredentialsParams, writer io.Writer) (*V2DownloadClusterCredentialsOK, error)
	/*
	   V2DownloadClusterFiles Downloads files relating to the installed/installing cluster.*/
	V2DownloadClusterFiles(ctx context.Context, params *V2DownloadClusterFilesParams, writer io.Writer) (*V2DownloadClusterFilesOK, error)
	/*
	   V2DownloadClusterLogs Download cluster logs.*/
	V2DownloadClusterLogs(ctx context.Context, params *V2DownloadClusterLogsParams, writer io.Writer) (*V2DownloadClusterLogsOK, error)
	/*
	   V2GetClusterDefaultConfig Get the default values for various cluster properties.*/
	V2GetClusterDefaultConfig(ctx context.Context, params *V2GetClusterDefaultConfigParams) (*V2GetClusterDefaultConfigOK, error)
	/*
	   V2GetCredentials Get the cluster admin credentials.*/
	V2GetCredentials(ctx context.Context, params *V2GetCredentialsParams) (*V2GetCredentialsOK, error)
	/*
	   V2GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.*/
	V2GetPresignedForClusterFiles(ctx context.Context, params *V2GetPresignedForClusterFilesParams) (*V2GetPresignedForClusterFilesOK, error)
	/*
	   V2UpdateCluster Updates an OpenShift cluster definition.*/
	V2UpdateCluster(ctx context.Context, params *V2UpdateClusterParams) (*V2UpdateClusterCreated, error)
	/*
	   V2UploadLogs Agent API to upload logs.*/
	V2UploadLogs(ctx context.Context, params *V2UploadLogsParams) (*V2UploadLogsNoContent, error)
	/*
	   V2CompleteInstallation Agent API to mark a finalizing installation as complete.*/
	V2CompleteInstallation(ctx context.Context, params *V2CompleteInstallationParams) (*V2CompleteInstallationAccepted, error)
	/*
	   V2DeregisterCluster Deletes an OpenShift cluster definition.*/
	V2DeregisterCluster(ctx context.Context, params *V2DeregisterClusterParams) (*V2DeregisterClusterNoContent, error)
	/*
	   V2DeregisterHost Deregisters an OpenShift host.*/
	V2DeregisterHost(ctx context.Context, params *V2DeregisterHostParams) (*V2DeregisterHostNoContent, error)
	/*
	   V2DownloadHostIgnition Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned*/
	V2DownloadHostIgnition(ctx context.Context, params *V2DownloadHostIgnitionParams, writer io.Writer) (*V2DownloadHostIgnitionOK, error)
	/*
	   V2DownloadInfraEnvFiles Downloads the customized ignition file for this host*/
	V2DownloadInfraEnvFiles(ctx context.Context, params *V2DownloadInfraEnvFilesParams, writer io.Writer) (*V2DownloadInfraEnvFilesOK, error)
	/*
	   V2GetCluster Retrieves the details of the OpenShift cluster.*/
	V2GetCluster(ctx context.Context, params *V2GetClusterParams) (*V2GetClusterOK, error)
	/*
	   V2GetClusterInstallConfig Get the cluster's install config YAML.*/
	V2GetClusterInstallConfig(ctx context.Context, params *V2GetClusterInstallConfigParams) (*V2GetClusterInstallConfigOK, error)
	/*
	   V2GetHost Retrieves the details of the OpenShift host.*/
	V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error)
	/*
	   V2GetHostIgnition Fetch the ignition file for this host as a string. In case of unbound host produces an error*/
	V2GetHostIgnition(ctx context.Context, params *V2GetHostIgnitionParams) (*V2GetHostIgnitionOK, error)
	/*
	   V2GetNextSteps Retrieves the next operations that the host agent needs to perform.*/
	V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error)
	/*
	   V2GetPreflightRequirements Get preflight requirements for a cluster.*/
	V2GetPreflightRequirements(ctx context.Context, params *V2GetPreflightRequirementsParams) (*V2GetPreflightRequirementsOK, error)
	/*
	   V2InstallCluster Installs the OpenShift cluster.*/
	V2InstallCluster(ctx context.Context, params *V2InstallClusterParams) (*V2InstallClusterAccepted, error)
	/*
	   V2InstallHost install specific host for day2 cluster.*/
	V2InstallHost(ctx context.Context, params *V2InstallHostParams) (*V2InstallHostAccepted, error)
	/*
	   V2ListClusters Retrieves the list of OpenShift clusters.*/
	V2ListClusters(ctx context.Context, params *V2ListClustersParams) (*V2ListClustersOK, error)
	/*
	   V2ListHosts Retrieves the list of OpenShift hosts that belong to infra-env.*/
	V2ListHosts(ctx context.Context, params *V2ListHostsParams) (*V2ListHostsOK, error)
	/*
	   V2PostStepReply Posts the result of the operations from the host agent.*/
	V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error)
	/*
	   V2RegisterCluster Creates a new OpenShift cluster definition.*/
	V2RegisterCluster(ctx context.Context, params *V2RegisterClusterParams) (*V2RegisterClusterCreated, error)
	/*
	   V2RegisterHost Registers a new OpenShift agent.*/
	V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error)
	/*
	   V2ResetCluster Resets a failed installation.*/
	V2ResetCluster(ctx context.Context, params *V2ResetClusterParams) (*V2ResetClusterAccepted, error)
	/*
	   V2ResetHost reset a failed host for day2 cluster.*/
	V2ResetHost(ctx context.Context, params *V2ResetHostParams) (*V2ResetHostOK, error)
	/*
	   V2ResetHostValidation resets failed host validation

	   Reset failed host validation. It may be performed on any host validation with persistent validation result.*/
	V2ResetHostValidation(ctx context.Context, params *V2ResetHostValidationParams) (*V2ResetHostValidationOK, error)
	/*
	   V2UpdateClusterInstallConfig Override values in the install config.*/
	V2UpdateClusterInstallConfig(ctx context.Context, params *V2UpdateClusterInstallConfigParams) (*V2UpdateClusterInstallConfigCreated, error)
	/*
	   V2UpdateClusterLogsProgress Update log collection state and progress.*/
	V2UpdateClusterLogsProgress(ctx context.Context, params *V2UpdateClusterLogsProgressParams) (*V2UpdateClusterLogsProgressNoContent, error)
	/*
	   V2UpdateHost Update an Openshift host*/
	V2UpdateHost(ctx context.Context, params *V2UpdateHostParams) (*V2UpdateHostCreated, error)
	/*
	   V2UpdateHostIgnition Patch the ignition file for this host*/
	V2UpdateHostIgnition(ctx context.Context, params *V2UpdateHostIgnitionParams) (*V2UpdateHostIgnitionCreated, error)
	/*
	   V2UpdateHostInstallProgress Update installation progress.*/
	V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error)
	/*
	   V2UpdateHostInstallerArgs Updates a host's installer arguments.*/
	V2UpdateHostInstallerArgs(ctx context.Context, params *V2UpdateHostInstallerArgsParams) (*V2UpdateHostInstallerArgsCreated, error)
	/*
	   V2UpdateHostLogsProgress Update log collection state and progress.*/
	V2UpdateHostLogsProgress(ctx context.Context, params *V2UpdateHostLogsProgressParams) (*V2UpdateHostLogsProgressNoContent, error)
	/*
	   V2UploadClusterIngressCert Transfer the ingress certificate for the cluster.*/
	V2UploadClusterIngressCert(ctx context.Context, params *V2UploadClusterIngressCertParams) (*V2UploadClusterIngressCertCreated, error)
}

// New creates a new installer API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for installer API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
BindHost Bind host to a cluster
*/
func (a *Client) BindHost(ctx context.Context, params *BindHostParams) (*BindHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "BindHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/bind",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &BindHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*BindHostOK), nil

}

/*
CancelInstallation Cancels an ongoing installation.
*/
func (a *Client) CancelInstallation(ctx context.Context, params *CancelInstallationParams) (*CancelInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CancelInstallation",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CancelInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CancelInstallationAccepted), nil

}

/*
CompleteInstallation Agent API to mark a finalizing installation as complete.
*/
func (a *Client) CompleteInstallation(ctx context.Context, params *CompleteInstallationParams) (*CompleteInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CompleteInstallation",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/complete_installation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CompleteInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CompleteInstallationAccepted), nil

}

/*
DeregisterCluster Deletes an OpenShift cluster definition.
*/
func (a *Client) DeregisterCluster(ctx context.Context, params *DeregisterClusterParams) (*DeregisterClusterNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterCluster",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterClusterNoContent), nil

}

/*
DeregisterHost Deregisters an OpenShift host.
*/
func (a *Client) DeregisterHost(ctx context.Context, params *DeregisterHostParams) (*DeregisterHostNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterHost",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterHostNoContent), nil

}

/*
DeregisterInfraEnv Deletes an InfraEnv.
*/
func (a *Client) DeregisterInfraEnv(ctx context.Context, params *DeregisterInfraEnvParams) (*DeregisterInfraEnvNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeregisterInfraEnv",
		Method:             "DELETE",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeregisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeregisterInfraEnvNoContent), nil

}

/*
DisableHost Disables a host for inclusion in the cluster.
*/
func (a *Client) DisableHost(ctx context.Context, params *DisableHostParams) (*DisableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DisableHost",
		Method:             "DELETE",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DisableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DisableHostOK), nil

}

/*
DownloadClusterFiles Downloads files relating to the installed/installing cluster.
*/
func (a *Client) DownloadClusterFiles(ctx context.Context, params *DownloadClusterFilesParams, writer io.Writer) (*DownloadClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterFiles",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterFilesOK), nil

}

/*
DownloadClusterISO Downloads the OpenShift per-cluster Discovery ISO.
*/
func (a *Client) DownloadClusterISO(ctx context.Context, params *DownloadClusterISOParams, writer io.Writer) (*DownloadClusterISOOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterISO",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterISOReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterISOOK), nil

}

/*
DownloadClusterISOHeaders Downloads the OpenShift per-cluster Discovery ISO Headers only.
*/
func (a *Client) DownloadClusterISOHeaders(ctx context.Context, params *DownloadClusterISOHeadersParams) (*DownloadClusterISOHeadersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterISOHeaders",
		Method:             "HEAD",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterISOHeadersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterISOHeadersOK), nil

}

/*
DownloadClusterKubeconfig Downloads the kubeconfig file for this cluster.
*/
func (a *Client) DownloadClusterKubeconfig(ctx context.Context, params *DownloadClusterKubeconfigParams, writer io.Writer) (*DownloadClusterKubeconfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterKubeconfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/kubeconfig",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterKubeconfigReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterKubeconfigOK), nil

}

/*
DownloadClusterLogs Download cluster logs.
*/
func (a *Client) DownloadClusterLogs(ctx context.Context, params *DownloadClusterLogsParams, writer io.Writer) (*DownloadClusterLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadClusterLogs",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadClusterLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadClusterLogsOK), nil

}

/*
DownloadHostIgnition Downloads the customized ignition file for this host, produces octet string
*/
func (a *Client) DownloadHostIgnition(ctx context.Context, params *DownloadHostIgnitionParams, writer io.Writer) (*DownloadHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostIgnitionReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostIgnitionOK), nil

}

/*
DownloadHostLogs Download host logs.
*/
func (a *Client) DownloadHostLogs(ctx context.Context, params *DownloadHostLogsParams, writer io.Writer) (*DownloadHostLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadHostLogs",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadHostLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadHostLogsOK), nil

}

/*
DownloadInfraEnvDiscoveryImage Downloads the discovery image.
*/
func (a *Client) DownloadInfraEnvDiscoveryImage(ctx context.Context, params *DownloadInfraEnvDiscoveryImageParams, writer io.Writer) (*DownloadInfraEnvDiscoveryImageOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadInfraEnvDiscoveryImage",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/image",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadInfraEnvDiscoveryImageReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadInfraEnvDiscoveryImageOK), nil

}

/*
DownloadInfraEnvDiscoveryImageHeaders Downloads the discovery image Headers only.
*/
func (a *Client) DownloadInfraEnvDiscoveryImageHeaders(ctx context.Context, params *DownloadInfraEnvDiscoveryImageHeadersParams) (*DownloadInfraEnvDiscoveryImageHeadersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadInfraEnvDiscoveryImageHeaders",
		Method:             "HEAD",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadInfraEnvDiscoveryImageHeadersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadInfraEnvDiscoveryImageHeadersOK), nil

}

/*
DownloadMinimalInitrd Get the initial ramdisk for minimal ISO based installations.

*/
func (a *Client) DownloadMinimalInitrd(ctx context.Context, params *DownloadMinimalInitrdParams, writer io.Writer) (*DownloadMinimalInitrdOK, *DownloadMinimalInitrdNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DownloadMinimalInitrd",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/minimal-initrd",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadMinimalInitrdReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DownloadMinimalInitrdOK:
		return value, nil, nil
	case *DownloadMinimalInitrdNoContent:
		return nil, value, nil
	}
	return nil, nil, nil

}

/*
EnableHost Enables a host for inclusion in the cluster.
*/
func (a *Client) EnableHost(ctx context.Context, params *EnableHostParams) (*EnableHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "EnableHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &EnableHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*EnableHostOK), nil

}

/*
GenerateClusterISO Creates a new OpenShift per-cluster Discovery ISO.
*/
func (a *Client) GenerateClusterISO(ctx context.Context, params *GenerateClusterISOParams) (*GenerateClusterISOCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GenerateClusterISO",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/image",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GenerateClusterISOReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GenerateClusterISOCreated), nil

}

/*
GetCluster Retrieves the details of the OpenShift cluster.
*/
func (a *Client) GetCluster(ctx context.Context, params *GetClusterParams) (*GetClusterOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCluster",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterOK), nil

}

/*
GetClusterDefaultConfig Get the default values for various cluster properties.
*/
func (a *Client) GetClusterDefaultConfig(ctx context.Context, params *GetClusterDefaultConfigParams) (*GetClusterDefaultConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterDefaultConfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/default-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterDefaultConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterDefaultConfigOK), nil

}

/*
GetClusterHostRequirements Get host requirements of a cluster.
*/
func (a *Client) GetClusterHostRequirements(ctx context.Context, params *GetClusterHostRequirementsParams) (*GetClusterHostRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterHostRequirements",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/host-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterHostRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterHostRequirementsOK), nil

}

/*
GetClusterInstallConfig Get the cluster's install config YAML.
*/
func (a *Client) GetClusterInstallConfig(ctx context.Context, params *GetClusterInstallConfigParams) (*GetClusterInstallConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterInstallConfig",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterInstallConfigOK), nil

}

/*
GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration.
*/
func (a *Client) GetClusterSupportedPlatforms(ctx context.Context, params *GetClusterSupportedPlatformsParams) (*GetClusterSupportedPlatformsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetClusterSupportedPlatforms",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/supported-platforms",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetClusterSupportedPlatformsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetClusterSupportedPlatformsOK), nil

}

/*
GetCredentials Get the cluster admin credentials.
*/
func (a *Client) GetCredentials(ctx context.Context, params *GetCredentialsParams) (*GetCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetCredentials",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/credentials",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetCredentialsOK), nil

}

/*
GetDiscoveryIgnition Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.
Used to test the validity of the discovery ignition when it is being overridden.
For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign

*/
func (a *Client) GetDiscoveryIgnition(ctx context.Context, params *GetDiscoveryIgnitionParams) (*GetDiscoveryIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetDiscoveryIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetDiscoveryIgnitionOK), nil

}

/*
GetFreeAddresses Retrieves the free address list for a network.
*/
func (a *Client) GetFreeAddresses(ctx context.Context, params *GetFreeAddressesParams) (*GetFreeAddressesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetFreeAddresses",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/free_addresses",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFreeAddressesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetFreeAddressesOK), nil

}

/*
GetHost Retrieves the details of the OpenShift host.
*/
func (a *Client) GetHost(ctx context.Context, params *GetHostParams) (*GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHost",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostOK), nil

}

/*
GetHostIgnition Get the customized ignition file for this host as a string
*/
func (a *Client) GetHostIgnition(ctx context.Context, params *GetHostIgnitionParams) (*GetHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetHostIgnition",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetHostIgnitionOK), nil

}

/*
GetInfraEnv Retrieves the details of the InfraEnv.
*/
func (a *Client) GetInfraEnv(ctx context.Context, params *GetInfraEnvParams) (*GetInfraEnvOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetInfraEnv",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetInfraEnvOK), nil

}

/*
GetPreflightRequirements Get preflight requirements for a cluster.
*/
func (a *Client) GetPreflightRequirements(ctx context.Context, params *GetPreflightRequirementsParams) (*GetPreflightRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetPreflightRequirements",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/preflight-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPreflightRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPreflightRequirementsOK), nil

}

/*
GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.
*/
func (a *Client) GetPresignedForClusterFiles(ctx context.Context, params *GetPresignedForClusterFilesParams) (*GetPresignedForClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetPresignedForClusterFiles",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPresignedForClusterFilesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPresignedForClusterFilesOK), nil

}

/*
InstallCluster Installs the OpenShift cluster.
*/
func (a *Client) InstallCluster(ctx context.Context, params *InstallClusterParams) (*InstallClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallClusterAccepted), nil

}

/*
InstallHost install specific host for day2 cluster.
*/
func (a *Client) InstallHost(ctx context.Context, params *InstallHostParams) (*InstallHostAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostAccepted), nil

}

/*
InstallHosts Installs the OpenShift cluster.
*/
func (a *Client) InstallHosts(ctx context.Context, params *InstallHostsParams) (*InstallHostsAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "InstallHosts",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/install_hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &InstallHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*InstallHostsAccepted), nil

}

/*
ListClusters Retrieves the list of OpenShift clusters.
*/
func (a *Client) ListClusters(ctx context.Context, params *ListClustersParams) (*ListClustersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListClusters",
		Method:             "GET",
		PathPattern:        "/v1/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListClustersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListClustersOK), nil

}

/*
ListHosts Retrieves the list of OpenShift hosts.
*/
func (a *Client) ListHosts(ctx context.Context, params *ListHostsParams) (*ListHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListHosts",
		Method:             "GET",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListHostsOK), nil

}

/*
ListInfraEnvs Retrieves the list of InfraEnvs.
*/
func (a *Client) ListInfraEnvs(ctx context.Context, params *ListInfraEnvsParams) (*ListInfraEnvsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListInfraEnvs",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListInfraEnvsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListInfraEnvsOK), nil

}

/*
RegisterAddHostsCluster Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.
*/
func (a *Client) RegisterAddHostsCluster(ctx context.Context, params *RegisterAddHostsClusterParams) (*RegisterAddHostsClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterAddHostsCluster",
		Method:             "POST",
		PathPattern:        "/v1/add_hosts_clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterAddHostsClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterAddHostsClusterCreated), nil

}

/*
RegisterCluster Creates a new OpenShift cluster definition.
*/
func (a *Client) RegisterCluster(ctx context.Context, params *RegisterClusterParams) (*RegisterClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterClusterCreated), nil

}

/*
RegisterInfraEnv Creates a new OpenShift Discovery ISO.
*/
func (a *Client) RegisterInfraEnv(ctx context.Context, params *RegisterInfraEnvParams) (*RegisterInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "RegisterInfraEnv",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RegisterInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*RegisterInfraEnvCreated), nil

}

/*
ResetCluster Resets a failed installation.
*/
func (a *Client) ResetCluster(ctx context.Context, params *ResetClusterParams) (*ResetClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetCluster",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetClusterAccepted), nil

}

/*
ResetHost reset a failed host for day2 cluster.
*/
func (a *Client) ResetHost(ctx context.Context, params *ResetHostParams) (*ResetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetHost",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetHostOK), nil

}

/*
ResetHostValidation resets failed host validation

Reset failed host validation.  It may be performed on any host validation with persistent validation result.
*/
func (a *Client) ResetHostValidation(ctx context.Context, params *ResetHostValidationParams) (*ResetHostValidationOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ResetHostValidation",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetHostValidationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ResetHostValidationOK), nil

}

/*
UnbindHost Unbind host to a cluster
*/
func (a *Client) UnbindHost(ctx context.Context, params *UnbindHostParams) (*UnbindHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UnbindHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UnbindHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UnbindHostOK), nil

}

/*
UpdateCluster Updates an OpenShift cluster definition.
*/
func (a *Client) UpdateCluster(ctx context.Context, params *UpdateClusterParams) (*UpdateClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterCreated), nil

}

/*
UpdateClusterInstallConfig Override values in the install config.
*/
func (a *Client) UpdateClusterInstallConfig(ctx context.Context, params *UpdateClusterInstallConfigParams) (*UpdateClusterInstallConfigCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterInstallConfig",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterInstallConfigCreated), nil

}

/*
UpdateClusterLogsProgress Update log collection state and progress.
*/
func (a *Client) UpdateClusterLogsProgress(ctx context.Context, params *UpdateClusterLogsProgressParams) (*UpdateClusterLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateClusterLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/logs_progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateClusterLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateClusterLogsProgressNoContent), nil

}

/*
UpdateDiscoveryIgnition Override values in the discovery ignition config.
*/
func (a *Client) UpdateDiscoveryIgnition(ctx context.Context, params *UpdateDiscoveryIgnitionParams) (*UpdateDiscoveryIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateDiscoveryIgnition",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/discovery-ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDiscoveryIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateDiscoveryIgnitionCreated), nil

}

/*
UpdateHostIgnition Patch the ignition file for this host
*/
func (a *Client) UpdateHostIgnition(ctx context.Context, params *UpdateHostIgnitionParams) (*UpdateHostIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostIgnition",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostIgnitionCreated), nil

}

/*
UpdateHostInstallProgress Update installation progress.
*/
func (a *Client) UpdateHostInstallProgress(ctx context.Context, params *UpdateHostInstallProgressParams) (*UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallProgressOK), nil

}

/*
UpdateHostInstallerArgs Updates a host's installer arguments.
*/
func (a *Client) UpdateHostInstallerArgs(ctx context.Context, params *UpdateHostInstallerArgsParams) (*UpdateHostInstallerArgsCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostInstallerArgs",
		Method:             "PATCH",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostInstallerArgsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostInstallerArgsCreated), nil

}

/*
UpdateHostLogsProgress Update log collection state and progress.
*/
func (a *Client) UpdateHostLogsProgress(ctx context.Context, params *UpdateHostLogsProgressParams) (*UpdateHostLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateHostLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateHostLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateHostLogsProgressNoContent), nil

}

/*
UpdateInfraEnv Updates an InfraEnv.
*/
func (a *Client) UpdateInfraEnv(ctx context.Context, params *UpdateInfraEnvParams) (*UpdateInfraEnvCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateInfraEnv",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateInfraEnvReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateInfraEnvCreated), nil

}

/*
UploadClusterIngressCert Transfer the ingress certificate for the cluster.
*/
func (a *Client) UploadClusterIngressCert(ctx context.Context, params *UploadClusterIngressCertParams) (*UploadClusterIngressCertCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadClusterIngressCert",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/uploads/ingress-cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadClusterIngressCertReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadClusterIngressCertCreated), nil

}

/*
UploadHostLogs Agent API to upload logs.
*/
func (a *Client) UploadHostLogs(ctx context.Context, params *UploadHostLogsParams) (*UploadHostLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadHostLogs",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/hosts/{host_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadHostLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadHostLogsNoContent), nil

}

/*
UploadLogs Agent API to upload logs.
*/
func (a *Client) UploadLogs(ctx context.Context, params *UploadLogsParams) (*UploadLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UploadLogs",
		Method:             "POST",
		PathPattern:        "/v1/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadLogsNoContent), nil

}

/*
V2CancelInstallation Cancels an ongoing installation.
*/
func (a *Client) V2CancelInstallation(ctx context.Context, params *V2CancelInstallationParams) (*V2CancelInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2CancelInstallation",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2CancelInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2CancelInstallationAccepted), nil

}

/*
V2DownloadClusterCredentials Downloads credentials relating to the installed/installing cluster.
*/
func (a *Client) V2DownloadClusterCredentials(ctx context.Context, params *V2DownloadClusterCredentialsParams, writer io.Writer) (*V2DownloadClusterCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterCredentials",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/credentials",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterCredentialsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterCredentialsOK), nil

}

/*
V2DownloadClusterFiles Downloads files relating to the installed/installing cluster.
*/
func (a *Client) V2DownloadClusterFiles(ctx context.Context, params *V2DownloadClusterFilesParams, writer io.Writer) (*V2DownloadClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterFiles",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterFilesOK), nil

}

/*
V2DownloadClusterLogs Download cluster logs.
*/
func (a *Client) V2DownloadClusterLogs(ctx context.Context, params *V2DownloadClusterLogsParams, writer io.Writer) (*V2DownloadClusterLogsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2DownloadClusterLogs",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadClusterLogsReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadClusterLogsOK), nil

}

/*
V2GetClusterDefaultConfig Get the default values for various cluster properties.
*/
func (a *Client) V2GetClusterDefaultConfig(ctx context.Context, params *V2GetClusterDefaultConfigParams) (*V2GetClusterDefaultConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetClusterDefaultConfig",
		Method:             "GET",
		PathPattern:        "/v2/clusters/default-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterDefaultConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterDefaultConfigOK), nil

}

/*
V2GetCredentials Get the cluster admin credentials.
*/
func (a *Client) V2GetCredentials(ctx context.Context, params *V2GetCredentialsParams) (*V2GetCredentialsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetCredentials",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/credentials",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetCredentialsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetCredentialsOK), nil

}

/*
V2GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files.
*/
func (a *Client) V2GetPresignedForClusterFiles(ctx context.Context, params *V2GetPresignedForClusterFilesParams) (*V2GetPresignedForClusterFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2GetPresignedForClusterFiles",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/downloads/files-presigned",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetPresignedForClusterFilesReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetPresignedForClusterFilesOK), nil

}

/*
V2UpdateCluster Updates an OpenShift cluster definition.
*/
func (a *Client) V2UpdateCluster(ctx context.Context, params *V2UpdateClusterParams) (*V2UpdateClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterCreated), nil

}

/*
V2UploadLogs Agent API to upload logs.
*/
func (a *Client) V2UploadLogs(ctx context.Context, params *V2UploadLogsParams) (*V2UploadLogsNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "V2UploadLogs",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UploadLogsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UploadLogsNoContent), nil

}

/*
V2CompleteInstallation Agent API to mark a finalizing installation as complete.
*/
func (a *Client) V2CompleteInstallation(ctx context.Context, params *V2CompleteInstallationParams) (*V2CompleteInstallationAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2CompleteInstallation",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/complete-installation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2CompleteInstallationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2CompleteInstallationAccepted), nil

}

/*
V2DeregisterCluster Deletes an OpenShift cluster definition.
*/
func (a *Client) V2DeregisterCluster(ctx context.Context, params *V2DeregisterClusterParams) (*V2DeregisterClusterNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DeregisterCluster",
		Method:             "DELETE",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DeregisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DeregisterClusterNoContent), nil

}

/*
V2DeregisterHost Deregisters an OpenShift host.
*/
func (a *Client) V2DeregisterHost(ctx context.Context, params *V2DeregisterHostParams) (*V2DeregisterHostNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DeregisterHost",
		Method:             "DELETE",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DeregisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DeregisterHostNoContent), nil

}

/*
V2DownloadHostIgnition Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned
*/
func (a *Client) V2DownloadHostIgnition(ctx context.Context, params *V2DownloadHostIgnitionParams, writer io.Writer) (*V2DownloadHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DownloadHostIgnition",
		Method:             "GET",
		PathPattern:        "/v2/infra-env/{infra_env_id}/hosts/{host_id}/downloads/ignition",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadHostIgnitionReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadHostIgnitionOK), nil

}

/*
V2DownloadInfraEnvFiles Downloads the customized ignition file for this host
*/
func (a *Client) V2DownloadInfraEnvFiles(ctx context.Context, params *V2DownloadInfraEnvFilesParams, writer io.Writer) (*V2DownloadInfraEnvFilesOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2DownloadInfraEnvFiles",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/downloads/files",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2DownloadInfraEnvFilesReader{formats: a.formats, writer: writer},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2DownloadInfraEnvFilesOK), nil

}

/*
V2GetCluster Retrieves the details of the OpenShift cluster.
*/
func (a *Client) V2GetCluster(ctx context.Context, params *V2GetClusterParams) (*V2GetClusterOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetCluster",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterOK), nil

}

/*
V2GetClusterInstallConfig Get the cluster's install config YAML.
*/
func (a *Client) V2GetClusterInstallConfig(ctx context.Context, params *V2GetClusterInstallConfigParams) (*V2GetClusterInstallConfigOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetClusterInstallConfig",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetClusterInstallConfigOK), nil

}

/*
V2GetHost Retrieves the details of the OpenShift host.
*/
func (a *Client) V2GetHost(ctx context.Context, params *V2GetHostParams) (*V2GetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetHost",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetHostOK), nil

}

/*
V2GetHostIgnition Fetch the ignition file for this host as a string. In case of unbound host produces an error
*/
func (a *Client) V2GetHostIgnition(ctx context.Context, params *V2GetHostIgnitionParams) (*V2GetHostIgnitionOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetHostIgnition",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetHostIgnitionOK), nil

}

/*
V2GetNextSteps Retrieves the next operations that the host agent needs to perform.
*/
func (a *Client) V2GetNextSteps(ctx context.Context, params *V2GetNextStepsParams) (*V2GetNextStepsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetNextSteps",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetNextStepsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetNextStepsOK), nil

}

/*
V2GetPreflightRequirements Get preflight requirements for a cluster.
*/
func (a *Client) V2GetPreflightRequirements(ctx context.Context, params *V2GetPreflightRequirementsParams) (*V2GetPreflightRequirementsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2GetPreflightRequirements",
		Method:             "GET",
		PathPattern:        "/v2/clusters/{cluster_id}/preflight-requirements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2GetPreflightRequirementsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2GetPreflightRequirementsOK), nil

}

/*
V2InstallCluster Installs the OpenShift cluster.
*/
func (a *Client) V2InstallCluster(ctx context.Context, params *V2InstallClusterParams) (*V2InstallClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2InstallCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2InstallClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2InstallClusterAccepted), nil

}

/*
V2InstallHost install specific host for day2 cluster.
*/
func (a *Client) V2InstallHost(ctx context.Context, params *V2InstallHostParams) (*V2InstallHostAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2InstallHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/install",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2InstallHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2InstallHostAccepted), nil

}

/*
V2ListClusters Retrieves the list of OpenShift clusters.
*/
func (a *Client) V2ListClusters(ctx context.Context, params *V2ListClustersParams) (*V2ListClustersOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListClusters",
		Method:             "GET",
		PathPattern:        "/v2/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListClustersReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListClustersOK), nil

}

/*
V2ListHosts Retrieves the list of OpenShift hosts that belong to infra-env.
*/
func (a *Client) V2ListHosts(ctx context.Context, params *V2ListHostsParams) (*V2ListHostsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListHosts",
		Method:             "GET",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListHostsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListHostsOK), nil

}

/*
V2PostStepReply Posts the result of the operations from the host agent.
*/
func (a *Client) V2PostStepReply(ctx context.Context, params *V2PostStepReplyParams) (*V2PostStepReplyNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2PostStepReply",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2PostStepReplyReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2PostStepReplyNoContent), nil

}

/*
V2RegisterCluster Creates a new OpenShift cluster definition.
*/
func (a *Client) V2RegisterCluster(ctx context.Context, params *V2RegisterClusterParams) (*V2RegisterClusterCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2RegisterCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2RegisterClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2RegisterClusterCreated), nil

}

/*
V2RegisterHost Registers a new OpenShift agent.
*/
func (a *Client) V2RegisterHost(ctx context.Context, params *V2RegisterHostParams) (*V2RegisterHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2RegisterHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2RegisterHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2RegisterHostCreated), nil

}

/*
V2ResetCluster Resets a failed installation.
*/
func (a *Client) V2ResetCluster(ctx context.Context, params *V2ResetClusterParams) (*V2ResetClusterAccepted, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetCluster",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetClusterReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetClusterAccepted), nil

}

/*
V2ResetHost reset a failed host for day2 cluster.
*/
func (a *Client) V2ResetHost(ctx context.Context, params *V2ResetHostParams) (*V2ResetHostOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetHost",
		Method:             "POST",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetHostOK), nil

}

/*
V2ResetHostValidation resets failed host validation

Reset failed host validation. It may be performed on any host validation with persistent validation result.
*/
func (a *Client) V2ResetHostValidation(ctx context.Context, params *V2ResetHostValidationParams) (*V2ResetHostValidationOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ResetHostValidation",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset-validation/{validation_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ResetHostValidationReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ResetHostValidationOK), nil

}

/*
V2UpdateClusterInstallConfig Override values in the install config.
*/
func (a *Client) V2UpdateClusterInstallConfig(ctx context.Context, params *V2UpdateClusterInstallConfigParams) (*V2UpdateClusterInstallConfigCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateClusterInstallConfig",
		Method:             "PATCH",
		PathPattern:        "/v2/clusters/{cluster_id}/install-config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterInstallConfigReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterInstallConfigCreated), nil

}

/*
V2UpdateClusterLogsProgress Update log collection state and progress.
*/
func (a *Client) V2UpdateClusterLogsProgress(ctx context.Context, params *V2UpdateClusterLogsProgressParams) (*V2UpdateClusterLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateClusterLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v2/clusters/{cluster_id}/logs-progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateClusterLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateClusterLogsProgressNoContent), nil

}

/*
V2UpdateHost Update an Openshift host
*/
func (a *Client) V2UpdateHost(ctx context.Context, params *V2UpdateHostParams) (*V2UpdateHostCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHost",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostCreated), nil

}

/*
V2UpdateHostIgnition Patch the ignition file for this host
*/
func (a *Client) V2UpdateHostIgnition(ctx context.Context, params *V2UpdateHostIgnitionParams) (*V2UpdateHostIgnitionCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostIgnition",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostIgnitionReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostIgnitionCreated), nil

}

/*
V2UpdateHostInstallProgress Update installation progress.
*/
func (a *Client) V2UpdateHostInstallProgress(ctx context.Context, params *V2UpdateHostInstallProgressParams) (*V2UpdateHostInstallProgressOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostInstallProgress",
		Method:             "PUT",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostInstallProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostInstallProgressOK), nil

}

/*
V2UpdateHostInstallerArgs Updates a host's installer arguments.
*/
func (a *Client) V2UpdateHostInstallerArgs(ctx context.Context, params *V2UpdateHostInstallerArgsParams) (*V2UpdateHostInstallerArgsCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostInstallerArgs",
		Method:             "PATCH",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/installer-args",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostInstallerArgsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostInstallerArgsCreated), nil

}

/*
V2UpdateHostLogsProgress Update log collection state and progress.
*/
func (a *Client) V2UpdateHostLogsProgress(ctx context.Context, params *V2UpdateHostLogsProgressParams) (*V2UpdateHostLogsProgressNoContent, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UpdateHostLogsProgress",
		Method:             "PUT",
		PathPattern:        "/v2/infra-envs/{infra_env_id}/hosts/{host_id}/logs-progress",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UpdateHostLogsProgressReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UpdateHostLogsProgressNoContent), nil

}

/*
V2UploadClusterIngressCert Transfer the ingress certificate for the cluster.
*/
func (a *Client) V2UploadClusterIngressCert(ctx context.Context, params *V2UploadClusterIngressCertParams) (*V2UploadClusterIngressCertCreated, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2UploadClusterIngressCert",
		Method:             "POST",
		PathPattern:        "/v2/clusters/{cluster_id}/uploads/ingress-cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2UploadClusterIngressCertReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2UploadClusterIngressCertCreated), nil

}
