// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// ListHostsReader is a Reader for the ListHosts structure.
type ListHostsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListHostsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListHostsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewListHostsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListHostsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewListHostsMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListHostsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewListHostsServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewListHostsOK creates a ListHostsOK with default headers values
func NewListHostsOK() *ListHostsOK {
	return &ListHostsOK{}
}

/*ListHostsOK handles this case with default header values.

Success.
*/
type ListHostsOK struct {
	Payload models.HostList
}

func (o *ListHostsOK) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsOK  %+v", 200, o.Payload)
}

func (o *ListHostsOK) GetPayload() models.HostList {
	return o.Payload
}

func (o *ListHostsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListHostsUnauthorized creates a ListHostsUnauthorized with default headers values
func NewListHostsUnauthorized() *ListHostsUnauthorized {
	return &ListHostsUnauthorized{}
}

/*ListHostsUnauthorized handles this case with default header values.

Unauthorized.
*/
type ListHostsUnauthorized struct {
	Payload *models.InfraError
}

func (o *ListHostsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsUnauthorized  %+v", 401, o.Payload)
}

func (o *ListHostsUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListHostsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListHostsForbidden creates a ListHostsForbidden with default headers values
func NewListHostsForbidden() *ListHostsForbidden {
	return &ListHostsForbidden{}
}

/*ListHostsForbidden handles this case with default header values.

Forbidden.
*/
type ListHostsForbidden struct {
	Payload *models.InfraError
}

func (o *ListHostsForbidden) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsForbidden  %+v", 403, o.Payload)
}

func (o *ListHostsForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListHostsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListHostsMethodNotAllowed creates a ListHostsMethodNotAllowed with default headers values
func NewListHostsMethodNotAllowed() *ListHostsMethodNotAllowed {
	return &ListHostsMethodNotAllowed{}
}

/*ListHostsMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type ListHostsMethodNotAllowed struct {
	Payload *models.Error
}

func (o *ListHostsMethodNotAllowed) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsMethodNotAllowed  %+v", 405, o.Payload)
}

func (o *ListHostsMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListHostsMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListHostsInternalServerError creates a ListHostsInternalServerError with default headers values
func NewListHostsInternalServerError() *ListHostsInternalServerError {
	return &ListHostsInternalServerError{}
}

/*ListHostsInternalServerError handles this case with default header values.

Error.
*/
type ListHostsInternalServerError struct {
	Payload *models.Error
}

func (o *ListHostsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *ListHostsInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListHostsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListHostsServiceUnavailable creates a ListHostsServiceUnavailable with default headers values
func NewListHostsServiceUnavailable() *ListHostsServiceUnavailable {
	return &ListHostsServiceUnavailable{}
}

/*ListHostsServiceUnavailable handles this case with default header values.

Unavailable.
*/
type ListHostsServiceUnavailable struct {
	Payload *models.Error
}

func (o *ListHostsServiceUnavailable) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/hosts][%d] listHostsServiceUnavailable  %+v", 503, o.Payload)
}

func (o *ListHostsServiceUnavailable) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListHostsServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
