// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// UnbindHostReader is a Reader for the UnbindHost structure.
type UnbindHostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnbindHostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnbindHostOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUnbindHostBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUnbindHostUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUnbindHostForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUnbindHostNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewUnbindHostMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUnbindHostInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewUnbindHostNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewUnbindHostServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewUnbindHostOK creates a UnbindHostOK with default headers values
func NewUnbindHostOK() *UnbindHostOK {
	return &UnbindHostOK{}
}

/*UnbindHostOK handles this case with default header values.

Success.
*/
type UnbindHostOK struct {
	Payload *models.Host
}

func (o *UnbindHostOK) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostOK  %+v", 200, o.Payload)
}

func (o *UnbindHostOK) GetPayload() *models.Host {
	return o.Payload
}

func (o *UnbindHostOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Host)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostBadRequest creates a UnbindHostBadRequest with default headers values
func NewUnbindHostBadRequest() *UnbindHostBadRequest {
	return &UnbindHostBadRequest{}
}

/*UnbindHostBadRequest handles this case with default header values.

Error.
*/
type UnbindHostBadRequest struct {
	Payload *models.Error
}

func (o *UnbindHostBadRequest) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostBadRequest  %+v", 400, o.Payload)
}

func (o *UnbindHostBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostUnauthorized creates a UnbindHostUnauthorized with default headers values
func NewUnbindHostUnauthorized() *UnbindHostUnauthorized {
	return &UnbindHostUnauthorized{}
}

/*UnbindHostUnauthorized handles this case with default header values.

Unauthorized.
*/
type UnbindHostUnauthorized struct {
	Payload *models.InfraError
}

func (o *UnbindHostUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostUnauthorized  %+v", 401, o.Payload)
}

func (o *UnbindHostUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UnbindHostUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostForbidden creates a UnbindHostForbidden with default headers values
func NewUnbindHostForbidden() *UnbindHostForbidden {
	return &UnbindHostForbidden{}
}

/*UnbindHostForbidden handles this case with default header values.

Forbidden.
*/
type UnbindHostForbidden struct {
	Payload *models.InfraError
}

func (o *UnbindHostForbidden) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostForbidden  %+v", 403, o.Payload)
}

func (o *UnbindHostForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *UnbindHostForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostNotFound creates a UnbindHostNotFound with default headers values
func NewUnbindHostNotFound() *UnbindHostNotFound {
	return &UnbindHostNotFound{}
}

/*UnbindHostNotFound handles this case with default header values.

Error.
*/
type UnbindHostNotFound struct {
	Payload *models.Error
}

func (o *UnbindHostNotFound) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostNotFound  %+v", 404, o.Payload)
}

func (o *UnbindHostNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostMethodNotAllowed creates a UnbindHostMethodNotAllowed with default headers values
func NewUnbindHostMethodNotAllowed() *UnbindHostMethodNotAllowed {
	return &UnbindHostMethodNotAllowed{}
}

/*UnbindHostMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type UnbindHostMethodNotAllowed struct {
	Payload *models.Error
}

func (o *UnbindHostMethodNotAllowed) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostMethodNotAllowed  %+v", 405, o.Payload)
}

func (o *UnbindHostMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostInternalServerError creates a UnbindHostInternalServerError with default headers values
func NewUnbindHostInternalServerError() *UnbindHostInternalServerError {
	return &UnbindHostInternalServerError{}
}

/*UnbindHostInternalServerError handles this case with default header values.

Error.
*/
type UnbindHostInternalServerError struct {
	Payload *models.Error
}

func (o *UnbindHostInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostInternalServerError  %+v", 500, o.Payload)
}

func (o *UnbindHostInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostNotImplemented creates a UnbindHostNotImplemented with default headers values
func NewUnbindHostNotImplemented() *UnbindHostNotImplemented {
	return &UnbindHostNotImplemented{}
}

/*UnbindHostNotImplemented handles this case with default header values.

Not implemented.
*/
type UnbindHostNotImplemented struct {
	Payload *models.Error
}

func (o *UnbindHostNotImplemented) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostNotImplemented  %+v", 501, o.Payload)
}

func (o *UnbindHostNotImplemented) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnbindHostServiceUnavailable creates a UnbindHostServiceUnavailable with default headers values
func NewUnbindHostServiceUnavailable() *UnbindHostServiceUnavailable {
	return &UnbindHostServiceUnavailable{}
}

/*UnbindHostServiceUnavailable handles this case with default header values.

Unavailable.
*/
type UnbindHostServiceUnavailable struct {
	Payload *models.Error
}

func (o *UnbindHostServiceUnavailable) Error() string {
	return fmt.Sprintf("[POST /v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind][%d] unbindHostServiceUnavailable  %+v", 503, o.Payload)
}

func (o *UnbindHostServiceUnavailable) GetPayload() *models.Error {
	return o.Payload
}

func (o *UnbindHostServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
