// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2GetHostParams creates a new V2GetHostParams object
// with the default values initialized.
func NewV2GetHostParams() *V2GetHostParams {
	var ()
	return &V2GetHostParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2GetHostParamsWithTimeout creates a new V2GetHostParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2GetHostParamsWithTimeout(timeout time.Duration) *V2GetHostParams {
	var ()
	return &V2GetHostParams{

		timeout: timeout,
	}
}

// NewV2GetHostParamsWithContext creates a new V2GetHostParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2GetHostParamsWithContext(ctx context.Context) *V2GetHostParams {
	var ()
	return &V2GetHostParams{

		Context: ctx,
	}
}

// NewV2GetHostParamsWithHTTPClient creates a new V2GetHostParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2GetHostParamsWithHTTPClient(client *http.Client) *V2GetHostParams {
	var ()
	return &V2GetHostParams{
		HTTPClient: client,
	}
}

/*V2GetHostParams contains all the parameters to send to the API endpoint
for the v2 get host operation typically these are written to a http.Request
*/
type V2GetHostParams struct {

	/*HostID
	  The host that should be retrieved.

	*/
	HostID strfmt.UUID
	/*InfraEnvID
	  The infra env of the host that should be retrieved.

	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 get host params
func (o *V2GetHostParams) WithTimeout(timeout time.Duration) *V2GetHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 get host params
func (o *V2GetHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 get host params
func (o *V2GetHostParams) WithContext(ctx context.Context) *V2GetHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 get host params
func (o *V2GetHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 get host params
func (o *V2GetHostParams) WithHTTPClient(client *http.Client) *V2GetHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 get host params
func (o *V2GetHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHostID adds the hostID to the v2 get host params
func (o *V2GetHostParams) WithHostID(hostID strfmt.UUID) *V2GetHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 get host params
func (o *V2GetHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 get host params
func (o *V2GetHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2GetHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 get host params
func (o *V2GetHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *V2GetHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
