// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2InstallHostParams creates a new V2InstallHostParams object
// with the default values initialized.
func NewV2InstallHostParams() *V2InstallHostParams {
	var ()
	return &V2InstallHostParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2InstallHostParamsWithTimeout creates a new V2InstallHostParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2InstallHostParamsWithTimeout(timeout time.Duration) *V2InstallHostParams {
	var ()
	return &V2InstallHostParams{

		timeout: timeout,
	}
}

// NewV2InstallHostParamsWithContext creates a new V2InstallHostParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2InstallHostParamsWithContext(ctx context.Context) *V2InstallHostParams {
	var ()
	return &V2InstallHostParams{

		Context: ctx,
	}
}

// NewV2InstallHostParamsWithHTTPClient creates a new V2InstallHostParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2InstallHostParamsWithHTTPClient(client *http.Client) *V2InstallHostParams {
	var ()
	return &V2InstallHostParams{
		HTTPClient: client,
	}
}

/*V2InstallHostParams contains all the parameters to send to the API endpoint
for the v2 install host operation typically these are written to a http.Request
*/
type V2InstallHostParams struct {

	/*HostID
	  The host that is being installed.

	*/
	HostID strfmt.UUID
	/*InfraEnvID
	  The InfraEnv of the host that is being installed.

	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 install host params
func (o *V2InstallHostParams) WithTimeout(timeout time.Duration) *V2InstallHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 install host params
func (o *V2InstallHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 install host params
func (o *V2InstallHostParams) WithContext(ctx context.Context) *V2InstallHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 install host params
func (o *V2InstallHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 install host params
func (o *V2InstallHostParams) WithHTTPClient(client *http.Client) *V2InstallHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 install host params
func (o *V2InstallHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHostID adds the hostID to the v2 install host params
func (o *V2InstallHostParams) WithHostID(hostID strfmt.UUID) *V2InstallHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 install host params
func (o *V2InstallHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 install host params
func (o *V2InstallHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2InstallHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 install host params
func (o *V2InstallHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *V2InstallHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
