// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewV2ListClustersParams creates a new V2ListClustersParams object
// with the default values initialized.
func NewV2ListClustersParams() *V2ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
		withHostsDefault               = bool(false)
	)
	return &V2ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		WithHosts:               withHostsDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewV2ListClustersParamsWithTimeout creates a new V2ListClustersParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2ListClustersParamsWithTimeout(timeout time.Duration) *V2ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
		withHostsDefault               = bool(false)
	)
	return &V2ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		WithHosts:               withHostsDefault,

		timeout: timeout,
	}
}

// NewV2ListClustersParamsWithContext creates a new V2ListClustersParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2ListClustersParamsWithContext(ctx context.Context) *V2ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
		withHostsDefault               = bool(false)
	)
	return &V2ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		WithHosts:               withHostsDefault,

		Context: ctx,
	}
}

// NewV2ListClustersParamsWithHTTPClient creates a new V2ListClustersParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2ListClustersParamsWithHTTPClient(client *http.Client) *V2ListClustersParams {
	var (
		getUnregisteredClustersDefault = bool(false)
		withHostsDefault               = bool(false)
	)
	return &V2ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		WithHosts:               withHostsDefault,
		HTTPClient:              client,
	}
}

/*V2ListClustersParams contains all the parameters to send to the API endpoint
for the v2 list clusters operation typically these are written to a http.Request
*/
type V2ListClustersParams struct {

	/*AmsSubscriptionIds
	  If non-empty, returned Clusters are filtered to those with matching subscription IDs.

	*/
	AmsSubscriptionIds []string
	/*GetUnregisteredClusters
	  Whether to return clusters that have been unregistered.

	*/
	GetUnregisteredClusters *bool
	/*OpenshiftClusterID
	  A specific cluster to retrieve.

	*/
	OpenshiftClusterID *strfmt.UUID
	/*WithHosts
	  Include hosts in the returned list.

	*/
	WithHosts bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 list clusters params
func (o *V2ListClustersParams) WithTimeout(timeout time.Duration) *V2ListClustersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 list clusters params
func (o *V2ListClustersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 list clusters params
func (o *V2ListClustersParams) WithContext(ctx context.Context) *V2ListClustersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 list clusters params
func (o *V2ListClustersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 list clusters params
func (o *V2ListClustersParams) WithHTTPClient(client *http.Client) *V2ListClustersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 list clusters params
func (o *V2ListClustersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAmsSubscriptionIds adds the amsSubscriptionIds to the v2 list clusters params
func (o *V2ListClustersParams) WithAmsSubscriptionIds(amsSubscriptionIds []string) *V2ListClustersParams {
	o.SetAmsSubscriptionIds(amsSubscriptionIds)
	return o
}

// SetAmsSubscriptionIds adds the amsSubscriptionIds to the v2 list clusters params
func (o *V2ListClustersParams) SetAmsSubscriptionIds(amsSubscriptionIds []string) {
	o.AmsSubscriptionIds = amsSubscriptionIds
}

// WithGetUnregisteredClusters adds the getUnregisteredClusters to the v2 list clusters params
func (o *V2ListClustersParams) WithGetUnregisteredClusters(getUnregisteredClusters *bool) *V2ListClustersParams {
	o.SetGetUnregisteredClusters(getUnregisteredClusters)
	return o
}

// SetGetUnregisteredClusters adds the getUnregisteredClusters to the v2 list clusters params
func (o *V2ListClustersParams) SetGetUnregisteredClusters(getUnregisteredClusters *bool) {
	o.GetUnregisteredClusters = getUnregisteredClusters
}

// WithOpenshiftClusterID adds the openshiftClusterID to the v2 list clusters params
func (o *V2ListClustersParams) WithOpenshiftClusterID(openshiftClusterID *strfmt.UUID) *V2ListClustersParams {
	o.SetOpenshiftClusterID(openshiftClusterID)
	return o
}

// SetOpenshiftClusterID adds the openshiftClusterId to the v2 list clusters params
func (o *V2ListClustersParams) SetOpenshiftClusterID(openshiftClusterID *strfmt.UUID) {
	o.OpenshiftClusterID = openshiftClusterID
}

// WithWithHosts adds the withHosts to the v2 list clusters params
func (o *V2ListClustersParams) WithWithHosts(withHosts bool) *V2ListClustersParams {
	o.SetWithHosts(withHosts)
	return o
}

// SetWithHosts adds the withHosts to the v2 list clusters params
func (o *V2ListClustersParams) SetWithHosts(withHosts bool) {
	o.WithHosts = withHosts
}

// WriteToRequest writes these params to a swagger request
func (o *V2ListClustersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	valuesAmsSubscriptionIds := o.AmsSubscriptionIds

	joinedAmsSubscriptionIds := swag.JoinByFormat(valuesAmsSubscriptionIds, "")
	// query array param ams_subscription_ids
	if err := r.SetQueryParam("ams_subscription_ids", joinedAmsSubscriptionIds...); err != nil {
		return err
	}

	if o.GetUnregisteredClusters != nil {

		// header param get_unregistered_clusters
		if err := r.SetHeaderParam("get_unregistered_clusters", swag.FormatBool(*o.GetUnregisteredClusters)); err != nil {
			return err
		}

	}

	if o.OpenshiftClusterID != nil {

		// query param openshift_cluster_id
		var qrOpenshiftClusterID strfmt.UUID
		if o.OpenshiftClusterID != nil {
			qrOpenshiftClusterID = *o.OpenshiftClusterID
		}
		qOpenshiftClusterID := qrOpenshiftClusterID.String()
		if qOpenshiftClusterID != "" {
			if err := r.SetQueryParam("openshift_cluster_id", qOpenshiftClusterID); err != nil {
				return err
			}
		}

	}

	// query param with_hosts
	qrWithHosts := o.WithHosts
	qWithHosts := swag.FormatBool(qrWithHosts)
	if err := r.SetQueryParam("with_hosts", qWithHosts); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
