// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2ResetClusterParams creates a new V2ResetClusterParams object
// with the default values initialized.
func NewV2ResetClusterParams() *V2ResetClusterParams {
	var ()
	return &V2ResetClusterParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2ResetClusterParamsWithTimeout creates a new V2ResetClusterParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2ResetClusterParamsWithTimeout(timeout time.Duration) *V2ResetClusterParams {
	var ()
	return &V2ResetClusterParams{

		timeout: timeout,
	}
}

// NewV2ResetClusterParamsWithContext creates a new V2ResetClusterParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2ResetClusterParamsWithContext(ctx context.Context) *V2ResetClusterParams {
	var ()
	return &V2ResetClusterParams{

		Context: ctx,
	}
}

// NewV2ResetClusterParamsWithHTTPClient creates a new V2ResetClusterParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2ResetClusterParamsWithHTTPClient(client *http.Client) *V2ResetClusterParams {
	var ()
	return &V2ResetClusterParams{
		HTTPClient: client,
	}
}

/*V2ResetClusterParams contains all the parameters to send to the API endpoint
for the v2 reset cluster operation typically these are written to a http.Request
*/
type V2ResetClusterParams struct {

	/*ClusterID
	  The cluster whose installation is to be reset.

	*/
	ClusterID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 reset cluster params
func (o *V2ResetClusterParams) WithTimeout(timeout time.Duration) *V2ResetClusterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 reset cluster params
func (o *V2ResetClusterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 reset cluster params
func (o *V2ResetClusterParams) WithContext(ctx context.Context) *V2ResetClusterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 reset cluster params
func (o *V2ResetClusterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 reset cluster params
func (o *V2ResetClusterParams) WithHTTPClient(client *http.Client) *V2ResetClusterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 reset cluster params
func (o *V2ResetClusterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 reset cluster params
func (o *V2ResetClusterParams) WithClusterID(clusterID strfmt.UUID) *V2ResetClusterParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 reset cluster params
func (o *V2ResetClusterParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WriteToRequest writes these params to a swagger request
func (o *V2ResetClusterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
