// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2UpdateClusterLogsProgressParams creates a new V2UpdateClusterLogsProgressParams object
// with the default values initialized.
func NewV2UpdateClusterLogsProgressParams() *V2UpdateClusterLogsProgressParams {
	var ()
	return &V2UpdateClusterLogsProgressParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2UpdateClusterLogsProgressParamsWithTimeout creates a new V2UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2UpdateClusterLogsProgressParamsWithTimeout(timeout time.Duration) *V2UpdateClusterLogsProgressParams {
	var ()
	return &V2UpdateClusterLogsProgressParams{

		timeout: timeout,
	}
}

// NewV2UpdateClusterLogsProgressParamsWithContext creates a new V2UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2UpdateClusterLogsProgressParamsWithContext(ctx context.Context) *V2UpdateClusterLogsProgressParams {
	var ()
	return &V2UpdateClusterLogsProgressParams{

		Context: ctx,
	}
}

// NewV2UpdateClusterLogsProgressParamsWithHTTPClient creates a new V2UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2UpdateClusterLogsProgressParamsWithHTTPClient(client *http.Client) *V2UpdateClusterLogsProgressParams {
	var ()
	return &V2UpdateClusterLogsProgressParams{
		HTTPClient: client,
	}
}

/*V2UpdateClusterLogsProgressParams contains all the parameters to send to the API endpoint
for the v2 update cluster logs progress operation typically these are written to a http.Request
*/
type V2UpdateClusterLogsProgressParams struct {

	/*ClusterID
	  The cluster whose log progress is being updated.

	*/
	ClusterID strfmt.UUID
	/*LogsProgressParams
	  Parameters for updating log progress.

	*/
	LogsProgressParams *models.LogsProgressParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) WithTimeout(timeout time.Duration) *V2UpdateClusterLogsProgressParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) WithContext(ctx context.Context) *V2UpdateClusterLogsProgressParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) WithHTTPClient(client *http.Client) *V2UpdateClusterLogsProgressParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) WithClusterID(clusterID strfmt.UUID) *V2UpdateClusterLogsProgressParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithLogsProgressParams adds the logsProgressParams to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) WithLogsProgressParams(logsProgressParams *models.LogsProgressParams) *V2UpdateClusterLogsProgressParams {
	o.SetLogsProgressParams(logsProgressParams)
	return o
}

// SetLogsProgressParams adds the logsProgressParams to the v2 update cluster logs progress params
func (o *V2UpdateClusterLogsProgressParams) SetLogsProgressParams(logsProgressParams *models.LogsProgressParams) {
	o.LogsProgressParams = logsProgressParams
}

// WriteToRequest writes these params to a swagger request
func (o *V2UpdateClusterLogsProgressParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.LogsProgressParams != nil {
		if err := r.SetBodyParam(o.LogsProgressParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
