// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2UploadClusterIngressCertParams creates a new V2UploadClusterIngressCertParams object
// with the default values initialized.
func NewV2UploadClusterIngressCertParams() *V2UploadClusterIngressCertParams {
	var ()
	return &V2UploadClusterIngressCertParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2UploadClusterIngressCertParamsWithTimeout creates a new V2UploadClusterIngressCertParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2UploadClusterIngressCertParamsWithTimeout(timeout time.Duration) *V2UploadClusterIngressCertParams {
	var ()
	return &V2UploadClusterIngressCertParams{

		timeout: timeout,
	}
}

// NewV2UploadClusterIngressCertParamsWithContext creates a new V2UploadClusterIngressCertParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2UploadClusterIngressCertParamsWithContext(ctx context.Context) *V2UploadClusterIngressCertParams {
	var ()
	return &V2UploadClusterIngressCertParams{

		Context: ctx,
	}
}

// NewV2UploadClusterIngressCertParamsWithHTTPClient creates a new V2UploadClusterIngressCertParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2UploadClusterIngressCertParamsWithHTTPClient(client *http.Client) *V2UploadClusterIngressCertParams {
	var ()
	return &V2UploadClusterIngressCertParams{
		HTTPClient: client,
	}
}

/*V2UploadClusterIngressCertParams contains all the parameters to send to the API endpoint
for the v2 upload cluster ingress cert operation typically these are written to a http.Request
*/
type V2UploadClusterIngressCertParams struct {

	/*ClusterID
	  The cluster to associate with the ingress certificate.

	*/
	ClusterID strfmt.UUID
	/*DiscoveryAgentVersion
	  The software version of the discovery agent that is uploading the ingress certificate.

	*/
	DiscoveryAgentVersion *string
	/*IngressCertParams
	  The ingress certificate.

	*/
	IngressCertParams models.IngressCertParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithTimeout(timeout time.Duration) *V2UploadClusterIngressCertParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithContext(ctx context.Context) *V2UploadClusterIngressCertParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithHTTPClient(client *http.Client) *V2UploadClusterIngressCertParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithClusterID(clusterID strfmt.UUID) *V2UploadClusterIngressCertParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *V2UploadClusterIngressCertParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithIngressCertParams adds the ingressCertParams to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) WithIngressCertParams(ingressCertParams models.IngressCertParams) *V2UploadClusterIngressCertParams {
	o.SetIngressCertParams(ingressCertParams)
	return o
}

// SetIngressCertParams adds the ingressCertParams to the v2 upload cluster ingress cert params
func (o *V2UploadClusterIngressCertParams) SetIngressCertParams(ingressCertParams models.IngressCertParams) {
	o.IngressCertParams = ingressCertParams
}

// WriteToRequest writes these params to a swagger request
func (o *V2UploadClusterIngressCertParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}

	}

	if err := r.SetBodyParam(o.IngressCertParams); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
