// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2UploadLogsParams creates a new V2UploadLogsParams object
// with the default values initialized.
func NewV2UploadLogsParams() *V2UploadLogsParams {
	var ()
	return &V2UploadLogsParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2UploadLogsParamsWithTimeout creates a new V2UploadLogsParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2UploadLogsParamsWithTimeout(timeout time.Duration) *V2UploadLogsParams {
	var ()
	return &V2UploadLogsParams{

		timeout: timeout,
	}
}

// NewV2UploadLogsParamsWithContext creates a new V2UploadLogsParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2UploadLogsParamsWithContext(ctx context.Context) *V2UploadLogsParams {
	var ()
	return &V2UploadLogsParams{

		Context: ctx,
	}
}

// NewV2UploadLogsParamsWithHTTPClient creates a new V2UploadLogsParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2UploadLogsParamsWithHTTPClient(client *http.Client) *V2UploadLogsParams {
	var ()
	return &V2UploadLogsParams{
		HTTPClient: client,
	}
}

/*V2UploadLogsParams contains all the parameters to send to the API endpoint
for the v2 upload logs operation typically these are written to a http.Request
*/
type V2UploadLogsParams struct {

	/*ClusterID
	  The cluster whose logs should be uploaded.

	*/
	ClusterID strfmt.UUID
	/*HostID
	  The host whose logs should be uploaded.

	*/
	HostID *strfmt.UUID
	/*InfraEnvID
	  The infra_env_id of the host.

	*/
	InfraEnvID *strfmt.UUID
	/*LogsType
	  The type of log file to be uploaded.

	*/
	LogsType string
	/*Upfile
	  The log file to be uploaded.

	*/
	Upfile runtime.NamedReadCloser

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 upload logs params
func (o *V2UploadLogsParams) WithTimeout(timeout time.Duration) *V2UploadLogsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 upload logs params
func (o *V2UploadLogsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 upload logs params
func (o *V2UploadLogsParams) WithContext(ctx context.Context) *V2UploadLogsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 upload logs params
func (o *V2UploadLogsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 upload logs params
func (o *V2UploadLogsParams) WithHTTPClient(client *http.Client) *V2UploadLogsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 upload logs params
func (o *V2UploadLogsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 upload logs params
func (o *V2UploadLogsParams) WithClusterID(clusterID strfmt.UUID) *V2UploadLogsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 upload logs params
func (o *V2UploadLogsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the v2 upload logs params
func (o *V2UploadLogsParams) WithHostID(hostID *strfmt.UUID) *V2UploadLogsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 upload logs params
func (o *V2UploadLogsParams) SetHostID(hostID *strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 upload logs params
func (o *V2UploadLogsParams) WithInfraEnvID(infraEnvID *strfmt.UUID) *V2UploadLogsParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 upload logs params
func (o *V2UploadLogsParams) SetInfraEnvID(infraEnvID *strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WithLogsType adds the logsType to the v2 upload logs params
func (o *V2UploadLogsParams) WithLogsType(logsType string) *V2UploadLogsParams {
	o.SetLogsType(logsType)
	return o
}

// SetLogsType adds the logsType to the v2 upload logs params
func (o *V2UploadLogsParams) SetLogsType(logsType string) {
	o.LogsType = logsType
}

// WithUpfile adds the upfile to the v2 upload logs params
func (o *V2UploadLogsParams) WithUpfile(upfile runtime.NamedReadCloser) *V2UploadLogsParams {
	o.SetUpfile(upfile)
	return o
}

// SetUpfile adds the upfile to the v2 upload logs params
func (o *V2UploadLogsParams) SetUpfile(upfile runtime.NamedReadCloser) {
	o.Upfile = upfile
}

// WriteToRequest writes these params to a swagger request
func (o *V2UploadLogsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.HostID != nil {

		// query param host_id
		var qrHostID strfmt.UUID
		if o.HostID != nil {
			qrHostID = *o.HostID
		}
		qHostID := qrHostID.String()
		if qHostID != "" {
			if err := r.SetQueryParam("host_id", qHostID); err != nil {
				return err
			}
		}

	}

	if o.InfraEnvID != nil {

		// query param infra_env_id
		var qrInfraEnvID strfmt.UUID
		if o.InfraEnvID != nil {
			qrInfraEnvID = *o.InfraEnvID
		}
		qInfraEnvID := qrInfraEnvID.String()
		if qInfraEnvID != "" {
			if err := r.SetQueryParam("infra_env_id", qInfraEnvID); err != nil {
				return err
			}
		}

	}

	// query param logs_type
	qrLogsType := o.LogsType
	qLogsType := qrLogsType
	if qLogsType != "" {
		if err := r.SetQueryParam("logs_type", qLogsType); err != nil {
			return err
		}
	}

	if o.Upfile != nil {

		if o.Upfile != nil {

			// form file param upfile
			if err := r.SetFileParam("upfile", o.Upfile); err != nil {
				return err
			}

		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
