// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2CreateClusterManifestParams creates a new V2CreateClusterManifestParams object
// with the default values initialized.
func NewV2CreateClusterManifestParams() *V2CreateClusterManifestParams {
	var ()
	return &V2CreateClusterManifestParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewV2CreateClusterManifestParamsWithTimeout creates a new V2CreateClusterManifestParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewV2CreateClusterManifestParamsWithTimeout(timeout time.Duration) *V2CreateClusterManifestParams {
	var ()
	return &V2CreateClusterManifestParams{

		timeout: timeout,
	}
}

// NewV2CreateClusterManifestParamsWithContext creates a new V2CreateClusterManifestParams object
// with the default values initialized, and the ability to set a context for a request
func NewV2CreateClusterManifestParamsWithContext(ctx context.Context) *V2CreateClusterManifestParams {
	var ()
	return &V2CreateClusterManifestParams{

		Context: ctx,
	}
}

// NewV2CreateClusterManifestParamsWithHTTPClient creates a new V2CreateClusterManifestParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewV2CreateClusterManifestParamsWithHTTPClient(client *http.Client) *V2CreateClusterManifestParams {
	var ()
	return &V2CreateClusterManifestParams{
		HTTPClient: client,
	}
}

/*V2CreateClusterManifestParams contains all the parameters to send to the API endpoint
for the v2 create cluster manifest operation typically these are written to a http.Request
*/
type V2CreateClusterManifestParams struct {

	/*CreateManifestParams
	  The new manifest to create.

	*/
	CreateManifestParams *models.CreateManifestParams
	/*ClusterID
	  The cluster for which a new manifest should be created.

	*/
	ClusterID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) WithTimeout(timeout time.Duration) *V2CreateClusterManifestParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) WithContext(ctx context.Context) *V2CreateClusterManifestParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) WithHTTPClient(client *http.Client) *V2CreateClusterManifestParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateManifestParams adds the createManifestParams to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) WithCreateManifestParams(createManifestParams *models.CreateManifestParams) *V2CreateClusterManifestParams {
	o.SetCreateManifestParams(createManifestParams)
	return o
}

// SetCreateManifestParams adds the createManifestParams to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) SetCreateManifestParams(createManifestParams *models.CreateManifestParams) {
	o.CreateManifestParams = createManifestParams
}

// WithClusterID adds the clusterID to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) WithClusterID(clusterID strfmt.UUID) *V2CreateClusterManifestParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 create cluster manifest params
func (o *V2CreateClusterManifestParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WriteToRequest writes these params to a swagger request
func (o *V2CreateClusterManifestParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateManifestParams != nil {
		if err := r.SetBodyParam(o.CreateManifestParams); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
