// Code generated by go-swagger; DO NOT EDIT.

package operators

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// ListOperatorPropertiesReader is a Reader for the ListOperatorProperties structure.
type ListOperatorPropertiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListOperatorPropertiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListOperatorPropertiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewListOperatorPropertiesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListOperatorPropertiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewListOperatorPropertiesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListOperatorPropertiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewListOperatorPropertiesOK creates a ListOperatorPropertiesOK with default headers values
func NewListOperatorPropertiesOK() *ListOperatorPropertiesOK {
	return &ListOperatorPropertiesOK{}
}

/*ListOperatorPropertiesOK handles this case with default header values.

Success.
*/
type ListOperatorPropertiesOK struct {
	Payload models.OperatorProperties
}

func (o *ListOperatorPropertiesOK) Error() string {
	return fmt.Sprintf("[GET /v1/supported-operators/{operator_name}][%d] listOperatorPropertiesOK  %+v", 200, o.Payload)
}

func (o *ListOperatorPropertiesOK) GetPayload() models.OperatorProperties {
	return o.Payload
}

func (o *ListOperatorPropertiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListOperatorPropertiesUnauthorized creates a ListOperatorPropertiesUnauthorized with default headers values
func NewListOperatorPropertiesUnauthorized() *ListOperatorPropertiesUnauthorized {
	return &ListOperatorPropertiesUnauthorized{}
}

/*ListOperatorPropertiesUnauthorized handles this case with default header values.

Unauthorized.
*/
type ListOperatorPropertiesUnauthorized struct {
	Payload *models.InfraError
}

func (o *ListOperatorPropertiesUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/supported-operators/{operator_name}][%d] listOperatorPropertiesUnauthorized  %+v", 401, o.Payload)
}

func (o *ListOperatorPropertiesUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListOperatorPropertiesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListOperatorPropertiesForbidden creates a ListOperatorPropertiesForbidden with default headers values
func NewListOperatorPropertiesForbidden() *ListOperatorPropertiesForbidden {
	return &ListOperatorPropertiesForbidden{}
}

/*ListOperatorPropertiesForbidden handles this case with default header values.

Forbidden.
*/
type ListOperatorPropertiesForbidden struct {
	Payload *models.InfraError
}

func (o *ListOperatorPropertiesForbidden) Error() string {
	return fmt.Sprintf("[GET /v1/supported-operators/{operator_name}][%d] listOperatorPropertiesForbidden  %+v", 403, o.Payload)
}

func (o *ListOperatorPropertiesForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListOperatorPropertiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListOperatorPropertiesNotFound creates a ListOperatorPropertiesNotFound with default headers values
func NewListOperatorPropertiesNotFound() *ListOperatorPropertiesNotFound {
	return &ListOperatorPropertiesNotFound{}
}

/*ListOperatorPropertiesNotFound handles this case with default header values.

Error.
*/
type ListOperatorPropertiesNotFound struct {
	Payload *models.Error
}

func (o *ListOperatorPropertiesNotFound) Error() string {
	return fmt.Sprintf("[GET /v1/supported-operators/{operator_name}][%d] listOperatorPropertiesNotFound  %+v", 404, o.Payload)
}

func (o *ListOperatorPropertiesNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListOperatorPropertiesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListOperatorPropertiesInternalServerError creates a ListOperatorPropertiesInternalServerError with default headers values
func NewListOperatorPropertiesInternalServerError() *ListOperatorPropertiesInternalServerError {
	return &ListOperatorPropertiesInternalServerError{}
}

/*ListOperatorPropertiesInternalServerError handles this case with default header values.

Error.
*/
type ListOperatorPropertiesInternalServerError struct {
	Payload *models.Error
}

func (o *ListOperatorPropertiesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /v1/supported-operators/{operator_name}][%d] listOperatorPropertiesInternalServerError  %+v", 500, o.Payload)
}

func (o *ListOperatorPropertiesInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListOperatorPropertiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
