// Code generated by generate_events. DO NOT EDIT.
package events

import (
    "context"
    "fmt"
    "strings"
    "time"
    "github.com/openshift/assisted-service/internal/events"

    "github.com/go-openapi/strfmt"
)

//
// Event generic_cluster
//
type GenericClusterEvent struct {
    ClusterId strfmt.UUID
    Message string
    Severity string
}

var GenericClusterEventName string = "generic_cluster"

func NewGenericClusterEvent(
    clusterId strfmt.UUID,
    message string,
    severity string,
) *GenericClusterEvent {
    return &GenericClusterEvent{
        ClusterId: clusterId,
        Message: message,
        Severity: severity,
    }
}

func SendGenericClusterEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    message string,
    severity string,) {
    ev := NewGenericClusterEvent(
        clusterId,
        message,
        severity,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendGenericClusterEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    message string,
    severity string,
    eventTime time.Time) {
    ev := NewGenericClusterEvent(
        clusterId,
        message,
        severity,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *GenericClusterEvent) GetName() string {
    return "generic_cluster"
}

func (e *GenericClusterEvent) GetSeverity() string {
    return e.Severity
}
func (e *GenericClusterEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *GenericClusterEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{message}", fmt.Sprint(e.Message),
        "{severity}", fmt.Sprint(e.Severity),
    )
    return r.Replace(*message)
}

func (e *GenericClusterEvent) FormatMessage() string {
    s := "{message}"
    return e.format(&s)
}

//
// Event generic_host
//
type GenericHostEvent struct {
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    Message string
    Severity string
}

var GenericHostEventName string = "generic_host"

func NewGenericHostEvent(
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    message string,
    severity string,
) *GenericHostEvent {
    return &GenericHostEvent{
        HostId: hostId,
        InfraEnvId: infraEnvId,
        Message: message,
        Severity: severity,
    }
}

func SendGenericHostEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    message string,
    severity string,) {
    ev := NewGenericHostEvent(
        hostId,
        infraEnvId,
        message,
        severity,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendGenericHostEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    message string,
    severity string,
    eventTime time.Time) {
    ev := NewGenericHostEvent(
        hostId,
        infraEnvId,
        message,
        severity,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *GenericHostEvent) GetName() string {
    return "generic_host"
}

func (e *GenericHostEvent) GetSeverity() string {
    return e.Severity
}
func (e *GenericHostEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *GenericHostEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *GenericHostEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *GenericHostEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{message}", fmt.Sprint(e.Message),
        "{severity}", fmt.Sprint(e.Severity),
    )
    return r.Replace(*message)
}

func (e *GenericHostEvent) FormatMessage() string {
    s := "{message}"
    return e.format(&s)
}

//
// Event cancel_install_failed_start
//
type CancelInstallFailedStartEvent struct {
    ClusterId strfmt.UUID
}

var CancelInstallFailedStartEventName string = "cancel_install_failed_start"

func NewCancelInstallFailedStartEvent(
    clusterId strfmt.UUID,
) *CancelInstallFailedStartEvent {
    return &CancelInstallFailedStartEvent{
        ClusterId: clusterId,
    }
}

func SendCancelInstallFailedStartEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewCancelInstallFailedStartEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendCancelInstallFailedStartEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewCancelInstallFailedStartEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *CancelInstallFailedStartEvent) GetName() string {
    return "cancel_install_failed_start"
}

func (e *CancelInstallFailedStartEvent) GetSeverity() string {
    return "error"
}
func (e *CancelInstallFailedStartEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *CancelInstallFailedStartEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *CancelInstallFailedStartEvent) FormatMessage() string {
    s := "Failed to cancel installation: error starting DB transaction"
    return e.format(&s)
}

//
// Event cancel_install_failed_commit
//
type CancelInstallFailedCommitEvent struct {
    ClusterId strfmt.UUID
}

var CancelInstallFailedCommitEventName string = "cancel_install_failed_commit"

func NewCancelInstallFailedCommitEvent(
    clusterId strfmt.UUID,
) *CancelInstallFailedCommitEvent {
    return &CancelInstallFailedCommitEvent{
        ClusterId: clusterId,
    }
}

func SendCancelInstallFailedCommitEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewCancelInstallFailedCommitEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendCancelInstallFailedCommitEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewCancelInstallFailedCommitEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *CancelInstallFailedCommitEvent) GetName() string {
    return "cancel_install_failed_commit"
}

func (e *CancelInstallFailedCommitEvent) GetSeverity() string {
    return "error"
}
func (e *CancelInstallFailedCommitEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *CancelInstallFailedCommitEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *CancelInstallFailedCommitEvent) FormatMessage() string {
    s := "Failed to cancel installation: error committing DB transaction"
    return e.format(&s)
}

//
// Event host_registration_failed_setting_properties
//
type HostRegistrationFailedSettingPropertiesEvent struct {
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
}

var HostRegistrationFailedSettingPropertiesEventName string = "host_registration_failed_setting_properties"

func NewHostRegistrationFailedSettingPropertiesEvent(
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
) *HostRegistrationFailedSettingPropertiesEvent {
    return &HostRegistrationFailedSettingPropertiesEvent{
        HostId: hostId,
        InfraEnvId: infraEnvId,
    }
}

func SendHostRegistrationFailedSettingPropertiesEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,) {
    ev := NewHostRegistrationFailedSettingPropertiesEvent(
        hostId,
        infraEnvId,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostRegistrationFailedSettingPropertiesEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    eventTime time.Time) {
    ev := NewHostRegistrationFailedSettingPropertiesEvent(
        hostId,
        infraEnvId,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostRegistrationFailedSettingPropertiesEvent) GetName() string {
    return "host_registration_failed_setting_properties"
}

func (e *HostRegistrationFailedSettingPropertiesEvent) GetSeverity() string {
    return "error"
}
func (e *HostRegistrationFailedSettingPropertiesEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *HostRegistrationFailedSettingPropertiesEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostRegistrationFailedSettingPropertiesEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostRegistrationFailedSettingPropertiesEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
    )
    return r.Replace(*message)
}

func (e *HostRegistrationFailedSettingPropertiesEvent) FormatMessage() string {
    s := "Failed to register host: error setting host properties"
    return e.format(&s)
}

//
// Event cluster_registration_failed
//
type ClusterRegistrationFailedEvent struct {
    ClusterId strfmt.UUID
    Error string
    ClusterKind string
}

var ClusterRegistrationFailedEventName string = "cluster_registration_failed"

func NewClusterRegistrationFailedEvent(
    clusterId strfmt.UUID,
    error string,
    clusterKind string,
) *ClusterRegistrationFailedEvent {
    return &ClusterRegistrationFailedEvent{
        ClusterId: clusterId,
        Error: error,
        ClusterKind: clusterKind,
    }
}

func SendClusterRegistrationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    clusterKind string,) {
    ev := NewClusterRegistrationFailedEvent(
        clusterId,
        error,
        clusterKind,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterRegistrationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    clusterKind string,
    eventTime time.Time) {
    ev := NewClusterRegistrationFailedEvent(
        clusterId,
        error,
        clusterKind,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterRegistrationFailedEvent) GetName() string {
    return "cluster_registration_failed"
}

func (e *ClusterRegistrationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *ClusterRegistrationFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterRegistrationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{error}", fmt.Sprint(e.Error),
        "{cluster_kind}", fmt.Sprint(e.ClusterKind),
    )
    return r.Replace(*message)
}

func (e *ClusterRegistrationFailedEvent) FormatMessage() string {
    s := "Failed to register cluster. Error: {error}"
    return e.format(&s)
}

//
// Event cluster_registration_succeeded
//
type ClusterRegistrationSucceededEvent struct {
    ClusterId strfmt.UUID
}

var ClusterRegistrationSucceededEventName string = "cluster_registration_succeeded"

func NewClusterRegistrationSucceededEvent(
    clusterId strfmt.UUID,
) *ClusterRegistrationSucceededEvent {
    return &ClusterRegistrationSucceededEvent{
        ClusterId: clusterId,
    }
}

func SendClusterRegistrationSucceededEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterRegistrationSucceededEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterRegistrationSucceededEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterRegistrationSucceededEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterRegistrationSucceededEvent) GetName() string {
    return "cluster_registration_succeeded"
}

func (e *ClusterRegistrationSucceededEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterRegistrationSucceededEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterRegistrationSucceededEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterRegistrationSucceededEvent) FormatMessage() string {
    s := "Successfully registered cluster"
    return e.format(&s)
}

//
// Event registered_cluster
//
type RegisteredClusterEvent struct {
    ClusterId strfmt.UUID
    ClusterKind string
}

var RegisteredClusterEventName string = "registered_cluster"

func NewRegisteredClusterEvent(
    clusterId strfmt.UUID,
    clusterKind string,
) *RegisteredClusterEvent {
    return &RegisteredClusterEvent{
        ClusterId: clusterId,
        ClusterKind: clusterKind,
    }
}

func SendRegisteredClusterEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    clusterKind string,) {
    ev := NewRegisteredClusterEvent(
        clusterId,
        clusterKind,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendRegisteredClusterEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    clusterKind string,
    eventTime time.Time) {
    ev := NewRegisteredClusterEvent(
        clusterId,
        clusterKind,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *RegisteredClusterEvent) GetName() string {
    return "registered_cluster"
}

func (e *RegisteredClusterEvent) GetSeverity() string {
    return "info"
}
func (e *RegisteredClusterEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *RegisteredClusterEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{cluster_kind}", fmt.Sprint(e.ClusterKind),
    )
    return r.Replace(*message)
}

func (e *RegisteredClusterEvent) FormatMessage() string {
    s := "Registered cluster"
    return e.format(&s)
}

//
// Event cluster_deregister_failed
//
type ClusterDeregisterFailedEvent struct {
    ClusterId strfmt.UUID
    Error string
}

var ClusterDeregisterFailedEventName string = "cluster_deregister_failed"

func NewClusterDeregisterFailedEvent(
    clusterId strfmt.UUID,
    error string,
) *ClusterDeregisterFailedEvent {
    return &ClusterDeregisterFailedEvent{
        ClusterId: clusterId,
        Error: error,
    }
}

func SendClusterDeregisterFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,) {
    ev := NewClusterDeregisterFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterDeregisterFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewClusterDeregisterFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterDeregisterFailedEvent) GetName() string {
    return "cluster_deregister_failed"
}

func (e *ClusterDeregisterFailedEvent) GetSeverity() string {
    return "error"
}
func (e *ClusterDeregisterFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterDeregisterFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *ClusterDeregisterFailedEvent) FormatMessage() string {
    s := "Failed to deregister cluster. Error: {error}"
    return e.format(&s)
}

//
// Event deregistered_cluster
//
type DeregisteredClusterEvent struct {
    ClusterId strfmt.UUID
}

var DeregisteredClusterEventName string = "deregistered_cluster"

func NewDeregisteredClusterEvent(
    clusterId strfmt.UUID,
) *DeregisteredClusterEvent {
    return &DeregisteredClusterEvent{
        ClusterId: clusterId,
    }
}

func SendDeregisteredClusterEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewDeregisteredClusterEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendDeregisteredClusterEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewDeregisteredClusterEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *DeregisteredClusterEvent) GetName() string {
    return "deregistered_cluster"
}

func (e *DeregisteredClusterEvent) GetSeverity() string {
    return "info"
}
func (e *DeregisteredClusterEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *DeregisteredClusterEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *DeregisteredClusterEvent) FormatMessage() string {
    s := "Deregistered cluster"
    return e.format(&s)
}

//
// Event cluster_validation_falling
//
type ClusterValidationFallingEvent struct {
    ClusterId strfmt.UUID
    ValidationId string
    ValidationMsg string
}

var ClusterValidationFallingEventName string = "cluster_validation_falling"

func NewClusterValidationFallingEvent(
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,
) *ClusterValidationFallingEvent {
    return &ClusterValidationFallingEvent{
        ClusterId: clusterId,
        ValidationId: validationId,
        ValidationMsg: validationMsg,
    }
}

func SendClusterValidationFallingEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,) {
    ev := NewClusterValidationFallingEvent(
        clusterId,
        validationId,
        validationMsg,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterValidationFallingEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,
    eventTime time.Time) {
    ev := NewClusterValidationFallingEvent(
        clusterId,
        validationId,
        validationMsg,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterValidationFallingEvent) GetName() string {
    return "cluster_validation_falling"
}

func (e *ClusterValidationFallingEvent) GetSeverity() string {
    return "warning"
}
func (e *ClusterValidationFallingEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterValidationFallingEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{validation_id}", fmt.Sprint(e.ValidationId),
        "{validation_msg}", fmt.Sprint(e.ValidationMsg),
    )
    return r.Replace(*message)
}

func (e *ClusterValidationFallingEvent) FormatMessage() string {
    s := "Cluster validation '{validation_id}' that used to succeed is now failing"
    return e.format(&s)
}

//
// Event cluster_validation_fixed
//
type ClusterValidationFixedEvent struct {
    ClusterId strfmt.UUID
    ValidationId string
    ValidationMsg string
}

var ClusterValidationFixedEventName string = "cluster_validation_fixed"

func NewClusterValidationFixedEvent(
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,
) *ClusterValidationFixedEvent {
    return &ClusterValidationFixedEvent{
        ClusterId: clusterId,
        ValidationId: validationId,
        ValidationMsg: validationMsg,
    }
}

func SendClusterValidationFixedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,) {
    ev := NewClusterValidationFixedEvent(
        clusterId,
        validationId,
        validationMsg,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterValidationFixedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    validationId string,
    validationMsg string,
    eventTime time.Time) {
    ev := NewClusterValidationFixedEvent(
        clusterId,
        validationId,
        validationMsg,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterValidationFixedEvent) GetName() string {
    return "cluster_validation_fixed"
}

func (e *ClusterValidationFixedEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterValidationFixedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterValidationFixedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{validation_id}", fmt.Sprint(e.ValidationId),
        "{validation_msg}", fmt.Sprint(e.ValidationMsg),
    )
    return r.Replace(*message)
}

func (e *ClusterValidationFixedEvent) FormatMessage() string {
    s := "Cluster validation '{validation_id}' is now fixed"
    return e.format(&s)
}

//
// Event cluster_deregistered_after_inactivity
//
type ClusterDeregisteredAfterInactivityEvent struct {
    ClusterId strfmt.UUID
}

var ClusterDeregisteredAfterInactivityEventName string = "cluster_deregistered_after_inactivity"

func NewClusterDeregisteredAfterInactivityEvent(
    clusterId strfmt.UUID,
) *ClusterDeregisteredAfterInactivityEvent {
    return &ClusterDeregisteredAfterInactivityEvent{
        ClusterId: clusterId,
    }
}

func SendClusterDeregisteredAfterInactivityEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterDeregisteredAfterInactivityEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterDeregisteredAfterInactivityEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterDeregisteredAfterInactivityEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterDeregisteredAfterInactivityEvent) GetName() string {
    return "cluster_deregistered_after_inactivity"
}

func (e *ClusterDeregisteredAfterInactivityEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterDeregisteredAfterInactivityEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterDeregisteredAfterInactivityEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterDeregisteredAfterInactivityEvent) FormatMessage() string {
    s := "Cluster is deregistered due to inactivity"
    return e.format(&s)
}

//
// Event cluster_installing_finished
//
type ClusterInstallingFinishedEvent struct {
    ClusterId strfmt.UUID
}

var ClusterInstallingFinishedEventName string = "cluster_installing_finished"

func NewClusterInstallingFinishedEvent(
    clusterId strfmt.UUID,
) *ClusterInstallingFinishedEvent {
    return &ClusterInstallingFinishedEvent{
        ClusterId: clusterId,
    }
}

func SendClusterInstallingFinishedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterInstallingFinishedEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterInstallingFinishedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterInstallingFinishedEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterInstallingFinishedEvent) GetName() string {
    return "cluster_installing_finished"
}

func (e *ClusterInstallingFinishedEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterInstallingFinishedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterInstallingFinishedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterInstallingFinishedEvent) FormatMessage() string {
    s := "Successfully finished installing cluster"
    return e.format(&s)
}

//
// Event cluster_installing_failed
//
type ClusterInstallingFailedEvent struct {
    ClusterId strfmt.UUID
    FailureReason string
}

var ClusterInstallingFailedEventName string = "cluster_installing_failed"

func NewClusterInstallingFailedEvent(
    clusterId strfmt.UUID,
    failureReason string,
) *ClusterInstallingFailedEvent {
    return &ClusterInstallingFailedEvent{
        ClusterId: clusterId,
        FailureReason: failureReason,
    }
}

func SendClusterInstallingFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    failureReason string,) {
    ev := NewClusterInstallingFailedEvent(
        clusterId,
        failureReason,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterInstallingFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    failureReason string,
    eventTime time.Time) {
    ev := NewClusterInstallingFailedEvent(
        clusterId,
        failureReason,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterInstallingFailedEvent) GetName() string {
    return "cluster_installing_failed"
}

func (e *ClusterInstallingFailedEvent) GetSeverity() string {
    return "critical"
}
func (e *ClusterInstallingFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterInstallingFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{failure_reason}", fmt.Sprint(e.FailureReason),
    )
    return r.Replace(*message)
}

func (e *ClusterInstallingFailedEvent) FormatMessage() string {
    s := "Failed installing cluster. Reason: {failure_reason}"
    return e.format(&s)
}

//
// Event cluster_cancel_installation
//
type ClusterCancelInstallationEvent struct {
    ClusterId strfmt.UUID
}

var ClusterCancelInstallationEventName string = "cluster_cancel_installation"

func NewClusterCancelInstallationEvent(
    clusterId strfmt.UUID,
) *ClusterCancelInstallationEvent {
    return &ClusterCancelInstallationEvent{
        ClusterId: clusterId,
    }
}

func SendClusterCancelInstallationEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterCancelInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterCancelInstallationEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterCancelInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterCancelInstallationEvent) GetName() string {
    return "cluster_cancel_installation"
}

func (e *ClusterCancelInstallationEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterCancelInstallationEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterCancelInstallationEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterCancelInstallationEvent) FormatMessage() string {
    s := "Cancelled cluster installation"
    return e.format(&s)
}

//
// Event cancel_installation_failed
//
type CancelInstallationFailedEvent struct {
    ClusterId strfmt.UUID
    Error string
}

var CancelInstallationFailedEventName string = "cancel_installation_failed"

func NewCancelInstallationFailedEvent(
    clusterId strfmt.UUID,
    error string,
) *CancelInstallationFailedEvent {
    return &CancelInstallationFailedEvent{
        ClusterId: clusterId,
        Error: error,
    }
}

func SendCancelInstallationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,) {
    ev := NewCancelInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendCancelInstallationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewCancelInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *CancelInstallationFailedEvent) GetName() string {
    return "cancel_installation_failed"
}

func (e *CancelInstallationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *CancelInstallationFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *CancelInstallationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *CancelInstallationFailedEvent) FormatMessage() string {
    s := "Failed to cancel installation: {error}"
    return e.format(&s)
}

//
// Event cluster_status_updated
//
type ClusterStatusUpdatedEvent struct {
    ClusterId strfmt.UUID
    ClusterStatus string
    StatusInfo string
}

var ClusterStatusUpdatedEventName string = "cluster_status_updated"

func NewClusterStatusUpdatedEvent(
    clusterId strfmt.UUID,
    clusterStatus string,
    statusInfo string,
) *ClusterStatusUpdatedEvent {
    return &ClusterStatusUpdatedEvent{
        ClusterId: clusterId,
        ClusterStatus: clusterStatus,
        StatusInfo: statusInfo,
    }
}

func SendClusterStatusUpdatedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    clusterStatus string,
    statusInfo string,) {
    ev := NewClusterStatusUpdatedEvent(
        clusterId,
        clusterStatus,
        statusInfo,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterStatusUpdatedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    clusterStatus string,
    statusInfo string,
    eventTime time.Time) {
    ev := NewClusterStatusUpdatedEvent(
        clusterId,
        clusterStatus,
        statusInfo,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterStatusUpdatedEvent) GetName() string {
    return "cluster_status_updated"
}

func (e *ClusterStatusUpdatedEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterStatusUpdatedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterStatusUpdatedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{cluster_status}", fmt.Sprint(e.ClusterStatus),
        "{status_info}", fmt.Sprint(e.StatusInfo),
    )
    return r.Replace(*message)
}

func (e *ClusterStatusUpdatedEvent) FormatMessage() string {
    s := "Updated status of the cluster to {cluster_status}"
    return e.format(&s)
}

//
// Event cluster_reset_installation
//
type ClusterResetInstallationEvent struct {
    ClusterId strfmt.UUID
}

var ClusterResetInstallationEventName string = "cluster_reset_installation"

func NewClusterResetInstallationEvent(
    clusterId strfmt.UUID,
) *ClusterResetInstallationEvent {
    return &ClusterResetInstallationEvent{
        ClusterId: clusterId,
    }
}

func SendClusterResetInstallationEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterResetInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterResetInstallationEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterResetInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterResetInstallationEvent) GetName() string {
    return "cluster_reset_installation"
}

func (e *ClusterResetInstallationEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterResetInstallationEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterResetInstallationEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterResetInstallationEvent) FormatMessage() string {
    s := "Reset cluster installation"
    return e.format(&s)
}

//
// Event reset_installation_failed
//
type ResetInstallationFailedEvent struct {
    ClusterId strfmt.UUID
    Error string
}

var ResetInstallationFailedEventName string = "reset_installation_failed"

func NewResetInstallationFailedEvent(
    clusterId strfmt.UUID,
    error string,
) *ResetInstallationFailedEvent {
    return &ResetInstallationFailedEvent{
        ClusterId: clusterId,
        Error: error,
    }
}

func SendResetInstallationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,) {
    ev := NewResetInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendResetInstallationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewResetInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ResetInstallationFailedEvent) GetName() string {
    return "reset_installation_failed"
}

func (e *ResetInstallationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *ResetInstallationFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ResetInstallationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *ResetInstallationFailedEvent) FormatMessage() string {
    s := "Failed to reset installation. Error: {error}"
    return e.format(&s)
}

//
// Event api_ingress_vip_update
//
type ApiIngressVipUpdateEvent struct {
    ClusterId strfmt.UUID
    ApiVip string
    IngressVip string
}

var ApiIngressVipUpdateEventName string = "api_ingress_vip_update"

func NewApiIngressVipUpdateEvent(
    clusterId strfmt.UUID,
    apiVip string,
    ingressVip string,
) *ApiIngressVipUpdateEvent {
    return &ApiIngressVipUpdateEvent{
        ClusterId: clusterId,
        ApiVip: apiVip,
        IngressVip: ingressVip,
    }
}

func SendApiIngressVipUpdateEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    apiVip string,
    ingressVip string,) {
    ev := NewApiIngressVipUpdateEvent(
        clusterId,
        apiVip,
        ingressVip,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendApiIngressVipUpdateEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    apiVip string,
    ingressVip string,
    eventTime time.Time) {
    ev := NewApiIngressVipUpdateEvent(
        clusterId,
        apiVip,
        ingressVip,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ApiIngressVipUpdateEvent) GetName() string {
    return "api_ingress_vip_update"
}

func (e *ApiIngressVipUpdateEvent) GetSeverity() string {
    return "info"
}
func (e *ApiIngressVipUpdateEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ApiIngressVipUpdateEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{api_vip}", fmt.Sprint(e.ApiVip),
        "{ingress_vip}", fmt.Sprint(e.IngressVip),
    )
    return r.Replace(*message)
}

func (e *ApiIngressVipUpdateEvent) FormatMessage() string {
    s := "Cluster was updated with api-vip {api_vip}, ingress-vip {ingress_vip}"
    return e.format(&s)
}

//
// Event api_ingress_vip_timed_out
//
type ApiIngressVipTimedOutEvent struct {
    ClusterId strfmt.UUID
    TimeoutInterval int
}

var ApiIngressVipTimedOutEventName string = "api_ingress_vip_timed_out"

func NewApiIngressVipTimedOutEvent(
    clusterId strfmt.UUID,
    timeoutInterval int,
) *ApiIngressVipTimedOutEvent {
    return &ApiIngressVipTimedOutEvent{
        ClusterId: clusterId,
        TimeoutInterval: timeoutInterval,
    }
}

func SendApiIngressVipTimedOutEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    timeoutInterval int,) {
    ev := NewApiIngressVipTimedOutEvent(
        clusterId,
        timeoutInterval,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendApiIngressVipTimedOutEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    timeoutInterval int,
    eventTime time.Time) {
    ev := NewApiIngressVipTimedOutEvent(
        clusterId,
        timeoutInterval,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ApiIngressVipTimedOutEvent) GetName() string {
    return "api_ingress_vip_timed_out"
}

func (e *ApiIngressVipTimedOutEvent) GetSeverity() string {
    return "warning"
}
func (e *ApiIngressVipTimedOutEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ApiIngressVipTimedOutEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{timeout_interval}", fmt.Sprint(e.TimeoutInterval),
    )
    return r.Replace(*message)
}

func (e *ApiIngressVipTimedOutEvent) FormatMessage() string {
    s := "API and Ingress VIPs lease allocation has been timed out"
    return e.format(&s)
}

//
// Event prepare_installation_failed
//
type PrepareInstallationFailedEvent struct {
    ClusterId strfmt.UUID
    Error string
}

var PrepareInstallationFailedEventName string = "prepare_installation_failed"

func NewPrepareInstallationFailedEvent(
    clusterId strfmt.UUID,
    error string,
) *PrepareInstallationFailedEvent {
    return &PrepareInstallationFailedEvent{
        ClusterId: clusterId,
        Error: error,
    }
}

func SendPrepareInstallationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,) {
    ev := NewPrepareInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendPrepareInstallationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewPrepareInstallationFailedEvent(
        clusterId,
        error,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *PrepareInstallationFailedEvent) GetName() string {
    return "prepare_installation_failed"
}

func (e *PrepareInstallationFailedEvent) GetSeverity() string {
    return "warning"
}
func (e *PrepareInstallationFailedEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *PrepareInstallationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *PrepareInstallationFailedEvent) FormatMessage() string {
    s := "Failed to prepare the installation due to an unexpected error: {error}. Please retry later"
    return e.format(&s)
}

//
// Event cluster_prepare_installation
//
type ClusterPrepareInstallationEvent struct {
    ClusterId strfmt.UUID
}

var ClusterPrepareInstallationEventName string = "cluster_prepare_installation"

func NewClusterPrepareInstallationEvent(
    clusterId strfmt.UUID,
) *ClusterPrepareInstallationEvent {
    return &ClusterPrepareInstallationEvent{
        ClusterId: clusterId,
    }
}

func SendClusterPrepareInstallationEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewClusterPrepareInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterPrepareInstallationEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewClusterPrepareInstallationEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterPrepareInstallationEvent) GetName() string {
    return "cluster_prepare_installation"
}

func (e *ClusterPrepareInstallationEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterPrepareInstallationEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterPrepareInstallationEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *ClusterPrepareInstallationEvent) FormatMessage() string {
    s := "Cluster was prepared successfully for installation"
    return e.format(&s)
}

//
// Event installation_preparing_timed_out
//
type InstallationPreparingTimedOutEvent struct {
    ClusterId strfmt.UUID
}

var InstallationPreparingTimedOutEventName string = "installation_preparing_timed_out"

func NewInstallationPreparingTimedOutEvent(
    clusterId strfmt.UUID,
) *InstallationPreparingTimedOutEvent {
    return &InstallationPreparingTimedOutEvent{
        ClusterId: clusterId,
    }
}

func SendInstallationPreparingTimedOutEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewInstallationPreparingTimedOutEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendInstallationPreparingTimedOutEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewInstallationPreparingTimedOutEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *InstallationPreparingTimedOutEvent) GetName() string {
    return "installation_preparing_timed_out"
}

func (e *InstallationPreparingTimedOutEvent) GetSeverity() string {
    return "warning"
}
func (e *InstallationPreparingTimedOutEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *InstallationPreparingTimedOutEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *InstallationPreparingTimedOutEvent) FormatMessage() string {
    s := "Preparing for installation was timed out for the cluster"
    return e.format(&s)
}

//
// Event cluster_degraded_failed_OLM_operators
//
type ClusterDegradedFailedOLMOperatorsEvent struct {
    ClusterId strfmt.UUID
    FailedOperators string
}

var ClusterDegradedFailedOLMOperatorsEventName string = "cluster_degraded_failed_OLM_operators"

func NewClusterDegradedFailedOLMOperatorsEvent(
    clusterId strfmt.UUID,
    failedOperators string,
) *ClusterDegradedFailedOLMOperatorsEvent {
    return &ClusterDegradedFailedOLMOperatorsEvent{
        ClusterId: clusterId,
        FailedOperators: failedOperators,
    }
}

func SendClusterDegradedFailedOLMOperatorsEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    failedOperators string,) {
    ev := NewClusterDegradedFailedOLMOperatorsEvent(
        clusterId,
        failedOperators,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterDegradedFailedOLMOperatorsEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    failedOperators string,
    eventTime time.Time) {
    ev := NewClusterDegradedFailedOLMOperatorsEvent(
        clusterId,
        failedOperators,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterDegradedFailedOLMOperatorsEvent) GetName() string {
    return "cluster_degraded_failed_OLM_operators"
}

func (e *ClusterDegradedFailedOLMOperatorsEvent) GetSeverity() string {
    return "warning"
}
func (e *ClusterDegradedFailedOLMOperatorsEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterDegradedFailedOLMOperatorsEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{failed_operators}", fmt.Sprint(e.FailedOperators),
    )
    return r.Replace(*message)
}

func (e *ClusterDegradedFailedOLMOperatorsEvent) FormatMessage() string {
    s := "Cluster is installed but degraded due to failed OLM operators {failed_operators}"
    return e.format(&s)
}

//
// Event delete_expired_image
//
type DeleteExpiredImageEvent struct {
    ClusterId strfmt.UUID
}

var DeleteExpiredImageEventName string = "delete_expired_image"

func NewDeleteExpiredImageEvent(
    clusterId strfmt.UUID,
) *DeleteExpiredImageEvent {
    return &DeleteExpiredImageEvent{
        ClusterId: clusterId,
    }
}

func SendDeleteExpiredImageEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,) {
    ev := NewDeleteExpiredImageEvent(
        clusterId,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendDeleteExpiredImageEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    eventTime time.Time) {
    ev := NewDeleteExpiredImageEvent(
        clusterId,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *DeleteExpiredImageEvent) GetName() string {
    return "delete_expired_image"
}

func (e *DeleteExpiredImageEvent) GetSeverity() string {
    return "info"
}
func (e *DeleteExpiredImageEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *DeleteExpiredImageEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
    )
    return r.Replace(*message)
}

func (e *DeleteExpiredImageEvent) FormatMessage() string {
    s := "Deleted image from backend because it expired. It may be generated again at any time"
    return e.format(&s)
}

//
// Event cluster_operator_status
//
type ClusterOperatorStatusEvent struct {
    ClusterId strfmt.UUID
    OperatorName string
    Status string
    StatusInfo string
}

var ClusterOperatorStatusEventName string = "cluster_operator_status"

func NewClusterOperatorStatusEvent(
    clusterId strfmt.UUID,
    operatorName string,
    status string,
    statusInfo string,
) *ClusterOperatorStatusEvent {
    return &ClusterOperatorStatusEvent{
        ClusterId: clusterId,
        OperatorName: operatorName,
        Status: status,
        StatusInfo: statusInfo,
    }
}

func SendClusterOperatorStatusEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    operatorName string,
    status string,
    statusInfo string,) {
    ev := NewClusterOperatorStatusEvent(
        clusterId,
        operatorName,
        status,
        statusInfo,
    )
    eventsHandler.SendClusterEvent(ctx, ev)
}

func SendClusterOperatorStatusEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId strfmt.UUID,
    operatorName string,
    status string,
    statusInfo string,
    eventTime time.Time) {
    ev := NewClusterOperatorStatusEvent(
        clusterId,
        operatorName,
        status,
        statusInfo,
    )
    eventsHandler.SendClusterEventAtTime(ctx, ev, eventTime)
}

func (e *ClusterOperatorStatusEvent) GetName() string {
    return "cluster_operator_status"
}

func (e *ClusterOperatorStatusEvent) GetSeverity() string {
    return "info"
}
func (e *ClusterOperatorStatusEvent) GetClusterId() strfmt.UUID {
    return e.ClusterId
}

func (e *ClusterOperatorStatusEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{operator_name}", fmt.Sprint(e.OperatorName),
        "{status}", fmt.Sprint(e.Status),
        "{status_info}", fmt.Sprint(e.StatusInfo),
    )
    return r.Replace(*message)
}

func (e *ClusterOperatorStatusEvent) FormatMessage() string {
    s := "Operator {operator_name} status: {status} message: {status_info}"
    return e.format(&s)
}

//
// Event download_image_failed_fetch
//
type DownloadImageFailedFetchEvent struct {
    InfraEnvId strfmt.UUID
}

var DownloadImageFailedFetchEventName string = "download_image_failed_fetch"

func NewDownloadImageFailedFetchEvent(
    infraEnvId strfmt.UUID,
) *DownloadImageFailedFetchEvent {
    return &DownloadImageFailedFetchEvent{
        InfraEnvId: infraEnvId,
    }
}

func SendDownloadImageFailedFetchEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,) {
    ev := NewDownloadImageFailedFetchEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEvent(ctx, ev)
}

func SendDownloadImageFailedFetchEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    eventTime time.Time) {
    ev := NewDownloadImageFailedFetchEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEventAtTime(ctx, ev, eventTime)
}

func (e *DownloadImageFailedFetchEvent) GetName() string {
    return "download_image_failed_fetch"
}

func (e *DownloadImageFailedFetchEvent) GetSeverity() string {
    return "error"
}
func (e *DownloadImageFailedFetchEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *DownloadImageFailedFetchEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *DownloadImageFailedFetchEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
    )
    return r.Replace(*message)
}

func (e *DownloadImageFailedFetchEvent) FormatMessage() string {
    s := "Failed to download image: error fetching from storage backend"
    return e.format(&s)
}

//
// Event host_deregistered_cluster
//
type HostDeregisteredClusterEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
}

var HostDeregisteredClusterEventName string = "host_deregistered_cluster"

func NewHostDeregisteredClusterEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
) *HostDeregisteredClusterEvent {
    return &HostDeregisteredClusterEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
    }
}

func SendHostDeregisteredClusterEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,) {
    ev := NewHostDeregisteredClusterEvent(
        clusterId,
        hostId,
        infraEnvId,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostDeregisteredClusterEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    eventTime time.Time) {
    ev := NewHostDeregisteredClusterEvent(
        clusterId,
        hostId,
        infraEnvId,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostDeregisteredClusterEvent) GetName() string {
    return "host_deregistered_cluster"
}

func (e *HostDeregisteredClusterEvent) GetSeverity() string {
    return "info"
}
func (e *HostDeregisteredClusterEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostDeregisteredClusterEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostDeregisteredClusterEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostDeregisteredClusterEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
    )
    return r.Replace(*message)
}

func (e *HostDeregisteredClusterEvent) FormatMessage() string {
    s := "Host deregistered from cluster"
    return e.format(&s)
}

//
// Event host_installer_args_applied
//
type HostInstallerArgsAppliedEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
}

var HostInstallerArgsAppliedEventName string = "host_installer_args_applied"

func NewHostInstallerArgsAppliedEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
) *HostInstallerArgsAppliedEvent {
    return &HostInstallerArgsAppliedEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
    }
}

func SendHostInstallerArgsAppliedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,) {
    ev := NewHostInstallerArgsAppliedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostInstallerArgsAppliedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    eventTime time.Time) {
    ev := NewHostInstallerArgsAppliedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostInstallerArgsAppliedEvent) GetName() string {
    return "host_installer_args_applied"
}

func (e *HostInstallerArgsAppliedEvent) GetSeverity() string {
    return "info"
}
func (e *HostInstallerArgsAppliedEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostInstallerArgsAppliedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostInstallerArgsAppliedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostInstallerArgsAppliedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
    )
    return r.Replace(*message)
}

func (e *HostInstallerArgsAppliedEvent) FormatMessage() string {
    s := "Host {host_name}: custom installer arguments were applied"
    return e.format(&s)
}

//
// Event host_set_bootstrap
//
type HostSetBootstrapEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
}

var HostSetBootstrapEventName string = "host_set_bootstrap"

func NewHostSetBootstrapEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
) *HostSetBootstrapEvent {
    return &HostSetBootstrapEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
    }
}

func SendHostSetBootstrapEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,) {
    ev := NewHostSetBootstrapEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostSetBootstrapEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    eventTime time.Time) {
    ev := NewHostSetBootstrapEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostSetBootstrapEvent) GetName() string {
    return "host_set_bootstrap"
}

func (e *HostSetBootstrapEvent) GetSeverity() string {
    return "info"
}
func (e *HostSetBootstrapEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostSetBootstrapEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostSetBootstrapEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostSetBootstrapEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
    )
    return r.Replace(*message)
}

func (e *HostSetBootstrapEvent) FormatMessage() string {
    s := "Host {host_name}: set as bootstrap"
    return e.format(&s)
}

//
// Event host_status_updated
//
type HostStatusUpdatedEvent struct {
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    Severity string
    HostName string
    SrcStatus string
    NewStatus string
    Info string
}

var HostStatusUpdatedEventName string = "host_status_updated"

func NewHostStatusUpdatedEvent(
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    severity string,
    hostName string,
    srcStatus string,
    newStatus string,
    info string,
) *HostStatusUpdatedEvent {
    return &HostStatusUpdatedEvent{
        HostId: hostId,
        InfraEnvId: infraEnvId,
        Severity: severity,
        HostName: hostName,
        SrcStatus: srcStatus,
        NewStatus: newStatus,
        Info: info,
    }
}

func SendHostStatusUpdatedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    severity string,
    hostName string,
    srcStatus string,
    newStatus string,
    info string,) {
    ev := NewHostStatusUpdatedEvent(
        hostId,
        infraEnvId,
        severity,
        hostName,
        srcStatus,
        newStatus,
        info,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostStatusUpdatedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    severity string,
    hostName string,
    srcStatus string,
    newStatus string,
    info string,
    eventTime time.Time) {
    ev := NewHostStatusUpdatedEvent(
        hostId,
        infraEnvId,
        severity,
        hostName,
        srcStatus,
        newStatus,
        info,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostStatusUpdatedEvent) GetName() string {
    return "host_status_updated"
}

func (e *HostStatusUpdatedEvent) GetSeverity() string {
    return e.Severity
}
func (e *HostStatusUpdatedEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *HostStatusUpdatedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostStatusUpdatedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostStatusUpdatedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{severity}", fmt.Sprint(e.Severity),
        "{host_name}", fmt.Sprint(e.HostName),
        "{src_status}", fmt.Sprint(e.SrcStatus),
        "{new_status}", fmt.Sprint(e.NewStatus),
        "{info}", fmt.Sprint(e.Info),
    )
    return r.Replace(*message)
}

func (e *HostStatusUpdatedEvent) FormatMessage() string {
    s := "Host {host_name}: updated status from {src_status} to {new_status} {info}"
    return e.format(&s)
}

//
// Event update_image_status
//
type UpdateImageStatusEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    ImageStatus string
    Result string
    Info string
}

var UpdateImageStatusEventName string = "update_image_status"

func NewUpdateImageStatusEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    imageStatus string,
    result string,
    info string,
) *UpdateImageStatusEvent {
    return &UpdateImageStatusEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        ImageStatus: imageStatus,
        Result: result,
        Info: info,
    }
}

func SendUpdateImageStatusEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    imageStatus string,
    result string,
    info string,) {
    ev := NewUpdateImageStatusEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        imageStatus,
        result,
        info,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendUpdateImageStatusEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    imageStatus string,
    result string,
    info string,
    eventTime time.Time) {
    ev := NewUpdateImageStatusEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        imageStatus,
        result,
        info,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *UpdateImageStatusEvent) GetName() string {
    return "update_image_status"
}

func (e *UpdateImageStatusEvent) GetSeverity() string {
    return "info"
}
func (e *UpdateImageStatusEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *UpdateImageStatusEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *UpdateImageStatusEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *UpdateImageStatusEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{image_status}", fmt.Sprint(e.ImageStatus),
        "{result}", fmt.Sprint(e.Result),
        "{info}", fmt.Sprint(e.Info),
    )
    return r.Replace(*message)
}

func (e *UpdateImageStatusEvent) FormatMessage() string {
    s := "Host {host_name}: New image status {image_status}. result: {result}. {info}"
    return e.format(&s)
}

//
// Event host_installation_cancelled
//
type HostInstallationCancelledEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
}

var HostInstallationCancelledEventName string = "host_installation_cancelled"

func NewHostInstallationCancelledEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
) *HostInstallationCancelledEvent {
    return &HostInstallationCancelledEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
    }
}

func SendHostInstallationCancelledEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,) {
    ev := NewHostInstallationCancelledEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostInstallationCancelledEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    eventTime time.Time) {
    ev := NewHostInstallationCancelledEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostInstallationCancelledEvent) GetName() string {
    return "host_installation_cancelled"
}

func (e *HostInstallationCancelledEvent) GetSeverity() string {
    return "info"
}
func (e *HostInstallationCancelledEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostInstallationCancelledEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostInstallationCancelledEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostInstallationCancelledEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
    )
    return r.Replace(*message)
}

func (e *HostInstallationCancelledEvent) FormatMessage() string {
    s := "Installation cancelled for host {host_name}"
    return e.format(&s)
}

//
// Event host_cancel_installation_failed
//
type HostCancelInstallationFailedEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    Error string
}

var HostCancelInstallationFailedEventName string = "host_cancel_installation_failed"

func NewHostCancelInstallationFailedEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
) *HostCancelInstallationFailedEvent {
    return &HostCancelInstallationFailedEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        Error: error,
    }
}

func SendHostCancelInstallationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,) {
    ev := NewHostCancelInstallationFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostCancelInstallationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
    eventTime time.Time) {
    ev := NewHostCancelInstallationFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostCancelInstallationFailedEvent) GetName() string {
    return "host_cancel_installation_failed"
}

func (e *HostCancelInstallationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *HostCancelInstallationFailedEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostCancelInstallationFailedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostCancelInstallationFailedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostCancelInstallationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *HostCancelInstallationFailedEvent) FormatMessage() string {
    s := "Failed to cancel installation of host {host_name}: {error}"
    return e.format(&s)
}

//
// Event host_reset_installation
//
type HostResetInstallationEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
}

var HostResetInstallationEventName string = "host_reset_installation"

func NewHostResetInstallationEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
) *HostResetInstallationEvent {
    return &HostResetInstallationEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
    }
}

func SendHostResetInstallationEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,) {
    ev := NewHostResetInstallationEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostResetInstallationEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    eventTime time.Time) {
    ev := NewHostResetInstallationEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostResetInstallationEvent) GetName() string {
    return "host_reset_installation"
}

func (e *HostResetInstallationEvent) GetSeverity() string {
    return "info"
}
func (e *HostResetInstallationEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostResetInstallationEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostResetInstallationEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostResetInstallationEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
    )
    return r.Replace(*message)
}

func (e *HostResetInstallationEvent) FormatMessage() string {
    s := "Installation reset for host {host_name}"
    return e.format(&s)
}

//
// Event host_reset_installation_failed
//
type HostResetInstallationFailedEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    Error string
}

var HostResetInstallationFailedEventName string = "host_reset_installation_failed"

func NewHostResetInstallationFailedEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
) *HostResetInstallationFailedEvent {
    return &HostResetInstallationFailedEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        Error: error,
    }
}

func SendHostResetInstallationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,) {
    ev := NewHostResetInstallationFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostResetInstallationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
    eventTime time.Time) {
    ev := NewHostResetInstallationFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostResetInstallationFailedEvent) GetName() string {
    return "host_reset_installation_failed"
}

func (e *HostResetInstallationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *HostResetInstallationFailedEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostResetInstallationFailedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostResetInstallationFailedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostResetInstallationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *HostResetInstallationFailedEvent) FormatMessage() string {
    s := "Failed to reset installation of host {host_name}. Error: {error}"
    return e.format(&s)
}

//
// Event user_required_complete_installation_reset
//
type UserRequiredCompleteInstallationResetEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
}

var UserRequiredCompleteInstallationResetEventName string = "user_required_complete_installation_reset"

func NewUserRequiredCompleteInstallationResetEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
) *UserRequiredCompleteInstallationResetEvent {
    return &UserRequiredCompleteInstallationResetEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
    }
}

func SendUserRequiredCompleteInstallationResetEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,) {
    ev := NewUserRequiredCompleteInstallationResetEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendUserRequiredCompleteInstallationResetEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    eventTime time.Time) {
    ev := NewUserRequiredCompleteInstallationResetEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *UserRequiredCompleteInstallationResetEvent) GetName() string {
    return "user_required_complete_installation_reset"
}

func (e *UserRequiredCompleteInstallationResetEvent) GetSeverity() string {
    return "info"
}
func (e *UserRequiredCompleteInstallationResetEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *UserRequiredCompleteInstallationResetEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *UserRequiredCompleteInstallationResetEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *UserRequiredCompleteInstallationResetEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
    )
    return r.Replace(*message)
}

func (e *UserRequiredCompleteInstallationResetEvent) FormatMessage() string {
    s := "User action is required in order to complete installation reset for host {host_name}"
    return e.format(&s)
}

//
// Event host_set_status_failed
//
type HostSetStatusFailedEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    Error string
}

var HostSetStatusFailedEventName string = "host_set_status_failed"

func NewHostSetStatusFailedEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
) *HostSetStatusFailedEvent {
    return &HostSetStatusFailedEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        Error: error,
    }
}

func SendHostSetStatusFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,) {
    ev := NewHostSetStatusFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostSetStatusFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    error string,
    eventTime time.Time) {
    ev := NewHostSetStatusFailedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        error,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostSetStatusFailedEvent) GetName() string {
    return "host_set_status_failed"
}

func (e *HostSetStatusFailedEvent) GetSeverity() string {
    return "error"
}
func (e *HostSetStatusFailedEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostSetStatusFailedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostSetStatusFailedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostSetStatusFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *HostSetStatusFailedEvent) FormatMessage() string {
    s := "Failed to set status of host {host_name} to reset-pending-user-action. Error: {error}"
    return e.format(&s)
}

//
// Event host_validation_falling
//
type HostValidationFallingEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    ValidationId string
}

var HostValidationFallingEventName string = "host_validation_falling"

func NewHostValidationFallingEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,
) *HostValidationFallingEvent {
    return &HostValidationFallingEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        ValidationId: validationId,
    }
}

func SendHostValidationFallingEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,) {
    ev := NewHostValidationFallingEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        validationId,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostValidationFallingEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,
    eventTime time.Time) {
    ev := NewHostValidationFallingEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        validationId,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostValidationFallingEvent) GetName() string {
    return "host_validation_falling"
}

func (e *HostValidationFallingEvent) GetSeverity() string {
    return "warning"
}
func (e *HostValidationFallingEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostValidationFallingEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostValidationFallingEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostValidationFallingEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{validation_id}", fmt.Sprint(e.ValidationId),
    )
    return r.Replace(*message)
}

func (e *HostValidationFallingEvent) FormatMessage() string {
    s := "Host {host_name}: validation '{validation_id}' that used to succeed is now failing"
    return e.format(&s)
}

//
// Event host_validation_fixed
//
type HostValidationFixedEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    ValidationId string
}

var HostValidationFixedEventName string = "host_validation_fixed"

func NewHostValidationFixedEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,
) *HostValidationFixedEvent {
    return &HostValidationFixedEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        ValidationId: validationId,
    }
}

func SendHostValidationFixedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,) {
    ev := NewHostValidationFixedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        validationId,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendHostValidationFixedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    validationId string,
    eventTime time.Time) {
    ev := NewHostValidationFixedEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        validationId,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *HostValidationFixedEvent) GetName() string {
    return "host_validation_fixed"
}

func (e *HostValidationFixedEvent) GetSeverity() string {
    return "info"
}
func (e *HostValidationFixedEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *HostValidationFixedEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *HostValidationFixedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *HostValidationFixedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{validation_id}", fmt.Sprint(e.ValidationId),
    )
    return r.Replace(*message)
}

func (e *HostValidationFixedEvent) FormatMessage() string {
    s := "Host {host_name}: validation '{validation_id}' is now fixed"
    return e.format(&s)
}

//
// Event quick_disk_format
//
type QuickDiskFormatEvent struct {
    ClusterId *strfmt.UUID
    HostId strfmt.UUID
    InfraEnvId strfmt.UUID
    HostName string
    DiskName string
    DiskId string
}

var QuickDiskFormatEventName string = "quick_disk_format"

func NewQuickDiskFormatEvent(
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    diskName string,
    diskId string,
) *QuickDiskFormatEvent {
    return &QuickDiskFormatEvent{
        ClusterId: clusterId,
        HostId: hostId,
        InfraEnvId: infraEnvId,
        HostName: hostName,
        DiskName: diskName,
        DiskId: diskId,
    }
}

func SendQuickDiskFormatEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    diskName string,
    diskId string,) {
    ev := NewQuickDiskFormatEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        diskName,
        diskId,
    )
    eventsHandler.SendHostEvent(ctx, ev)
}

func SendQuickDiskFormatEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    clusterId *strfmt.UUID,
    hostId strfmt.UUID,
    infraEnvId strfmt.UUID,
    hostName string,
    diskName string,
    diskId string,
    eventTime time.Time) {
    ev := NewQuickDiskFormatEvent(
        clusterId,
        hostId,
        infraEnvId,
        hostName,
        diskName,
        diskId,
    )
    eventsHandler.SendHostEventAtTime(ctx, ev, eventTime)
}

func (e *QuickDiskFormatEvent) GetName() string {
    return "quick_disk_format"
}

func (e *QuickDiskFormatEvent) GetSeverity() string {
    return "info"
}
func (e *QuickDiskFormatEvent) GetClusterId() *strfmt.UUID {
    return e.ClusterId
}
func (e *QuickDiskFormatEvent) GetHostId() strfmt.UUID {
    return e.HostId
}
func (e *QuickDiskFormatEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *QuickDiskFormatEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{cluster_id}", fmt.Sprint(e.ClusterId),
        "{host_id}", fmt.Sprint(e.HostId),
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{host_name}", fmt.Sprint(e.HostName),
        "{disk_name}", fmt.Sprint(e.DiskName),
        "{disk_id}", fmt.Sprint(e.DiskId),
    )
    return r.Replace(*message)
}

func (e *QuickDiskFormatEvent) FormatMessage() string {
    s := "{host_name}: Performing quick format of disk {disk_name}({disk_id})"
    return e.format(&s)
}

//
// Event infra_env_registration_failed
//
type InfraEnvRegistrationFailedEvent struct {
    InfraEnvId strfmt.UUID
    Error string
}

var InfraEnvRegistrationFailedEventName string = "infra_env_registration_failed"

func NewInfraEnvRegistrationFailedEvent(
    infraEnvId strfmt.UUID,
    error string,
) *InfraEnvRegistrationFailedEvent {
    return &InfraEnvRegistrationFailedEvent{
        InfraEnvId: infraEnvId,
        Error: error,
    }
}

func SendInfraEnvRegistrationFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    error string,) {
    ev := NewInfraEnvRegistrationFailedEvent(
        infraEnvId,
        error,
    )
    eventsHandler.SendInfraEnvEvent(ctx, ev)
}

func SendInfraEnvRegistrationFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewInfraEnvRegistrationFailedEvent(
        infraEnvId,
        error,
    )
    eventsHandler.SendInfraEnvEventAtTime(ctx, ev, eventTime)
}

func (e *InfraEnvRegistrationFailedEvent) GetName() string {
    return "infra_env_registration_failed"
}

func (e *InfraEnvRegistrationFailedEvent) GetSeverity() string {
    return "error"
}
func (e *InfraEnvRegistrationFailedEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *InfraEnvRegistrationFailedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *InfraEnvRegistrationFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *InfraEnvRegistrationFailedEvent) FormatMessage() string {
    s := "Failed to register infra env. Error: {error}"
    return e.format(&s)
}

//
// Event registered_infra_env
//
type RegisteredInfraEnvEvent struct {
    InfraEnvId strfmt.UUID
}

var RegisteredInfraEnvEventName string = "registered_infra_env"

func NewRegisteredInfraEnvEvent(
    infraEnvId strfmt.UUID,
) *RegisteredInfraEnvEvent {
    return &RegisteredInfraEnvEvent{
        InfraEnvId: infraEnvId,
    }
}

func SendRegisteredInfraEnvEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,) {
    ev := NewRegisteredInfraEnvEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEvent(ctx, ev)
}

func SendRegisteredInfraEnvEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    eventTime time.Time) {
    ev := NewRegisteredInfraEnvEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEventAtTime(ctx, ev, eventTime)
}

func (e *RegisteredInfraEnvEvent) GetName() string {
    return "registered_infra_env"
}

func (e *RegisteredInfraEnvEvent) GetSeverity() string {
    return "info"
}
func (e *RegisteredInfraEnvEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *RegisteredInfraEnvEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *RegisteredInfraEnvEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
    )
    return r.Replace(*message)
}

func (e *RegisteredInfraEnvEvent) FormatMessage() string {
    s := "Registered infra env"
    return e.format(&s)
}

//
// Event infra_env_deregister_failed
//
type InfraEnvDeregisterFailedEvent struct {
    InfraEnvId strfmt.UUID
    Error string
}

var InfraEnvDeregisterFailedEventName string = "infra_env_deregister_failed"

func NewInfraEnvDeregisterFailedEvent(
    infraEnvId strfmt.UUID,
    error string,
) *InfraEnvDeregisterFailedEvent {
    return &InfraEnvDeregisterFailedEvent{
        InfraEnvId: infraEnvId,
        Error: error,
    }
}

func SendInfraEnvDeregisterFailedEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    error string,) {
    ev := NewInfraEnvDeregisterFailedEvent(
        infraEnvId,
        error,
    )
    eventsHandler.SendInfraEnvEvent(ctx, ev)
}

func SendInfraEnvDeregisterFailedEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    error string,
    eventTime time.Time) {
    ev := NewInfraEnvDeregisterFailedEvent(
        infraEnvId,
        error,
    )
    eventsHandler.SendInfraEnvEventAtTime(ctx, ev, eventTime)
}

func (e *InfraEnvDeregisterFailedEvent) GetName() string {
    return "infra_env_deregister_failed"
}

func (e *InfraEnvDeregisterFailedEvent) GetSeverity() string {
    return "error"
}
func (e *InfraEnvDeregisterFailedEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *InfraEnvDeregisterFailedEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *InfraEnvDeregisterFailedEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
        "{error}", fmt.Sprint(e.Error),
    )
    return r.Replace(*message)
}

func (e *InfraEnvDeregisterFailedEvent) FormatMessage() string {
    s := "Failed to deregister infra env. Error: {error}"
    return e.format(&s)
}

//
// Event deregistered_infra_env
//
type DeregisteredInfraEnvEvent struct {
    InfraEnvId strfmt.UUID
}

var DeregisteredInfraEnvEventName string = "deregistered_infra_env"

func NewDeregisteredInfraEnvEvent(
    infraEnvId strfmt.UUID,
) *DeregisteredInfraEnvEvent {
    return &DeregisteredInfraEnvEvent{
        InfraEnvId: infraEnvId,
    }
}

func SendDeregisteredInfraEnvEvent(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,) {
    ev := NewDeregisteredInfraEnvEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEvent(ctx, ev)
}

func SendDeregisteredInfraEnvEventAtTime(
    ctx context.Context,
    eventsHandler events.Sender,
    infraEnvId strfmt.UUID,
    eventTime time.Time) {
    ev := NewDeregisteredInfraEnvEvent(
        infraEnvId,
    )
    eventsHandler.SendInfraEnvEventAtTime(ctx, ev, eventTime)
}

func (e *DeregisteredInfraEnvEvent) GetName() string {
    return "deregistered_infra_env"
}

func (e *DeregisteredInfraEnvEvent) GetSeverity() string {
    return "info"
}
func (e *DeregisteredInfraEnvEvent) GetClusterId() *strfmt.UUID {
    return nil
}
func (e *DeregisteredInfraEnvEvent) GetInfraEnvId() strfmt.UUID {
    return e.InfraEnvId
}

func (e *DeregisteredInfraEnvEvent) format(message *string) string {
    r := strings.NewReplacer(
        "{infra_env_id}", fmt.Sprint(e.InfraEnvId),
    )
    return r.Replace(*message)
}

func (e *DeregisteredInfraEnvEvent) FormatMessage() string {
    s := "Deregistered infra env"
    return e.format(&s)
}

