// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DiskEncryption disk encryption
//
// swagger:model disk-encryption
type DiskEncryption struct {

	// Enable/disable disk encryption on master nodes, worker nodes, or all nodes.
	// Enum: [none all masters workers]
	EnableOn *string `json:"enable_on,omitempty"`

	// The disk encryption mode to use.
	// Enum: [tpmv2 tang]
	Mode *string `json:"mode,omitempty"`

	// JSON-formatted string containing additional information regarding tang's configuration
	TangServers string `json:"tang_servers,omitempty" gorm:"type:text"`
}

// Validate validates this disk encryption
func (m *DiskEncryption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnableOn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var diskEncryptionTypeEnableOnPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","all","masters","workers"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskEncryptionTypeEnableOnPropEnum = append(diskEncryptionTypeEnableOnPropEnum, v)
	}
}

const (

	// DiskEncryptionEnableOnNone captures enum value "none"
	DiskEncryptionEnableOnNone string = "none"

	// DiskEncryptionEnableOnAll captures enum value "all"
	DiskEncryptionEnableOnAll string = "all"

	// DiskEncryptionEnableOnMasters captures enum value "masters"
	DiskEncryptionEnableOnMasters string = "masters"

	// DiskEncryptionEnableOnWorkers captures enum value "workers"
	DiskEncryptionEnableOnWorkers string = "workers"
)

// prop value enum
func (m *DiskEncryption) validateEnableOnEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskEncryptionTypeEnableOnPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DiskEncryption) validateEnableOn(formats strfmt.Registry) error {

	if swag.IsZero(m.EnableOn) { // not required
		return nil
	}

	// value enum
	if err := m.validateEnableOnEnum("enable_on", "body", *m.EnableOn); err != nil {
		return err
	}

	return nil
}

var diskEncryptionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tpmv2","tang"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskEncryptionTypeModePropEnum = append(diskEncryptionTypeModePropEnum, v)
	}
}

const (

	// DiskEncryptionModeTpmv2 captures enum value "tpmv2"
	DiskEncryptionModeTpmv2 string = "tpmv2"

	// DiskEncryptionModeTang captures enum value "tang"
	DiskEncryptionModeTang string = "tang"
)

// prop value enum
func (m *DiskEncryption) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskEncryptionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DiskEncryption) validateMode(formats strfmt.Registry) error {

	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskEncryption) UnmarshalBinary(b []byte) error {
	var res DiskEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
