// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostUpdateParams host update params
//
// swagger:model host-update-params
type HostUpdateParams struct {

	// disks selected config
	DisksSelectedConfig []*DiskConfigParams `json:"disks_selected_config"`

	// host name
	HostName *string `json:"host_name,omitempty"`

	// host role
	// Enum: [auto-assign master worker]
	HostRole *string `json:"host_role,omitempty"`

	// machine config pool name
	MachineConfigPoolName *string `json:"machine_config_pool_name,omitempty"`
}

// Validate validates this host update params
func (m *HostUpdateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisksSelectedConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostUpdateParams) validateDisksSelectedConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.DisksSelectedConfig) { // not required
		return nil
	}

	for i := 0; i < len(m.DisksSelectedConfig); i++ {
		if swag.IsZero(m.DisksSelectedConfig[i]) { // not required
			continue
		}

		if m.DisksSelectedConfig[i] != nil {
			if err := m.DisksSelectedConfig[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("disks_selected_config" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var hostUpdateParamsTypeHostRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto-assign","master","worker"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hostUpdateParamsTypeHostRolePropEnum = append(hostUpdateParamsTypeHostRolePropEnum, v)
	}
}

const (

	// HostUpdateParamsHostRoleAutoAssign captures enum value "auto-assign"
	HostUpdateParamsHostRoleAutoAssign string = "auto-assign"

	// HostUpdateParamsHostRoleMaster captures enum value "master"
	HostUpdateParamsHostRoleMaster string = "master"

	// HostUpdateParamsHostRoleWorker captures enum value "worker"
	HostUpdateParamsHostRoleWorker string = "worker"
)

// prop value enum
func (m *HostUpdateParams) validateHostRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hostUpdateParamsTypeHostRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HostUpdateParams) validateHostRole(formats strfmt.Registry) error {

	if swag.IsZero(m.HostRole) { // not required
		return nil
	}

	// value enum
	if err := m.validateHostRoleEnum("host_role", "body", *m.HostRole); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostUpdateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostUpdateParams) UnmarshalBinary(b []byte) error {
	var res HostUpdateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
