// Code generated by go-swagger; DO NOT EDIT.

package restapi

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/loads"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/runtime/security"

	"github.com/openshift/assisted-service/restapi/operations"
	"github.com/openshift/assisted-service/restapi/operations/assisted_service_iso"
	"github.com/openshift/assisted-service/restapi/operations/events"
	"github.com/openshift/assisted-service/restapi/operations/installer"
	"github.com/openshift/assisted-service/restapi/operations/managed_domains"
	"github.com/openshift/assisted-service/restapi/operations/manifests"
	"github.com/openshift/assisted-service/restapi/operations/operators"
	"github.com/openshift/assisted-service/restapi/operations/versions"
)

type contextKey string

const AuthKey contextKey = "Auth"

//go:generate mockery -name AssistedServiceIsoAPI -inpkg

/* AssistedServiceIsoAPI  */
type AssistedServiceIsoAPI interface {
	/* CreateISOAndUploadToS3 Creates ISO for the user and uploads to S3. */
	CreateISOAndUploadToS3(ctx context.Context, params assisted_service_iso.CreateISOAndUploadToS3Params) middleware.Responder

	/* DownloadISO Downloads the Assisted Service ISO. */
	DownloadISO(ctx context.Context, params assisted_service_iso.DownloadISOParams) middleware.Responder

	/* GetPresignedForAssistedServiceISO Retrieves a pre-signed S3 URL for downloading assisted-service ISO. */
	GetPresignedForAssistedServiceISO(ctx context.Context, params assisted_service_iso.GetPresignedForAssistedServiceISOParams) middleware.Responder
}

//go:generate mockery -name EventsAPI -inpkg

/* EventsAPI  */
type EventsAPI interface {
	/* ListEvents Lists events for a cluster. */
	ListEvents(ctx context.Context, params events.ListEventsParams) middleware.Responder
}

//go:generate mockery -name InstallerAPI -inpkg

/* InstallerAPI  */
type InstallerAPI interface {
	/* BindHost Bind host to a cluster */
	BindHost(ctx context.Context, params installer.BindHostParams) middleware.Responder

	/* CancelInstallation Cancels an ongoing installation. */
	CancelInstallation(ctx context.Context, params installer.CancelInstallationParams) middleware.Responder

	/* CompleteInstallation Agent API to mark a finalizing installation as complete. */
	CompleteInstallation(ctx context.Context, params installer.CompleteInstallationParams) middleware.Responder

	/* DeregisterCluster Deletes an OpenShift cluster definition. */
	DeregisterCluster(ctx context.Context, params installer.DeregisterClusterParams) middleware.Responder

	/* DeregisterHost Deregisters an OpenShift host. */
	DeregisterHost(ctx context.Context, params installer.DeregisterHostParams) middleware.Responder

	/* DeregisterInfraEnv Deletes an InfraEnv. */
	DeregisterInfraEnv(ctx context.Context, params installer.DeregisterInfraEnvParams) middleware.Responder

	/* DisableHost Disables a host for inclusion in the cluster. */
	DisableHost(ctx context.Context, params installer.DisableHostParams) middleware.Responder

	/* DownloadClusterFiles Downloads files relating to the installed/installing cluster. */
	DownloadClusterFiles(ctx context.Context, params installer.DownloadClusterFilesParams) middleware.Responder

	/* DownloadClusterISO Downloads the OpenShift per-cluster Discovery ISO. */
	DownloadClusterISO(ctx context.Context, params installer.DownloadClusterISOParams) middleware.Responder

	/* DownloadClusterISOHeaders Downloads the OpenShift per-cluster Discovery ISO Headers only. */
	DownloadClusterISOHeaders(ctx context.Context, params installer.DownloadClusterISOHeadersParams) middleware.Responder

	/* DownloadClusterKubeconfig Downloads the kubeconfig file for this cluster. */
	DownloadClusterKubeconfig(ctx context.Context, params installer.DownloadClusterKubeconfigParams) middleware.Responder

	/* DownloadClusterLogs Download cluster logs. */
	DownloadClusterLogs(ctx context.Context, params installer.DownloadClusterLogsParams) middleware.Responder

	/* DownloadHostIgnition Downloads the customized ignition file for this host, produces octet string */
	DownloadHostIgnition(ctx context.Context, params installer.DownloadHostIgnitionParams) middleware.Responder

	/* DownloadHostLogs Download host logs. */
	DownloadHostLogs(ctx context.Context, params installer.DownloadHostLogsParams) middleware.Responder

	/* DownloadInfraEnvDiscoveryImage Downloads the discovery image. */
	DownloadInfraEnvDiscoveryImage(ctx context.Context, params installer.DownloadInfraEnvDiscoveryImageParams) middleware.Responder

	/* DownloadInfraEnvDiscoveryImageHeaders Downloads the discovery image Headers only. */
	DownloadInfraEnvDiscoveryImageHeaders(ctx context.Context, params installer.DownloadInfraEnvDiscoveryImageHeadersParams) middleware.Responder

	/* DownloadMinimalInitrd Get the initial ramdisk for minimal ISO based installations.
	 */
	DownloadMinimalInitrd(ctx context.Context, params installer.DownloadMinimalInitrdParams) middleware.Responder

	/* EnableHost Enables a host for inclusion in the cluster. */
	EnableHost(ctx context.Context, params installer.EnableHostParams) middleware.Responder

	/* GenerateClusterISO Creates a new OpenShift per-cluster Discovery ISO. */
	GenerateClusterISO(ctx context.Context, params installer.GenerateClusterISOParams) middleware.Responder

	/* GetCluster Retrieves the details of the OpenShift cluster. */
	GetCluster(ctx context.Context, params installer.GetClusterParams) middleware.Responder

	/* GetClusterDefaultConfig Get the default values for various cluster properties. */
	GetClusterDefaultConfig(ctx context.Context, params installer.GetClusterDefaultConfigParams) middleware.Responder

	/* GetClusterHostRequirements Get host requirements of a cluster. */
	GetClusterHostRequirements(ctx context.Context, params installer.GetClusterHostRequirementsParams) middleware.Responder

	/* GetClusterInstallConfig Get the cluster's install config YAML. */
	GetClusterInstallConfig(ctx context.Context, params installer.GetClusterInstallConfigParams) middleware.Responder

	/* GetClusterSupportedPlatforms A list of platforms that this cluster can support in its current configuration. */
	GetClusterSupportedPlatforms(ctx context.Context, params installer.GetClusterSupportedPlatformsParams) middleware.Responder

	/* GetCredentials Get the cluster admin credentials. */
	GetCredentials(ctx context.Context, params installer.GetCredentialsParams) middleware.Responder

	/* GetDiscoveryIgnition Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO.
	   Used to test the validity of the discovery ignition when it is being overridden.
	   For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign
	*/
	GetDiscoveryIgnition(ctx context.Context, params installer.GetDiscoveryIgnitionParams) middleware.Responder

	/* GetFreeAddresses Retrieves the free address list for a network. */
	GetFreeAddresses(ctx context.Context, params installer.GetFreeAddressesParams) middleware.Responder

	/* GetHost Retrieves the details of the OpenShift host. */
	GetHost(ctx context.Context, params installer.GetHostParams) middleware.Responder

	/* GetHostIgnition Get the customized ignition file for this host as a string */
	GetHostIgnition(ctx context.Context, params installer.GetHostIgnitionParams) middleware.Responder

	/* GetInfraEnv Retrieves the details of the InfraEnv. */
	GetInfraEnv(ctx context.Context, params installer.GetInfraEnvParams) middleware.Responder

	/* GetPreflightRequirements Get preflight requirements for a cluster. */
	GetPreflightRequirements(ctx context.Context, params installer.GetPreflightRequirementsParams) middleware.Responder

	/* GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files. */
	GetPresignedForClusterFiles(ctx context.Context, params installer.GetPresignedForClusterFilesParams) middleware.Responder

	/* InstallCluster Installs the OpenShift cluster. */
	InstallCluster(ctx context.Context, params installer.InstallClusterParams) middleware.Responder

	/* InstallHost install specific host for day2 cluster. */
	InstallHost(ctx context.Context, params installer.InstallHostParams) middleware.Responder

	/* InstallHosts Installs the OpenShift cluster. */
	InstallHosts(ctx context.Context, params installer.InstallHostsParams) middleware.Responder

	/* ListClusters Retrieves the list of OpenShift clusters. */
	ListClusters(ctx context.Context, params installer.ListClustersParams) middleware.Responder

	/* ListHosts Retrieves the list of OpenShift hosts. */
	ListHosts(ctx context.Context, params installer.ListHostsParams) middleware.Responder

	/* ListInfraEnvs Retrieves the list of InfraEnvs. */
	ListInfraEnvs(ctx context.Context, params installer.ListInfraEnvsParams) middleware.Responder

	/* RegisterAddHostsCluster Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster. */
	RegisterAddHostsCluster(ctx context.Context, params installer.RegisterAddHostsClusterParams) middleware.Responder

	/* RegisterCluster Creates a new OpenShift cluster definition. */
	RegisterCluster(ctx context.Context, params installer.RegisterClusterParams) middleware.Responder

	/* RegisterInfraEnv Creates a new OpenShift Discovery ISO. */
	RegisterInfraEnv(ctx context.Context, params installer.RegisterInfraEnvParams) middleware.Responder

	/* ResetCluster Resets a failed installation. */
	ResetCluster(ctx context.Context, params installer.ResetClusterParams) middleware.Responder

	/* ResetHost reset a failed host for day2 cluster. */
	ResetHost(ctx context.Context, params installer.ResetHostParams) middleware.Responder

	/* ResetHostValidation Reset failed host validation. */
	ResetHostValidation(ctx context.Context, params installer.ResetHostValidationParams) middleware.Responder

	/* UnbindHost Unbind host to a cluster */
	UnbindHost(ctx context.Context, params installer.UnbindHostParams) middleware.Responder

	/* UpdateCluster Updates an OpenShift cluster definition. */
	UpdateCluster(ctx context.Context, params installer.UpdateClusterParams) middleware.Responder

	/* UpdateClusterInstallConfig Override values in the install config. */
	UpdateClusterInstallConfig(ctx context.Context, params installer.UpdateClusterInstallConfigParams) middleware.Responder

	/* UpdateClusterLogsProgress Update log collection state and progress. */
	UpdateClusterLogsProgress(ctx context.Context, params installer.UpdateClusterLogsProgressParams) middleware.Responder

	/* UpdateDiscoveryIgnition Override values in the discovery ignition config. */
	UpdateDiscoveryIgnition(ctx context.Context, params installer.UpdateDiscoveryIgnitionParams) middleware.Responder

	/* UpdateHostIgnition Patch the ignition file for this host */
	UpdateHostIgnition(ctx context.Context, params installer.UpdateHostIgnitionParams) middleware.Responder

	/* UpdateHostInstallProgress Update installation progress. */
	UpdateHostInstallProgress(ctx context.Context, params installer.UpdateHostInstallProgressParams) middleware.Responder

	/* UpdateHostInstallerArgs Updates a host's installer arguments. */
	UpdateHostInstallerArgs(ctx context.Context, params installer.UpdateHostInstallerArgsParams) middleware.Responder

	/* UpdateHostLogsProgress Update log collection state and progress. */
	UpdateHostLogsProgress(ctx context.Context, params installer.UpdateHostLogsProgressParams) middleware.Responder

	/* UpdateInfraEnv Updates an InfraEnv. */
	UpdateInfraEnv(ctx context.Context, params installer.UpdateInfraEnvParams) middleware.Responder

	/* UploadClusterIngressCert Transfer the ingress certificate for the cluster. */
	UploadClusterIngressCert(ctx context.Context, params installer.UploadClusterIngressCertParams) middleware.Responder

	/* UploadHostLogs Agent API to upload logs. */
	UploadHostLogs(ctx context.Context, params installer.UploadHostLogsParams) middleware.Responder

	/* UploadLogs Agent API to upload logs. */
	UploadLogs(ctx context.Context, params installer.UploadLogsParams) middleware.Responder

	/* V2CancelInstallation Cancels an ongoing installation. */
	V2CancelInstallation(ctx context.Context, params installer.V2CancelInstallationParams) middleware.Responder

	/* V2DownloadClusterCredentials Downloads credentials relating to the installed/installing cluster. */
	V2DownloadClusterCredentials(ctx context.Context, params installer.V2DownloadClusterCredentialsParams) middleware.Responder

	/* V2DownloadClusterFiles Downloads files relating to the installed/installing cluster. */
	V2DownloadClusterFiles(ctx context.Context, params installer.V2DownloadClusterFilesParams) middleware.Responder

	/* V2DownloadClusterLogs Download cluster logs. */
	V2DownloadClusterLogs(ctx context.Context, params installer.V2DownloadClusterLogsParams) middleware.Responder

	/* V2GetClusterDefaultConfig Get the default values for various cluster properties. */
	V2GetClusterDefaultConfig(ctx context.Context, params installer.V2GetClusterDefaultConfigParams) middleware.Responder

	/* V2GetCredentials Get the cluster admin credentials. */
	V2GetCredentials(ctx context.Context, params installer.V2GetCredentialsParams) middleware.Responder

	/* V2GetPresignedForClusterFiles Retrieves a pre-signed S3 URL for downloading cluster files. */
	V2GetPresignedForClusterFiles(ctx context.Context, params installer.V2GetPresignedForClusterFilesParams) middleware.Responder

	/* V2UpdateCluster Updates an OpenShift cluster definition. */
	V2UpdateCluster(ctx context.Context, params installer.V2UpdateClusterParams) middleware.Responder

	/* V2UploadLogs Agent API to upload logs. */
	V2UploadLogs(ctx context.Context, params installer.V2UploadLogsParams) middleware.Responder

	/* V2CompleteInstallation Agent API to mark a finalizing installation as complete. */
	V2CompleteInstallation(ctx context.Context, params installer.V2CompleteInstallationParams) middleware.Responder

	/* V2DeregisterCluster Deletes an OpenShift cluster definition. */
	V2DeregisterCluster(ctx context.Context, params installer.V2DeregisterClusterParams) middleware.Responder

	/* V2DeregisterHost Deregisters an OpenShift host. */
	V2DeregisterHost(ctx context.Context, params installer.V2DeregisterHostParams) middleware.Responder

	/* V2DownloadHostIgnition Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned */
	V2DownloadHostIgnition(ctx context.Context, params installer.V2DownloadHostIgnitionParams) middleware.Responder

	/* V2DownloadInfraEnvFiles Downloads the customized ignition file for this host */
	V2DownloadInfraEnvFiles(ctx context.Context, params installer.V2DownloadInfraEnvFilesParams) middleware.Responder

	/* V2GetCluster Retrieves the details of the OpenShift cluster. */
	V2GetCluster(ctx context.Context, params installer.V2GetClusterParams) middleware.Responder

	/* V2GetClusterInstallConfig Get the cluster's install config YAML. */
	V2GetClusterInstallConfig(ctx context.Context, params installer.V2GetClusterInstallConfigParams) middleware.Responder

	/* V2GetHost Retrieves the details of the OpenShift host. */
	V2GetHost(ctx context.Context, params installer.V2GetHostParams) middleware.Responder

	/* V2GetHostIgnition Fetch the ignition file for this host as a string. In case of unbound host produces an error */
	V2GetHostIgnition(ctx context.Context, params installer.V2GetHostIgnitionParams) middleware.Responder

	/* V2GetNextSteps Retrieves the next operations that the host agent needs to perform. */
	V2GetNextSteps(ctx context.Context, params installer.V2GetNextStepsParams) middleware.Responder

	/* V2GetPreflightRequirements Get preflight requirements for a cluster. */
	V2GetPreflightRequirements(ctx context.Context, params installer.V2GetPreflightRequirementsParams) middleware.Responder

	/* V2InstallCluster Installs the OpenShift cluster. */
	V2InstallCluster(ctx context.Context, params installer.V2InstallClusterParams) middleware.Responder

	/* V2InstallHost install specific host for day2 cluster. */
	V2InstallHost(ctx context.Context, params installer.V2InstallHostParams) middleware.Responder

	/* V2ListClusters Retrieves the list of OpenShift clusters. */
	V2ListClusters(ctx context.Context, params installer.V2ListClustersParams) middleware.Responder

	/* V2ListHosts Retrieves the list of OpenShift hosts that belong to infra-env. */
	V2ListHosts(ctx context.Context, params installer.V2ListHostsParams) middleware.Responder

	/* V2PostStepReply Posts the result of the operations from the host agent. */
	V2PostStepReply(ctx context.Context, params installer.V2PostStepReplyParams) middleware.Responder

	/* V2RegisterCluster Creates a new OpenShift cluster definition. */
	V2RegisterCluster(ctx context.Context, params installer.V2RegisterClusterParams) middleware.Responder

	/* V2RegisterHost Registers a new OpenShift agent. */
	V2RegisterHost(ctx context.Context, params installer.V2RegisterHostParams) middleware.Responder

	/* V2ResetCluster Resets a failed installation. */
	V2ResetCluster(ctx context.Context, params installer.V2ResetClusterParams) middleware.Responder

	/* V2ResetHost reset a failed host for day2 cluster. */
	V2ResetHost(ctx context.Context, params installer.V2ResetHostParams) middleware.Responder

	/* V2ResetHostValidation Reset failed host validation. */
	V2ResetHostValidation(ctx context.Context, params installer.V2ResetHostValidationParams) middleware.Responder

	/* V2UpdateClusterInstallConfig Override values in the install config. */
	V2UpdateClusterInstallConfig(ctx context.Context, params installer.V2UpdateClusterInstallConfigParams) middleware.Responder

	/* V2UpdateClusterLogsProgress Update log collection state and progress. */
	V2UpdateClusterLogsProgress(ctx context.Context, params installer.V2UpdateClusterLogsProgressParams) middleware.Responder

	/* V2UpdateHost Update an Openshift host */
	V2UpdateHost(ctx context.Context, params installer.V2UpdateHostParams) middleware.Responder

	/* V2UpdateHostIgnition Patch the ignition file for this host */
	V2UpdateHostIgnition(ctx context.Context, params installer.V2UpdateHostIgnitionParams) middleware.Responder

	/* V2UpdateHostInstallProgress Update installation progress. */
	V2UpdateHostInstallProgress(ctx context.Context, params installer.V2UpdateHostInstallProgressParams) middleware.Responder

	/* V2UpdateHostInstallerArgs Updates a host's installer arguments. */
	V2UpdateHostInstallerArgs(ctx context.Context, params installer.V2UpdateHostInstallerArgsParams) middleware.Responder

	/* V2UpdateHostLogsProgress Update log collection state and progress. */
	V2UpdateHostLogsProgress(ctx context.Context, params installer.V2UpdateHostLogsProgressParams) middleware.Responder

	/* V2UploadClusterIngressCert Transfer the ingress certificate for the cluster. */
	V2UploadClusterIngressCert(ctx context.Context, params installer.V2UploadClusterIngressCertParams) middleware.Responder
}

//go:generate mockery -name ManagedDomainsAPI -inpkg

/* ManagedDomainsAPI  */
type ManagedDomainsAPI interface {
	/* ListManagedDomains List of managed DNS domains. */
	ListManagedDomains(ctx context.Context, params managed_domains.ListManagedDomainsParams) middleware.Responder

	/* V2ListManagedDomains List of managed DNS domains. */
	V2ListManagedDomains(ctx context.Context, params managed_domains.V2ListManagedDomainsParams) middleware.Responder
}

//go:generate mockery -name ManifestsAPI -inpkg

/* ManifestsAPI  */
type ManifestsAPI interface {
	/* CreateClusterManifest Creates a manifest for customizing cluster installation. */
	CreateClusterManifest(ctx context.Context, params manifests.CreateClusterManifestParams) middleware.Responder

	/* DeleteClusterManifest Deletes a manifest from the cluster. */
	DeleteClusterManifest(ctx context.Context, params manifests.DeleteClusterManifestParams) middleware.Responder

	/* DownloadClusterManifest Downloads cluster manifest. */
	DownloadClusterManifest(ctx context.Context, params manifests.DownloadClusterManifestParams) middleware.Responder

	/* ListClusterManifests Lists manifests for customizing cluster installation. */
	ListClusterManifests(ctx context.Context, params manifests.ListClusterManifestsParams) middleware.Responder

	/* V2CreateClusterManifest Creates a manifest for customizing cluster installation. */
	V2CreateClusterManifest(ctx context.Context, params manifests.V2CreateClusterManifestParams) middleware.Responder

	/* V2DeleteClusterManifest Deletes a manifest from the cluster. */
	V2DeleteClusterManifest(ctx context.Context, params manifests.V2DeleteClusterManifestParams) middleware.Responder

	/* V2ListClusterManifests Lists manifests for customizing cluster installation. */
	V2ListClusterManifests(ctx context.Context, params manifests.V2ListClusterManifestsParams) middleware.Responder

	/* V2DownloadClusterManifest Downloads cluster manifest. */
	V2DownloadClusterManifest(ctx context.Context, params manifests.V2DownloadClusterManifestParams) middleware.Responder
}

//go:generate mockery -name OperatorsAPI -inpkg

/* OperatorsAPI  */
type OperatorsAPI interface {
	/* ListOfClusterOperators Lists operators to be monitored for a cluster. */
	ListOfClusterOperators(ctx context.Context, params operators.ListOfClusterOperatorsParams) middleware.Responder

	/* ListOperatorProperties Lists properties for an operator. */
	ListOperatorProperties(ctx context.Context, params operators.ListOperatorPropertiesParams) middleware.Responder

	/* ListSupportedOperators Retrieves the list of supported operators. */
	ListSupportedOperators(ctx context.Context, params operators.ListSupportedOperatorsParams) middleware.Responder

	/* ReportMonitoredOperatorStatus Controller API to report of monitored operators. */
	ReportMonitoredOperatorStatus(ctx context.Context, params operators.ReportMonitoredOperatorStatusParams) middleware.Responder

	/* V2ListOfClusterOperators Lists operators to be monitored for a cluster. */
	V2ListOfClusterOperators(ctx context.Context, params operators.V2ListOfClusterOperatorsParams) middleware.Responder

	/* V2ListOperatorProperties Lists properties for an operator. */
	V2ListOperatorProperties(ctx context.Context, params operators.V2ListOperatorPropertiesParams) middleware.Responder

	/* V2ListSupportedOperators Retrieves the list of supported operators. */
	V2ListSupportedOperators(ctx context.Context, params operators.V2ListSupportedOperatorsParams) middleware.Responder

	/* V2ReportMonitoredOperatorStatus Controller API to report of monitored operators. */
	V2ReportMonitoredOperatorStatus(ctx context.Context, params operators.V2ReportMonitoredOperatorStatusParams) middleware.Responder
}

//go:generate mockery -name VersionsAPI -inpkg

/* VersionsAPI  */
type VersionsAPI interface {
	/* ListComponentVersions List of component versions. */
	ListComponentVersions(ctx context.Context, params versions.ListComponentVersionsParams) middleware.Responder

	/* ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions. */
	ListSupportedOpenshiftVersions(ctx context.Context, params versions.ListSupportedOpenshiftVersionsParams) middleware.Responder

	/* V2ListComponentVersions List of component versions. */
	V2ListComponentVersions(ctx context.Context, params versions.V2ListComponentVersionsParams) middleware.Responder

	/* V2ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions. */
	V2ListSupportedOpenshiftVersions(ctx context.Context, params versions.V2ListSupportedOpenshiftVersionsParams) middleware.Responder
}

// Config is configuration for Handler
type Config struct {
	AssistedServiceIsoAPI
	EventsAPI
	InstallerAPI
	ManagedDomainsAPI
	ManifestsAPI
	OperatorsAPI
	VersionsAPI
	Logger func(string, ...interface{})
	// InnerMiddleware is for the handler executors. These do not apply to the swagger.json document.
	// The middleware executes after routing but before authentication, binding and validation
	InnerMiddleware func(http.Handler) http.Handler

	// Authorizer is used to authorize a request after the Auth function was called using the "Auth*" functions
	// and the principal was stored in the context in the "AuthKey" context value.
	Authorizer func(*http.Request) error

	// AuthAgentAuth Applies when the "X-Secret-Key" header is set
	AuthAgentAuth func(token string) (interface{}, error)

	// AuthURLAuth Applies when the "api_key" query is set
	AuthURLAuth func(token string) (interface{}, error)

	// AuthUserAuth Applies when the "Authorization" header is set
	AuthUserAuth func(token string) (interface{}, error)

	// Authenticator to use for all APIKey authentication
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator
	// Authenticator to use for all Bearer authentication
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator
	// Authenticator to use for all Basic authentication
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator
}

// Handler returns an http.Handler given the handler configuration
// It mounts all the business logic implementers in the right routing.
func Handler(c Config) (http.Handler, error) {
	h, _, err := HandlerAPI(c)
	return h, err
}

// HandlerAPI returns an http.Handler given the handler configuration
// and the corresponding *AssistedInstall instance.
// It mounts all the business logic implementers in the right routing.
func HandlerAPI(c Config) (http.Handler, *operations.AssistedInstallAPI, error) {
	spec, err := loads.Analyzed(swaggerCopy(SwaggerJSON), "")
	if err != nil {
		return nil, nil, fmt.Errorf("analyze swagger: %v", err)
	}
	api := operations.NewAssistedInstallAPI(spec)
	api.ServeError = errors.ServeError
	api.Logger = c.Logger

	if c.APIKeyAuthenticator != nil {
		api.APIKeyAuthenticator = c.APIKeyAuthenticator
	}
	if c.BasicAuthenticator != nil {
		api.BasicAuthenticator = c.BasicAuthenticator
	}
	if c.BearerAuthenticator != nil {
		api.BearerAuthenticator = c.BearerAuthenticator
	}

	api.JSONConsumer = runtime.JSONConsumer()
	api.MultipartformConsumer = runtime.DiscardConsumer
	api.BinProducer = runtime.ByteStreamProducer()
	api.JSONProducer = runtime.JSONProducer()
	api.AgentAuthAuth = func(token string) (interface{}, error) {
		if c.AuthAgentAuth == nil {
			return token, nil
		}
		return c.AuthAgentAuth(token)
	}

	api.URLAuthAuth = func(token string) (interface{}, error) {
		if c.AuthURLAuth == nil {
			return token, nil
		}
		return c.AuthURLAuth(token)
	}

	api.UserAuthAuth = func(token string) (interface{}, error) {
		if c.AuthUserAuth == nil {
			return token, nil
		}
		return c.AuthUserAuth(token)
	}

	api.APIAuthorizer = authorizer(c.Authorizer)
	api.InstallerBindHostHandler = installer.BindHostHandlerFunc(func(params installer.BindHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.BindHost(ctx, params)
	})
	api.InstallerCancelInstallationHandler = installer.CancelInstallationHandlerFunc(func(params installer.CancelInstallationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.CancelInstallation(ctx, params)
	})
	api.InstallerCompleteInstallationHandler = installer.CompleteInstallationHandlerFunc(func(params installer.CompleteInstallationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.CompleteInstallation(ctx, params)
	})
	api.ManifestsCreateClusterManifestHandler = manifests.CreateClusterManifestHandlerFunc(func(params manifests.CreateClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.CreateClusterManifest(ctx, params)
	})
	api.AssistedServiceIsoCreateISOAndUploadToS3Handler = assisted_service_iso.CreateISOAndUploadToS3HandlerFunc(func(params assisted_service_iso.CreateISOAndUploadToS3Params, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.AssistedServiceIsoAPI.CreateISOAndUploadToS3(ctx, params)
	})
	api.ManifestsDeleteClusterManifestHandler = manifests.DeleteClusterManifestHandlerFunc(func(params manifests.DeleteClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.DeleteClusterManifest(ctx, params)
	})
	api.InstallerDeregisterClusterHandler = installer.DeregisterClusterHandlerFunc(func(params installer.DeregisterClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DeregisterCluster(ctx, params)
	})
	api.InstallerDeregisterHostHandler = installer.DeregisterHostHandlerFunc(func(params installer.DeregisterHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DeregisterHost(ctx, params)
	})
	api.InstallerDeregisterInfraEnvHandler = installer.DeregisterInfraEnvHandlerFunc(func(params installer.DeregisterInfraEnvParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DeregisterInfraEnv(ctx, params)
	})
	api.InstallerDisableHostHandler = installer.DisableHostHandlerFunc(func(params installer.DisableHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DisableHost(ctx, params)
	})
	api.InstallerDownloadClusterFilesHandler = installer.DownloadClusterFilesHandlerFunc(func(params installer.DownloadClusterFilesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadClusterFiles(ctx, params)
	})
	api.InstallerDownloadClusterISOHandler = installer.DownloadClusterISOHandlerFunc(func(params installer.DownloadClusterISOParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadClusterISO(ctx, params)
	})
	api.InstallerDownloadClusterISOHeadersHandler = installer.DownloadClusterISOHeadersHandlerFunc(func(params installer.DownloadClusterISOHeadersParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadClusterISOHeaders(ctx, params)
	})
	api.InstallerDownloadClusterKubeconfigHandler = installer.DownloadClusterKubeconfigHandlerFunc(func(params installer.DownloadClusterKubeconfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadClusterKubeconfig(ctx, params)
	})
	api.InstallerDownloadClusterLogsHandler = installer.DownloadClusterLogsHandlerFunc(func(params installer.DownloadClusterLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadClusterLogs(ctx, params)
	})
	api.ManifestsDownloadClusterManifestHandler = manifests.DownloadClusterManifestHandlerFunc(func(params manifests.DownloadClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.DownloadClusterManifest(ctx, params)
	})
	api.InstallerDownloadHostIgnitionHandler = installer.DownloadHostIgnitionHandlerFunc(func(params installer.DownloadHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadHostIgnition(ctx, params)
	})
	api.InstallerDownloadHostLogsHandler = installer.DownloadHostLogsHandlerFunc(func(params installer.DownloadHostLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadHostLogs(ctx, params)
	})
	api.AssistedServiceIsoDownloadISOHandler = assisted_service_iso.DownloadISOHandlerFunc(func(params assisted_service_iso.DownloadISOParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.AssistedServiceIsoAPI.DownloadISO(ctx, params)
	})
	api.InstallerDownloadInfraEnvDiscoveryImageHandler = installer.DownloadInfraEnvDiscoveryImageHandlerFunc(func(params installer.DownloadInfraEnvDiscoveryImageParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadInfraEnvDiscoveryImage(ctx, params)
	})
	api.InstallerDownloadInfraEnvDiscoveryImageHeadersHandler = installer.DownloadInfraEnvDiscoveryImageHeadersHandlerFunc(func(params installer.DownloadInfraEnvDiscoveryImageHeadersParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadInfraEnvDiscoveryImageHeaders(ctx, params)
	})
	api.InstallerDownloadMinimalInitrdHandler = installer.DownloadMinimalInitrdHandlerFunc(func(params installer.DownloadMinimalInitrdParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.DownloadMinimalInitrd(ctx, params)
	})
	api.InstallerEnableHostHandler = installer.EnableHostHandlerFunc(func(params installer.EnableHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.EnableHost(ctx, params)
	})
	api.InstallerGenerateClusterISOHandler = installer.GenerateClusterISOHandlerFunc(func(params installer.GenerateClusterISOParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GenerateClusterISO(ctx, params)
	})
	api.InstallerGetClusterHandler = installer.GetClusterHandlerFunc(func(params installer.GetClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetCluster(ctx, params)
	})
	api.InstallerGetClusterDefaultConfigHandler = installer.GetClusterDefaultConfigHandlerFunc(func(params installer.GetClusterDefaultConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetClusterDefaultConfig(ctx, params)
	})
	api.InstallerGetClusterHostRequirementsHandler = installer.GetClusterHostRequirementsHandlerFunc(func(params installer.GetClusterHostRequirementsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetClusterHostRequirements(ctx, params)
	})
	api.InstallerGetClusterInstallConfigHandler = installer.GetClusterInstallConfigHandlerFunc(func(params installer.GetClusterInstallConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetClusterInstallConfig(ctx, params)
	})
	api.InstallerGetClusterSupportedPlatformsHandler = installer.GetClusterSupportedPlatformsHandlerFunc(func(params installer.GetClusterSupportedPlatformsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetClusterSupportedPlatforms(ctx, params)
	})
	api.InstallerGetCredentialsHandler = installer.GetCredentialsHandlerFunc(func(params installer.GetCredentialsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetCredentials(ctx, params)
	})
	api.InstallerGetDiscoveryIgnitionHandler = installer.GetDiscoveryIgnitionHandlerFunc(func(params installer.GetDiscoveryIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetDiscoveryIgnition(ctx, params)
	})
	api.InstallerGetFreeAddressesHandler = installer.GetFreeAddressesHandlerFunc(func(params installer.GetFreeAddressesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetFreeAddresses(ctx, params)
	})
	api.InstallerGetHostHandler = installer.GetHostHandlerFunc(func(params installer.GetHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetHost(ctx, params)
	})
	api.InstallerGetHostIgnitionHandler = installer.GetHostIgnitionHandlerFunc(func(params installer.GetHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetHostIgnition(ctx, params)
	})
	api.InstallerGetInfraEnvHandler = installer.GetInfraEnvHandlerFunc(func(params installer.GetInfraEnvParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetInfraEnv(ctx, params)
	})
	api.InstallerGetPreflightRequirementsHandler = installer.GetPreflightRequirementsHandlerFunc(func(params installer.GetPreflightRequirementsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetPreflightRequirements(ctx, params)
	})
	api.AssistedServiceIsoGetPresignedForAssistedServiceISOHandler = assisted_service_iso.GetPresignedForAssistedServiceISOHandlerFunc(func(params assisted_service_iso.GetPresignedForAssistedServiceISOParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.AssistedServiceIsoAPI.GetPresignedForAssistedServiceISO(ctx, params)
	})
	api.InstallerGetPresignedForClusterFilesHandler = installer.GetPresignedForClusterFilesHandlerFunc(func(params installer.GetPresignedForClusterFilesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.GetPresignedForClusterFiles(ctx, params)
	})
	api.InstallerInstallClusterHandler = installer.InstallClusterHandlerFunc(func(params installer.InstallClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.InstallCluster(ctx, params)
	})
	api.InstallerInstallHostHandler = installer.InstallHostHandlerFunc(func(params installer.InstallHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.InstallHost(ctx, params)
	})
	api.InstallerInstallHostsHandler = installer.InstallHostsHandlerFunc(func(params installer.InstallHostsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.InstallHosts(ctx, params)
	})
	api.ManifestsListClusterManifestsHandler = manifests.ListClusterManifestsHandlerFunc(func(params manifests.ListClusterManifestsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.ListClusterManifests(ctx, params)
	})
	api.InstallerListClustersHandler = installer.ListClustersHandlerFunc(func(params installer.ListClustersParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ListClusters(ctx, params)
	})
	api.VersionsListComponentVersionsHandler = versions.ListComponentVersionsHandlerFunc(func(params versions.ListComponentVersionsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.VersionsAPI.ListComponentVersions(ctx, params)
	})
	api.EventsListEventsHandler = events.ListEventsHandlerFunc(func(params events.ListEventsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.EventsAPI.ListEvents(ctx, params)
	})
	api.InstallerListHostsHandler = installer.ListHostsHandlerFunc(func(params installer.ListHostsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ListHosts(ctx, params)
	})
	api.InstallerListInfraEnvsHandler = installer.ListInfraEnvsHandlerFunc(func(params installer.ListInfraEnvsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ListInfraEnvs(ctx, params)
	})
	api.ManagedDomainsListManagedDomainsHandler = managed_domains.ListManagedDomainsHandlerFunc(func(params managed_domains.ListManagedDomainsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManagedDomainsAPI.ListManagedDomains(ctx, params)
	})
	api.OperatorsListOfClusterOperatorsHandler = operators.ListOfClusterOperatorsHandlerFunc(func(params operators.ListOfClusterOperatorsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.ListOfClusterOperators(ctx, params)
	})
	api.OperatorsListOperatorPropertiesHandler = operators.ListOperatorPropertiesHandlerFunc(func(params operators.ListOperatorPropertiesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.ListOperatorProperties(ctx, params)
	})
	api.VersionsListSupportedOpenshiftVersionsHandler = versions.ListSupportedOpenshiftVersionsHandlerFunc(func(params versions.ListSupportedOpenshiftVersionsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.VersionsAPI.ListSupportedOpenshiftVersions(ctx, params)
	})
	api.OperatorsListSupportedOperatorsHandler = operators.ListSupportedOperatorsHandlerFunc(func(params operators.ListSupportedOperatorsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.ListSupportedOperators(ctx, params)
	})
	api.InstallerRegisterAddHostsClusterHandler = installer.RegisterAddHostsClusterHandlerFunc(func(params installer.RegisterAddHostsClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.RegisterAddHostsCluster(ctx, params)
	})
	api.InstallerRegisterClusterHandler = installer.RegisterClusterHandlerFunc(func(params installer.RegisterClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.RegisterCluster(ctx, params)
	})
	api.InstallerRegisterInfraEnvHandler = installer.RegisterInfraEnvHandlerFunc(func(params installer.RegisterInfraEnvParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.RegisterInfraEnv(ctx, params)
	})
	api.OperatorsReportMonitoredOperatorStatusHandler = operators.ReportMonitoredOperatorStatusHandlerFunc(func(params operators.ReportMonitoredOperatorStatusParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.ReportMonitoredOperatorStatus(ctx, params)
	})
	api.InstallerResetClusterHandler = installer.ResetClusterHandlerFunc(func(params installer.ResetClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ResetCluster(ctx, params)
	})
	api.InstallerResetHostHandler = installer.ResetHostHandlerFunc(func(params installer.ResetHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ResetHost(ctx, params)
	})
	api.InstallerResetHostValidationHandler = installer.ResetHostValidationHandlerFunc(func(params installer.ResetHostValidationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.ResetHostValidation(ctx, params)
	})
	api.InstallerUnbindHostHandler = installer.UnbindHostHandlerFunc(func(params installer.UnbindHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UnbindHost(ctx, params)
	})
	api.InstallerUpdateClusterHandler = installer.UpdateClusterHandlerFunc(func(params installer.UpdateClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateCluster(ctx, params)
	})
	api.InstallerUpdateClusterInstallConfigHandler = installer.UpdateClusterInstallConfigHandlerFunc(func(params installer.UpdateClusterInstallConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateClusterInstallConfig(ctx, params)
	})
	api.InstallerUpdateClusterLogsProgressHandler = installer.UpdateClusterLogsProgressHandlerFunc(func(params installer.UpdateClusterLogsProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateClusterLogsProgress(ctx, params)
	})
	api.InstallerUpdateDiscoveryIgnitionHandler = installer.UpdateDiscoveryIgnitionHandlerFunc(func(params installer.UpdateDiscoveryIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateDiscoveryIgnition(ctx, params)
	})
	api.InstallerUpdateHostIgnitionHandler = installer.UpdateHostIgnitionHandlerFunc(func(params installer.UpdateHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateHostIgnition(ctx, params)
	})
	api.InstallerUpdateHostInstallProgressHandler = installer.UpdateHostInstallProgressHandlerFunc(func(params installer.UpdateHostInstallProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateHostInstallProgress(ctx, params)
	})
	api.InstallerUpdateHostInstallerArgsHandler = installer.UpdateHostInstallerArgsHandlerFunc(func(params installer.UpdateHostInstallerArgsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateHostInstallerArgs(ctx, params)
	})
	api.InstallerUpdateHostLogsProgressHandler = installer.UpdateHostLogsProgressHandlerFunc(func(params installer.UpdateHostLogsProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateHostLogsProgress(ctx, params)
	})
	api.InstallerUpdateInfraEnvHandler = installer.UpdateInfraEnvHandlerFunc(func(params installer.UpdateInfraEnvParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UpdateInfraEnv(ctx, params)
	})
	api.InstallerUploadClusterIngressCertHandler = installer.UploadClusterIngressCertHandlerFunc(func(params installer.UploadClusterIngressCertParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UploadClusterIngressCert(ctx, params)
	})
	api.InstallerUploadHostLogsHandler = installer.UploadHostLogsHandlerFunc(func(params installer.UploadHostLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UploadHostLogs(ctx, params)
	})
	api.InstallerUploadLogsHandler = installer.UploadLogsHandlerFunc(func(params installer.UploadLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.UploadLogs(ctx, params)
	})
	api.InstallerV2CancelInstallationHandler = installer.V2CancelInstallationHandlerFunc(func(params installer.V2CancelInstallationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2CancelInstallation(ctx, params)
	})
	api.ManifestsV2CreateClusterManifestHandler = manifests.V2CreateClusterManifestHandlerFunc(func(params manifests.V2CreateClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.V2CreateClusterManifest(ctx, params)
	})
	api.ManifestsV2DeleteClusterManifestHandler = manifests.V2DeleteClusterManifestHandlerFunc(func(params manifests.V2DeleteClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.V2DeleteClusterManifest(ctx, params)
	})
	api.InstallerV2DownloadClusterCredentialsHandler = installer.V2DownloadClusterCredentialsHandlerFunc(func(params installer.V2DownloadClusterCredentialsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DownloadClusterCredentials(ctx, params)
	})
	api.InstallerV2DownloadClusterFilesHandler = installer.V2DownloadClusterFilesHandlerFunc(func(params installer.V2DownloadClusterFilesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DownloadClusterFiles(ctx, params)
	})
	api.InstallerV2DownloadClusterLogsHandler = installer.V2DownloadClusterLogsHandlerFunc(func(params installer.V2DownloadClusterLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DownloadClusterLogs(ctx, params)
	})
	api.InstallerV2GetClusterDefaultConfigHandler = installer.V2GetClusterDefaultConfigHandlerFunc(func(params installer.V2GetClusterDefaultConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetClusterDefaultConfig(ctx, params)
	})
	api.InstallerV2GetCredentialsHandler = installer.V2GetCredentialsHandlerFunc(func(params installer.V2GetCredentialsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetCredentials(ctx, params)
	})
	api.InstallerV2GetPresignedForClusterFilesHandler = installer.V2GetPresignedForClusterFilesHandlerFunc(func(params installer.V2GetPresignedForClusterFilesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetPresignedForClusterFiles(ctx, params)
	})
	api.ManifestsV2ListClusterManifestsHandler = manifests.V2ListClusterManifestsHandlerFunc(func(params manifests.V2ListClusterManifestsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.V2ListClusterManifests(ctx, params)
	})
	api.ManagedDomainsV2ListManagedDomainsHandler = managed_domains.V2ListManagedDomainsHandlerFunc(func(params managed_domains.V2ListManagedDomainsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManagedDomainsAPI.V2ListManagedDomains(ctx, params)
	})
	api.OperatorsV2ListOfClusterOperatorsHandler = operators.V2ListOfClusterOperatorsHandlerFunc(func(params operators.V2ListOfClusterOperatorsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.V2ListOfClusterOperators(ctx, params)
	})
	api.OperatorsV2ListOperatorPropertiesHandler = operators.V2ListOperatorPropertiesHandlerFunc(func(params operators.V2ListOperatorPropertiesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.V2ListOperatorProperties(ctx, params)
	})
	api.OperatorsV2ListSupportedOperatorsHandler = operators.V2ListSupportedOperatorsHandlerFunc(func(params operators.V2ListSupportedOperatorsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.V2ListSupportedOperators(ctx, params)
	})
	api.InstallerV2UpdateClusterHandler = installer.V2UpdateClusterHandlerFunc(func(params installer.V2UpdateClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateCluster(ctx, params)
	})
	api.InstallerV2UploadLogsHandler = installer.V2UploadLogsHandlerFunc(func(params installer.V2UploadLogsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UploadLogs(ctx, params)
	})
	api.InstallerV2CompleteInstallationHandler = installer.V2CompleteInstallationHandlerFunc(func(params installer.V2CompleteInstallationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2CompleteInstallation(ctx, params)
	})
	api.InstallerV2DeregisterClusterHandler = installer.V2DeregisterClusterHandlerFunc(func(params installer.V2DeregisterClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DeregisterCluster(ctx, params)
	})
	api.InstallerV2DeregisterHostHandler = installer.V2DeregisterHostHandlerFunc(func(params installer.V2DeregisterHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DeregisterHost(ctx, params)
	})
	api.ManifestsV2DownloadClusterManifestHandler = manifests.V2DownloadClusterManifestHandlerFunc(func(params manifests.V2DownloadClusterManifestParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.ManifestsAPI.V2DownloadClusterManifest(ctx, params)
	})
	api.InstallerV2DownloadHostIgnitionHandler = installer.V2DownloadHostIgnitionHandlerFunc(func(params installer.V2DownloadHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DownloadHostIgnition(ctx, params)
	})
	api.InstallerV2DownloadInfraEnvFilesHandler = installer.V2DownloadInfraEnvFilesHandlerFunc(func(params installer.V2DownloadInfraEnvFilesParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2DownloadInfraEnvFiles(ctx, params)
	})
	api.InstallerV2GetClusterHandler = installer.V2GetClusterHandlerFunc(func(params installer.V2GetClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetCluster(ctx, params)
	})
	api.InstallerV2GetClusterInstallConfigHandler = installer.V2GetClusterInstallConfigHandlerFunc(func(params installer.V2GetClusterInstallConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetClusterInstallConfig(ctx, params)
	})
	api.InstallerV2GetHostHandler = installer.V2GetHostHandlerFunc(func(params installer.V2GetHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetHost(ctx, params)
	})
	api.InstallerV2GetHostIgnitionHandler = installer.V2GetHostIgnitionHandlerFunc(func(params installer.V2GetHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetHostIgnition(ctx, params)
	})
	api.InstallerV2GetNextStepsHandler = installer.V2GetNextStepsHandlerFunc(func(params installer.V2GetNextStepsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetNextSteps(ctx, params)
	})
	api.InstallerV2GetPreflightRequirementsHandler = installer.V2GetPreflightRequirementsHandlerFunc(func(params installer.V2GetPreflightRequirementsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2GetPreflightRequirements(ctx, params)
	})
	api.InstallerV2InstallClusterHandler = installer.V2InstallClusterHandlerFunc(func(params installer.V2InstallClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2InstallCluster(ctx, params)
	})
	api.InstallerV2InstallHostHandler = installer.V2InstallHostHandlerFunc(func(params installer.V2InstallHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2InstallHost(ctx, params)
	})
	api.InstallerV2ListClustersHandler = installer.V2ListClustersHandlerFunc(func(params installer.V2ListClustersParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2ListClusters(ctx, params)
	})
	api.VersionsV2ListComponentVersionsHandler = versions.V2ListComponentVersionsHandlerFunc(func(params versions.V2ListComponentVersionsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.VersionsAPI.V2ListComponentVersions(ctx, params)
	})
	api.InstallerV2ListHostsHandler = installer.V2ListHostsHandlerFunc(func(params installer.V2ListHostsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2ListHosts(ctx, params)
	})
	api.VersionsV2ListSupportedOpenshiftVersionsHandler = versions.V2ListSupportedOpenshiftVersionsHandlerFunc(func(params versions.V2ListSupportedOpenshiftVersionsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.VersionsAPI.V2ListSupportedOpenshiftVersions(ctx, params)
	})
	api.InstallerV2PostStepReplyHandler = installer.V2PostStepReplyHandlerFunc(func(params installer.V2PostStepReplyParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2PostStepReply(ctx, params)
	})
	api.InstallerV2RegisterClusterHandler = installer.V2RegisterClusterHandlerFunc(func(params installer.V2RegisterClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2RegisterCluster(ctx, params)
	})
	api.InstallerV2RegisterHostHandler = installer.V2RegisterHostHandlerFunc(func(params installer.V2RegisterHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2RegisterHost(ctx, params)
	})
	api.OperatorsV2ReportMonitoredOperatorStatusHandler = operators.V2ReportMonitoredOperatorStatusHandlerFunc(func(params operators.V2ReportMonitoredOperatorStatusParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.OperatorsAPI.V2ReportMonitoredOperatorStatus(ctx, params)
	})
	api.InstallerV2ResetClusterHandler = installer.V2ResetClusterHandlerFunc(func(params installer.V2ResetClusterParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2ResetCluster(ctx, params)
	})
	api.InstallerV2ResetHostHandler = installer.V2ResetHostHandlerFunc(func(params installer.V2ResetHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2ResetHost(ctx, params)
	})
	api.InstallerV2ResetHostValidationHandler = installer.V2ResetHostValidationHandlerFunc(func(params installer.V2ResetHostValidationParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2ResetHostValidation(ctx, params)
	})
	api.InstallerV2UpdateClusterInstallConfigHandler = installer.V2UpdateClusterInstallConfigHandlerFunc(func(params installer.V2UpdateClusterInstallConfigParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateClusterInstallConfig(ctx, params)
	})
	api.InstallerV2UpdateClusterLogsProgressHandler = installer.V2UpdateClusterLogsProgressHandlerFunc(func(params installer.V2UpdateClusterLogsProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateClusterLogsProgress(ctx, params)
	})
	api.InstallerV2UpdateHostHandler = installer.V2UpdateHostHandlerFunc(func(params installer.V2UpdateHostParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateHost(ctx, params)
	})
	api.InstallerV2UpdateHostIgnitionHandler = installer.V2UpdateHostIgnitionHandlerFunc(func(params installer.V2UpdateHostIgnitionParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateHostIgnition(ctx, params)
	})
	api.InstallerV2UpdateHostInstallProgressHandler = installer.V2UpdateHostInstallProgressHandlerFunc(func(params installer.V2UpdateHostInstallProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateHostInstallProgress(ctx, params)
	})
	api.InstallerV2UpdateHostInstallerArgsHandler = installer.V2UpdateHostInstallerArgsHandlerFunc(func(params installer.V2UpdateHostInstallerArgsParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateHostInstallerArgs(ctx, params)
	})
	api.InstallerV2UpdateHostLogsProgressHandler = installer.V2UpdateHostLogsProgressHandlerFunc(func(params installer.V2UpdateHostLogsProgressParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UpdateHostLogsProgress(ctx, params)
	})
	api.InstallerV2UploadClusterIngressCertHandler = installer.V2UploadClusterIngressCertHandlerFunc(func(params installer.V2UploadClusterIngressCertParams, principal interface{}) middleware.Responder {
		ctx := params.HTTPRequest.Context()
		ctx = storeAuth(ctx, principal)
		return c.InstallerAPI.V2UploadClusterIngressCert(ctx, params)
	})
	api.ServerShutdown = func() {}
	return api.Serve(c.InnerMiddleware), api, nil
}

// swaggerCopy copies the swagger json to prevent data races in runtime
func swaggerCopy(orig json.RawMessage) json.RawMessage {
	c := make(json.RawMessage, len(orig))
	copy(c, orig)
	return c
}

// authorizer is a helper function to implement the runtime.Authorizer interface.
type authorizer func(*http.Request) error

func (a authorizer) Authorize(req *http.Request, principal interface{}) error {
	if a == nil {
		return nil
	}
	ctx := storeAuth(req.Context(), principal)
	return a(req.WithContext(ctx))
}

func storeAuth(ctx context.Context, principal interface{}) context.Context {
	return context.WithValue(ctx, AuthKey, principal)
}
