// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/loads"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/runtime/security"
	"github.com/go-openapi/spec"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/openshift/assisted-service/restapi/operations/assisted_service_iso"
	"github.com/openshift/assisted-service/restapi/operations/events"
	"github.com/openshift/assisted-service/restapi/operations/installer"
	"github.com/openshift/assisted-service/restapi/operations/managed_domains"
	"github.com/openshift/assisted-service/restapi/operations/manifests"
	"github.com/openshift/assisted-service/restapi/operations/operators"
	"github.com/openshift/assisted-service/restapi/operations/versions"
)

// NewAssistedInstallAPI creates a new AssistedInstall instance
func NewAssistedInstallAPI(spec *loads.Document) *AssistedInstallAPI {
	return &AssistedInstallAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		customConsumers:     make(map[string]runtime.Consumer),
		customProducers:     make(map[string]runtime.Producer),
		PreServerShutdown:   func() {},
		ServerShutdown:      func() {},
		spec:                spec,
		useSwaggerUI:        false,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,

		JSONConsumer:          runtime.JSONConsumer(),
		MultipartformConsumer: runtime.DiscardConsumer,

		BinProducer:  runtime.ByteStreamProducer(),
		JSONProducer: runtime.JSONProducer(),

		InstallerBindHostHandler: installer.BindHostHandlerFunc(func(params installer.BindHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.BindHost has not yet been implemented")
		}),
		InstallerCancelInstallationHandler: installer.CancelInstallationHandlerFunc(func(params installer.CancelInstallationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.CancelInstallation has not yet been implemented")
		}),
		InstallerCompleteInstallationHandler: installer.CompleteInstallationHandlerFunc(func(params installer.CompleteInstallationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.CompleteInstallation has not yet been implemented")
		}),
		ManifestsCreateClusterManifestHandler: manifests.CreateClusterManifestHandlerFunc(func(params manifests.CreateClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.CreateClusterManifest has not yet been implemented")
		}),
		AssistedServiceIsoCreateISOAndUploadToS3Handler: assisted_service_iso.CreateISOAndUploadToS3HandlerFunc(func(params assisted_service_iso.CreateISOAndUploadToS3Params, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation assisted_service_iso.CreateISOAndUploadToS3 has not yet been implemented")
		}),
		ManifestsDeleteClusterManifestHandler: manifests.DeleteClusterManifestHandlerFunc(func(params manifests.DeleteClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.DeleteClusterManifest has not yet been implemented")
		}),
		InstallerDeregisterClusterHandler: installer.DeregisterClusterHandlerFunc(func(params installer.DeregisterClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DeregisterCluster has not yet been implemented")
		}),
		InstallerDeregisterHostHandler: installer.DeregisterHostHandlerFunc(func(params installer.DeregisterHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DeregisterHost has not yet been implemented")
		}),
		InstallerDeregisterInfraEnvHandler: installer.DeregisterInfraEnvHandlerFunc(func(params installer.DeregisterInfraEnvParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DeregisterInfraEnv has not yet been implemented")
		}),
		InstallerDisableHostHandler: installer.DisableHostHandlerFunc(func(params installer.DisableHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DisableHost has not yet been implemented")
		}),
		InstallerDownloadClusterFilesHandler: installer.DownloadClusterFilesHandlerFunc(func(params installer.DownloadClusterFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadClusterFiles has not yet been implemented")
		}),
		InstallerDownloadClusterISOHandler: installer.DownloadClusterISOHandlerFunc(func(params installer.DownloadClusterISOParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadClusterISO has not yet been implemented")
		}),
		InstallerDownloadClusterISOHeadersHandler: installer.DownloadClusterISOHeadersHandlerFunc(func(params installer.DownloadClusterISOHeadersParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadClusterISOHeaders has not yet been implemented")
		}),
		InstallerDownloadClusterKubeconfigHandler: installer.DownloadClusterKubeconfigHandlerFunc(func(params installer.DownloadClusterKubeconfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadClusterKubeconfig has not yet been implemented")
		}),
		InstallerDownloadClusterLogsHandler: installer.DownloadClusterLogsHandlerFunc(func(params installer.DownloadClusterLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadClusterLogs has not yet been implemented")
		}),
		ManifestsDownloadClusterManifestHandler: manifests.DownloadClusterManifestHandlerFunc(func(params manifests.DownloadClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.DownloadClusterManifest has not yet been implemented")
		}),
		InstallerDownloadHostIgnitionHandler: installer.DownloadHostIgnitionHandlerFunc(func(params installer.DownloadHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadHostIgnition has not yet been implemented")
		}),
		InstallerDownloadHostLogsHandler: installer.DownloadHostLogsHandlerFunc(func(params installer.DownloadHostLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadHostLogs has not yet been implemented")
		}),
		AssistedServiceIsoDownloadISOHandler: assisted_service_iso.DownloadISOHandlerFunc(func(params assisted_service_iso.DownloadISOParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation assisted_service_iso.DownloadISO has not yet been implemented")
		}),
		InstallerDownloadInfraEnvDiscoveryImageHandler: installer.DownloadInfraEnvDiscoveryImageHandlerFunc(func(params installer.DownloadInfraEnvDiscoveryImageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadInfraEnvDiscoveryImage has not yet been implemented")
		}),
		InstallerDownloadInfraEnvDiscoveryImageHeadersHandler: installer.DownloadInfraEnvDiscoveryImageHeadersHandlerFunc(func(params installer.DownloadInfraEnvDiscoveryImageHeadersParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadInfraEnvDiscoveryImageHeaders has not yet been implemented")
		}),
		InstallerDownloadMinimalInitrdHandler: installer.DownloadMinimalInitrdHandlerFunc(func(params installer.DownloadMinimalInitrdParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.DownloadMinimalInitrd has not yet been implemented")
		}),
		InstallerEnableHostHandler: installer.EnableHostHandlerFunc(func(params installer.EnableHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.EnableHost has not yet been implemented")
		}),
		InstallerGenerateClusterISOHandler: installer.GenerateClusterISOHandlerFunc(func(params installer.GenerateClusterISOParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GenerateClusterISO has not yet been implemented")
		}),
		InstallerGetClusterHandler: installer.GetClusterHandlerFunc(func(params installer.GetClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetCluster has not yet been implemented")
		}),
		InstallerGetClusterDefaultConfigHandler: installer.GetClusterDefaultConfigHandlerFunc(func(params installer.GetClusterDefaultConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetClusterDefaultConfig has not yet been implemented")
		}),
		InstallerGetClusterHostRequirementsHandler: installer.GetClusterHostRequirementsHandlerFunc(func(params installer.GetClusterHostRequirementsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetClusterHostRequirements has not yet been implemented")
		}),
		InstallerGetClusterInstallConfigHandler: installer.GetClusterInstallConfigHandlerFunc(func(params installer.GetClusterInstallConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetClusterInstallConfig has not yet been implemented")
		}),
		InstallerGetClusterSupportedPlatformsHandler: installer.GetClusterSupportedPlatformsHandlerFunc(func(params installer.GetClusterSupportedPlatformsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetClusterSupportedPlatforms has not yet been implemented")
		}),
		InstallerGetCredentialsHandler: installer.GetCredentialsHandlerFunc(func(params installer.GetCredentialsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetCredentials has not yet been implemented")
		}),
		InstallerGetDiscoveryIgnitionHandler: installer.GetDiscoveryIgnitionHandlerFunc(func(params installer.GetDiscoveryIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetDiscoveryIgnition has not yet been implemented")
		}),
		InstallerGetFreeAddressesHandler: installer.GetFreeAddressesHandlerFunc(func(params installer.GetFreeAddressesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetFreeAddresses has not yet been implemented")
		}),
		InstallerGetHostHandler: installer.GetHostHandlerFunc(func(params installer.GetHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetHost has not yet been implemented")
		}),
		InstallerGetHostIgnitionHandler: installer.GetHostIgnitionHandlerFunc(func(params installer.GetHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetHostIgnition has not yet been implemented")
		}),
		InstallerGetInfraEnvHandler: installer.GetInfraEnvHandlerFunc(func(params installer.GetInfraEnvParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetInfraEnv has not yet been implemented")
		}),
		InstallerGetPreflightRequirementsHandler: installer.GetPreflightRequirementsHandlerFunc(func(params installer.GetPreflightRequirementsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetPreflightRequirements has not yet been implemented")
		}),
		AssistedServiceIsoGetPresignedForAssistedServiceISOHandler: assisted_service_iso.GetPresignedForAssistedServiceISOHandlerFunc(func(params assisted_service_iso.GetPresignedForAssistedServiceISOParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation assisted_service_iso.GetPresignedForAssistedServiceISO has not yet been implemented")
		}),
		InstallerGetPresignedForClusterFilesHandler: installer.GetPresignedForClusterFilesHandlerFunc(func(params installer.GetPresignedForClusterFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.GetPresignedForClusterFiles has not yet been implemented")
		}),
		InstallerInstallClusterHandler: installer.InstallClusterHandlerFunc(func(params installer.InstallClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.InstallCluster has not yet been implemented")
		}),
		InstallerInstallHostHandler: installer.InstallHostHandlerFunc(func(params installer.InstallHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.InstallHost has not yet been implemented")
		}),
		InstallerInstallHostsHandler: installer.InstallHostsHandlerFunc(func(params installer.InstallHostsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.InstallHosts has not yet been implemented")
		}),
		ManifestsListClusterManifestsHandler: manifests.ListClusterManifestsHandlerFunc(func(params manifests.ListClusterManifestsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.ListClusterManifests has not yet been implemented")
		}),
		InstallerListClustersHandler: installer.ListClustersHandlerFunc(func(params installer.ListClustersParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ListClusters has not yet been implemented")
		}),
		VersionsListComponentVersionsHandler: versions.ListComponentVersionsHandlerFunc(func(params versions.ListComponentVersionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation versions.ListComponentVersions has not yet been implemented")
		}),
		EventsListEventsHandler: events.ListEventsHandlerFunc(func(params events.ListEventsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation events.ListEvents has not yet been implemented")
		}),
		InstallerListHostsHandler: installer.ListHostsHandlerFunc(func(params installer.ListHostsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ListHosts has not yet been implemented")
		}),
		InstallerListInfraEnvsHandler: installer.ListInfraEnvsHandlerFunc(func(params installer.ListInfraEnvsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ListInfraEnvs has not yet been implemented")
		}),
		ManagedDomainsListManagedDomainsHandler: managed_domains.ListManagedDomainsHandlerFunc(func(params managed_domains.ListManagedDomainsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation managed_domains.ListManagedDomains has not yet been implemented")
		}),
		OperatorsListOfClusterOperatorsHandler: operators.ListOfClusterOperatorsHandlerFunc(func(params operators.ListOfClusterOperatorsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.ListOfClusterOperators has not yet been implemented")
		}),
		OperatorsListOperatorPropertiesHandler: operators.ListOperatorPropertiesHandlerFunc(func(params operators.ListOperatorPropertiesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.ListOperatorProperties has not yet been implemented")
		}),
		VersionsListSupportedOpenshiftVersionsHandler: versions.ListSupportedOpenshiftVersionsHandlerFunc(func(params versions.ListSupportedOpenshiftVersionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation versions.ListSupportedOpenshiftVersions has not yet been implemented")
		}),
		OperatorsListSupportedOperatorsHandler: operators.ListSupportedOperatorsHandlerFunc(func(params operators.ListSupportedOperatorsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.ListSupportedOperators has not yet been implemented")
		}),
		InstallerRegisterAddHostsClusterHandler: installer.RegisterAddHostsClusterHandlerFunc(func(params installer.RegisterAddHostsClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.RegisterAddHostsCluster has not yet been implemented")
		}),
		InstallerRegisterClusterHandler: installer.RegisterClusterHandlerFunc(func(params installer.RegisterClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.RegisterCluster has not yet been implemented")
		}),
		InstallerRegisterInfraEnvHandler: installer.RegisterInfraEnvHandlerFunc(func(params installer.RegisterInfraEnvParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.RegisterInfraEnv has not yet been implemented")
		}),
		OperatorsReportMonitoredOperatorStatusHandler: operators.ReportMonitoredOperatorStatusHandlerFunc(func(params operators.ReportMonitoredOperatorStatusParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.ReportMonitoredOperatorStatus has not yet been implemented")
		}),
		InstallerResetClusterHandler: installer.ResetClusterHandlerFunc(func(params installer.ResetClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ResetCluster has not yet been implemented")
		}),
		InstallerResetHostHandler: installer.ResetHostHandlerFunc(func(params installer.ResetHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ResetHost has not yet been implemented")
		}),
		InstallerResetHostValidationHandler: installer.ResetHostValidationHandlerFunc(func(params installer.ResetHostValidationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.ResetHostValidation has not yet been implemented")
		}),
		InstallerUnbindHostHandler: installer.UnbindHostHandlerFunc(func(params installer.UnbindHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UnbindHost has not yet been implemented")
		}),
		InstallerUpdateClusterHandler: installer.UpdateClusterHandlerFunc(func(params installer.UpdateClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateCluster has not yet been implemented")
		}),
		InstallerUpdateClusterInstallConfigHandler: installer.UpdateClusterInstallConfigHandlerFunc(func(params installer.UpdateClusterInstallConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateClusterInstallConfig has not yet been implemented")
		}),
		InstallerUpdateClusterLogsProgressHandler: installer.UpdateClusterLogsProgressHandlerFunc(func(params installer.UpdateClusterLogsProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateClusterLogsProgress has not yet been implemented")
		}),
		InstallerUpdateDiscoveryIgnitionHandler: installer.UpdateDiscoveryIgnitionHandlerFunc(func(params installer.UpdateDiscoveryIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateDiscoveryIgnition has not yet been implemented")
		}),
		InstallerUpdateHostIgnitionHandler: installer.UpdateHostIgnitionHandlerFunc(func(params installer.UpdateHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateHostIgnition has not yet been implemented")
		}),
		InstallerUpdateHostInstallProgressHandler: installer.UpdateHostInstallProgressHandlerFunc(func(params installer.UpdateHostInstallProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateHostInstallProgress has not yet been implemented")
		}),
		InstallerUpdateHostInstallerArgsHandler: installer.UpdateHostInstallerArgsHandlerFunc(func(params installer.UpdateHostInstallerArgsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateHostInstallerArgs has not yet been implemented")
		}),
		InstallerUpdateHostLogsProgressHandler: installer.UpdateHostLogsProgressHandlerFunc(func(params installer.UpdateHostLogsProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateHostLogsProgress has not yet been implemented")
		}),
		InstallerUpdateInfraEnvHandler: installer.UpdateInfraEnvHandlerFunc(func(params installer.UpdateInfraEnvParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UpdateInfraEnv has not yet been implemented")
		}),
		InstallerUploadClusterIngressCertHandler: installer.UploadClusterIngressCertHandlerFunc(func(params installer.UploadClusterIngressCertParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UploadClusterIngressCert has not yet been implemented")
		}),
		InstallerUploadHostLogsHandler: installer.UploadHostLogsHandlerFunc(func(params installer.UploadHostLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UploadHostLogs has not yet been implemented")
		}),
		InstallerUploadLogsHandler: installer.UploadLogsHandlerFunc(func(params installer.UploadLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.UploadLogs has not yet been implemented")
		}),
		InstallerV2CancelInstallationHandler: installer.V2CancelInstallationHandlerFunc(func(params installer.V2CancelInstallationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2CancelInstallation has not yet been implemented")
		}),
		ManifestsV2CreateClusterManifestHandler: manifests.V2CreateClusterManifestHandlerFunc(func(params manifests.V2CreateClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.V2CreateClusterManifest has not yet been implemented")
		}),
		ManifestsV2DeleteClusterManifestHandler: manifests.V2DeleteClusterManifestHandlerFunc(func(params manifests.V2DeleteClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.V2DeleteClusterManifest has not yet been implemented")
		}),
		InstallerV2DownloadClusterCredentialsHandler: installer.V2DownloadClusterCredentialsHandlerFunc(func(params installer.V2DownloadClusterCredentialsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DownloadClusterCredentials has not yet been implemented")
		}),
		InstallerV2DownloadClusterFilesHandler: installer.V2DownloadClusterFilesHandlerFunc(func(params installer.V2DownloadClusterFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DownloadClusterFiles has not yet been implemented")
		}),
		InstallerV2DownloadClusterLogsHandler: installer.V2DownloadClusterLogsHandlerFunc(func(params installer.V2DownloadClusterLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DownloadClusterLogs has not yet been implemented")
		}),
		InstallerV2GetClusterDefaultConfigHandler: installer.V2GetClusterDefaultConfigHandlerFunc(func(params installer.V2GetClusterDefaultConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetClusterDefaultConfig has not yet been implemented")
		}),
		InstallerV2GetCredentialsHandler: installer.V2GetCredentialsHandlerFunc(func(params installer.V2GetCredentialsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetCredentials has not yet been implemented")
		}),
		InstallerV2GetPresignedForClusterFilesHandler: installer.V2GetPresignedForClusterFilesHandlerFunc(func(params installer.V2GetPresignedForClusterFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetPresignedForClusterFiles has not yet been implemented")
		}),
		ManifestsV2ListClusterManifestsHandler: manifests.V2ListClusterManifestsHandlerFunc(func(params manifests.V2ListClusterManifestsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.V2ListClusterManifests has not yet been implemented")
		}),
		ManagedDomainsV2ListManagedDomainsHandler: managed_domains.V2ListManagedDomainsHandlerFunc(func(params managed_domains.V2ListManagedDomainsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation managed_domains.V2ListManagedDomains has not yet been implemented")
		}),
		OperatorsV2ListOfClusterOperatorsHandler: operators.V2ListOfClusterOperatorsHandlerFunc(func(params operators.V2ListOfClusterOperatorsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.V2ListOfClusterOperators has not yet been implemented")
		}),
		OperatorsV2ListOperatorPropertiesHandler: operators.V2ListOperatorPropertiesHandlerFunc(func(params operators.V2ListOperatorPropertiesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.V2ListOperatorProperties has not yet been implemented")
		}),
		OperatorsV2ListSupportedOperatorsHandler: operators.V2ListSupportedOperatorsHandlerFunc(func(params operators.V2ListSupportedOperatorsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.V2ListSupportedOperators has not yet been implemented")
		}),
		InstallerV2UpdateClusterHandler: installer.V2UpdateClusterHandlerFunc(func(params installer.V2UpdateClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateCluster has not yet been implemented")
		}),
		InstallerV2UploadLogsHandler: installer.V2UploadLogsHandlerFunc(func(params installer.V2UploadLogsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UploadLogs has not yet been implemented")
		}),
		InstallerV2CompleteInstallationHandler: installer.V2CompleteInstallationHandlerFunc(func(params installer.V2CompleteInstallationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2CompleteInstallation has not yet been implemented")
		}),
		InstallerV2DeregisterClusterHandler: installer.V2DeregisterClusterHandlerFunc(func(params installer.V2DeregisterClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DeregisterCluster has not yet been implemented")
		}),
		InstallerV2DeregisterHostHandler: installer.V2DeregisterHostHandlerFunc(func(params installer.V2DeregisterHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DeregisterHost has not yet been implemented")
		}),
		ManifestsV2DownloadClusterManifestHandler: manifests.V2DownloadClusterManifestHandlerFunc(func(params manifests.V2DownloadClusterManifestParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation manifests.V2DownloadClusterManifest has not yet been implemented")
		}),
		InstallerV2DownloadHostIgnitionHandler: installer.V2DownloadHostIgnitionHandlerFunc(func(params installer.V2DownloadHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DownloadHostIgnition has not yet been implemented")
		}),
		InstallerV2DownloadInfraEnvFilesHandler: installer.V2DownloadInfraEnvFilesHandlerFunc(func(params installer.V2DownloadInfraEnvFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2DownloadInfraEnvFiles has not yet been implemented")
		}),
		InstallerV2GetClusterHandler: installer.V2GetClusterHandlerFunc(func(params installer.V2GetClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetCluster has not yet been implemented")
		}),
		InstallerV2GetClusterInstallConfigHandler: installer.V2GetClusterInstallConfigHandlerFunc(func(params installer.V2GetClusterInstallConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetClusterInstallConfig has not yet been implemented")
		}),
		InstallerV2GetHostHandler: installer.V2GetHostHandlerFunc(func(params installer.V2GetHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetHost has not yet been implemented")
		}),
		InstallerV2GetHostIgnitionHandler: installer.V2GetHostIgnitionHandlerFunc(func(params installer.V2GetHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetHostIgnition has not yet been implemented")
		}),
		InstallerV2GetNextStepsHandler: installer.V2GetNextStepsHandlerFunc(func(params installer.V2GetNextStepsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetNextSteps has not yet been implemented")
		}),
		InstallerV2GetPreflightRequirementsHandler: installer.V2GetPreflightRequirementsHandlerFunc(func(params installer.V2GetPreflightRequirementsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2GetPreflightRequirements has not yet been implemented")
		}),
		InstallerV2InstallClusterHandler: installer.V2InstallClusterHandlerFunc(func(params installer.V2InstallClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2InstallCluster has not yet been implemented")
		}),
		InstallerV2InstallHostHandler: installer.V2InstallHostHandlerFunc(func(params installer.V2InstallHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2InstallHost has not yet been implemented")
		}),
		InstallerV2ListClustersHandler: installer.V2ListClustersHandlerFunc(func(params installer.V2ListClustersParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2ListClusters has not yet been implemented")
		}),
		VersionsV2ListComponentVersionsHandler: versions.V2ListComponentVersionsHandlerFunc(func(params versions.V2ListComponentVersionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation versions.V2ListComponentVersions has not yet been implemented")
		}),
		InstallerV2ListHostsHandler: installer.V2ListHostsHandlerFunc(func(params installer.V2ListHostsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2ListHosts has not yet been implemented")
		}),
		VersionsV2ListSupportedOpenshiftVersionsHandler: versions.V2ListSupportedOpenshiftVersionsHandlerFunc(func(params versions.V2ListSupportedOpenshiftVersionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation versions.V2ListSupportedOpenshiftVersions has not yet been implemented")
		}),
		InstallerV2PostStepReplyHandler: installer.V2PostStepReplyHandlerFunc(func(params installer.V2PostStepReplyParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2PostStepReply has not yet been implemented")
		}),
		InstallerV2RegisterClusterHandler: installer.V2RegisterClusterHandlerFunc(func(params installer.V2RegisterClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2RegisterCluster has not yet been implemented")
		}),
		InstallerV2RegisterHostHandler: installer.V2RegisterHostHandlerFunc(func(params installer.V2RegisterHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2RegisterHost has not yet been implemented")
		}),
		OperatorsV2ReportMonitoredOperatorStatusHandler: operators.V2ReportMonitoredOperatorStatusHandlerFunc(func(params operators.V2ReportMonitoredOperatorStatusParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation operators.V2ReportMonitoredOperatorStatus has not yet been implemented")
		}),
		InstallerV2ResetClusterHandler: installer.V2ResetClusterHandlerFunc(func(params installer.V2ResetClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2ResetCluster has not yet been implemented")
		}),
		InstallerV2ResetHostHandler: installer.V2ResetHostHandlerFunc(func(params installer.V2ResetHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2ResetHost has not yet been implemented")
		}),
		InstallerV2ResetHostValidationHandler: installer.V2ResetHostValidationHandlerFunc(func(params installer.V2ResetHostValidationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2ResetHostValidation has not yet been implemented")
		}),
		InstallerV2UpdateClusterInstallConfigHandler: installer.V2UpdateClusterInstallConfigHandlerFunc(func(params installer.V2UpdateClusterInstallConfigParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateClusterInstallConfig has not yet been implemented")
		}),
		InstallerV2UpdateClusterLogsProgressHandler: installer.V2UpdateClusterLogsProgressHandlerFunc(func(params installer.V2UpdateClusterLogsProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateClusterLogsProgress has not yet been implemented")
		}),
		InstallerV2UpdateHostHandler: installer.V2UpdateHostHandlerFunc(func(params installer.V2UpdateHostParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateHost has not yet been implemented")
		}),
		InstallerV2UpdateHostIgnitionHandler: installer.V2UpdateHostIgnitionHandlerFunc(func(params installer.V2UpdateHostIgnitionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateHostIgnition has not yet been implemented")
		}),
		InstallerV2UpdateHostInstallProgressHandler: installer.V2UpdateHostInstallProgressHandlerFunc(func(params installer.V2UpdateHostInstallProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateHostInstallProgress has not yet been implemented")
		}),
		InstallerV2UpdateHostInstallerArgsHandler: installer.V2UpdateHostInstallerArgsHandlerFunc(func(params installer.V2UpdateHostInstallerArgsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateHostInstallerArgs has not yet been implemented")
		}),
		InstallerV2UpdateHostLogsProgressHandler: installer.V2UpdateHostLogsProgressHandlerFunc(func(params installer.V2UpdateHostLogsProgressParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UpdateHostLogsProgress has not yet been implemented")
		}),
		InstallerV2UploadClusterIngressCertHandler: installer.V2UploadClusterIngressCertHandlerFunc(func(params installer.V2UploadClusterIngressCertParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation installer.V2UploadClusterIngressCert has not yet been implemented")
		}),

		// Applies when the "X-Secret-Key" header is set
		AgentAuthAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (agentAuth) X-Secret-Key from header param [X-Secret-Key] has not yet been implemented")
		},
		// Applies when the "api_key" query is set
		URLAuthAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (urlAuth) api_key from query param [api_key] has not yet been implemented")
		},
		// Applies when the "Authorization" header is set
		UserAuthAuth: func(token string) (interface{}, error) {
			return nil, errors.NotImplemented("api key auth (userAuth) Authorization from header param [Authorization] has not yet been implemented")
		},
		// default authorizer is authorized meaning no requests are blocked
		APIAuthorizer: security.Authorized(),
	}
}

/*AssistedInstallAPI Assisted installation */
type AssistedInstallAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	customConsumers map[string]runtime.Consumer
	customProducers map[string]runtime.Producer
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler
	useSwaggerUI    bool

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator
	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator
	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for the following mime types:
	//   - application/json
	JSONConsumer runtime.Consumer
	// MultipartformConsumer registers a consumer for the following mime types:
	//   - multipart/form-data
	MultipartformConsumer runtime.Consumer

	// BinProducer registers a producer for the following mime types:
	//   - application/octet-stream
	BinProducer runtime.Producer
	// JSONProducer registers a producer for the following mime types:
	//   - application/json
	JSONProducer runtime.Producer

	// AgentAuthAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key X-Secret-Key provided in the header
	AgentAuthAuth func(string) (interface{}, error)

	// URLAuthAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key api_key provided in the query
	URLAuthAuth func(string) (interface{}, error)

	// UserAuthAuth registers a function that takes a token and returns a principal
	// it performs authentication based on an api key Authorization provided in the header
	UserAuthAuth func(string) (interface{}, error)

	// APIAuthorizer provides access control (ACL/RBAC/ABAC) by providing access to the request and authenticated principal
	APIAuthorizer runtime.Authorizer

	// InstallerBindHostHandler sets the operation handler for the bind host operation
	InstallerBindHostHandler installer.BindHostHandler
	// InstallerCancelInstallationHandler sets the operation handler for the cancel installation operation
	InstallerCancelInstallationHandler installer.CancelInstallationHandler
	// InstallerCompleteInstallationHandler sets the operation handler for the complete installation operation
	InstallerCompleteInstallationHandler installer.CompleteInstallationHandler
	// ManifestsCreateClusterManifestHandler sets the operation handler for the create cluster manifest operation
	ManifestsCreateClusterManifestHandler manifests.CreateClusterManifestHandler
	// AssistedServiceIsoCreateISOAndUploadToS3Handler sets the operation handler for the create i s o and upload to s3 operation
	AssistedServiceIsoCreateISOAndUploadToS3Handler assisted_service_iso.CreateISOAndUploadToS3Handler
	// ManifestsDeleteClusterManifestHandler sets the operation handler for the delete cluster manifest operation
	ManifestsDeleteClusterManifestHandler manifests.DeleteClusterManifestHandler
	// InstallerDeregisterClusterHandler sets the operation handler for the deregister cluster operation
	InstallerDeregisterClusterHandler installer.DeregisterClusterHandler
	// InstallerDeregisterHostHandler sets the operation handler for the deregister host operation
	InstallerDeregisterHostHandler installer.DeregisterHostHandler
	// InstallerDeregisterInfraEnvHandler sets the operation handler for the deregister infra env operation
	InstallerDeregisterInfraEnvHandler installer.DeregisterInfraEnvHandler
	// InstallerDisableHostHandler sets the operation handler for the disable host operation
	InstallerDisableHostHandler installer.DisableHostHandler
	// InstallerDownloadClusterFilesHandler sets the operation handler for the download cluster files operation
	InstallerDownloadClusterFilesHandler installer.DownloadClusterFilesHandler
	// InstallerDownloadClusterISOHandler sets the operation handler for the download cluster i s o operation
	InstallerDownloadClusterISOHandler installer.DownloadClusterISOHandler
	// InstallerDownloadClusterISOHeadersHandler sets the operation handler for the download cluster i s o headers operation
	InstallerDownloadClusterISOHeadersHandler installer.DownloadClusterISOHeadersHandler
	// InstallerDownloadClusterKubeconfigHandler sets the operation handler for the download cluster kubeconfig operation
	InstallerDownloadClusterKubeconfigHandler installer.DownloadClusterKubeconfigHandler
	// InstallerDownloadClusterLogsHandler sets the operation handler for the download cluster logs operation
	InstallerDownloadClusterLogsHandler installer.DownloadClusterLogsHandler
	// ManifestsDownloadClusterManifestHandler sets the operation handler for the download cluster manifest operation
	ManifestsDownloadClusterManifestHandler manifests.DownloadClusterManifestHandler
	// InstallerDownloadHostIgnitionHandler sets the operation handler for the download host ignition operation
	InstallerDownloadHostIgnitionHandler installer.DownloadHostIgnitionHandler
	// InstallerDownloadHostLogsHandler sets the operation handler for the download host logs operation
	InstallerDownloadHostLogsHandler installer.DownloadHostLogsHandler
	// AssistedServiceIsoDownloadISOHandler sets the operation handler for the download i s o operation
	AssistedServiceIsoDownloadISOHandler assisted_service_iso.DownloadISOHandler
	// InstallerDownloadInfraEnvDiscoveryImageHandler sets the operation handler for the download infra env discovery image operation
	InstallerDownloadInfraEnvDiscoveryImageHandler installer.DownloadInfraEnvDiscoveryImageHandler
	// InstallerDownloadInfraEnvDiscoveryImageHeadersHandler sets the operation handler for the download infra env discovery image headers operation
	InstallerDownloadInfraEnvDiscoveryImageHeadersHandler installer.DownloadInfraEnvDiscoveryImageHeadersHandler
	// InstallerDownloadMinimalInitrdHandler sets the operation handler for the download minimal initrd operation
	InstallerDownloadMinimalInitrdHandler installer.DownloadMinimalInitrdHandler
	// InstallerEnableHostHandler sets the operation handler for the enable host operation
	InstallerEnableHostHandler installer.EnableHostHandler
	// InstallerGenerateClusterISOHandler sets the operation handler for the generate cluster i s o operation
	InstallerGenerateClusterISOHandler installer.GenerateClusterISOHandler
	// InstallerGetClusterHandler sets the operation handler for the get cluster operation
	InstallerGetClusterHandler installer.GetClusterHandler
	// InstallerGetClusterDefaultConfigHandler sets the operation handler for the get cluster default config operation
	InstallerGetClusterDefaultConfigHandler installer.GetClusterDefaultConfigHandler
	// InstallerGetClusterHostRequirementsHandler sets the operation handler for the get cluster host requirements operation
	InstallerGetClusterHostRequirementsHandler installer.GetClusterHostRequirementsHandler
	// InstallerGetClusterInstallConfigHandler sets the operation handler for the get cluster install config operation
	InstallerGetClusterInstallConfigHandler installer.GetClusterInstallConfigHandler
	// InstallerGetClusterSupportedPlatformsHandler sets the operation handler for the get cluster supported platforms operation
	InstallerGetClusterSupportedPlatformsHandler installer.GetClusterSupportedPlatformsHandler
	// InstallerGetCredentialsHandler sets the operation handler for the get credentials operation
	InstallerGetCredentialsHandler installer.GetCredentialsHandler
	// InstallerGetDiscoveryIgnitionHandler sets the operation handler for the get discovery ignition operation
	InstallerGetDiscoveryIgnitionHandler installer.GetDiscoveryIgnitionHandler
	// InstallerGetFreeAddressesHandler sets the operation handler for the get free addresses operation
	InstallerGetFreeAddressesHandler installer.GetFreeAddressesHandler
	// InstallerGetHostHandler sets the operation handler for the get host operation
	InstallerGetHostHandler installer.GetHostHandler
	// InstallerGetHostIgnitionHandler sets the operation handler for the get host ignition operation
	InstallerGetHostIgnitionHandler installer.GetHostIgnitionHandler
	// InstallerGetInfraEnvHandler sets the operation handler for the get infra env operation
	InstallerGetInfraEnvHandler installer.GetInfraEnvHandler
	// InstallerGetPreflightRequirementsHandler sets the operation handler for the get preflight requirements operation
	InstallerGetPreflightRequirementsHandler installer.GetPreflightRequirementsHandler
	// AssistedServiceIsoGetPresignedForAssistedServiceISOHandler sets the operation handler for the get presigned for assisted service i s o operation
	AssistedServiceIsoGetPresignedForAssistedServiceISOHandler assisted_service_iso.GetPresignedForAssistedServiceISOHandler
	// InstallerGetPresignedForClusterFilesHandler sets the operation handler for the get presigned for cluster files operation
	InstallerGetPresignedForClusterFilesHandler installer.GetPresignedForClusterFilesHandler
	// InstallerInstallClusterHandler sets the operation handler for the install cluster operation
	InstallerInstallClusterHandler installer.InstallClusterHandler
	// InstallerInstallHostHandler sets the operation handler for the install host operation
	InstallerInstallHostHandler installer.InstallHostHandler
	// InstallerInstallHostsHandler sets the operation handler for the install hosts operation
	InstallerInstallHostsHandler installer.InstallHostsHandler
	// ManifestsListClusterManifestsHandler sets the operation handler for the list cluster manifests operation
	ManifestsListClusterManifestsHandler manifests.ListClusterManifestsHandler
	// InstallerListClustersHandler sets the operation handler for the list clusters operation
	InstallerListClustersHandler installer.ListClustersHandler
	// VersionsListComponentVersionsHandler sets the operation handler for the list component versions operation
	VersionsListComponentVersionsHandler versions.ListComponentVersionsHandler
	// EventsListEventsHandler sets the operation handler for the list events operation
	EventsListEventsHandler events.ListEventsHandler
	// InstallerListHostsHandler sets the operation handler for the list hosts operation
	InstallerListHostsHandler installer.ListHostsHandler
	// InstallerListInfraEnvsHandler sets the operation handler for the list infra envs operation
	InstallerListInfraEnvsHandler installer.ListInfraEnvsHandler
	// ManagedDomainsListManagedDomainsHandler sets the operation handler for the list managed domains operation
	ManagedDomainsListManagedDomainsHandler managed_domains.ListManagedDomainsHandler
	// OperatorsListOfClusterOperatorsHandler sets the operation handler for the list of cluster operators operation
	OperatorsListOfClusterOperatorsHandler operators.ListOfClusterOperatorsHandler
	// OperatorsListOperatorPropertiesHandler sets the operation handler for the list operator properties operation
	OperatorsListOperatorPropertiesHandler operators.ListOperatorPropertiesHandler
	// VersionsListSupportedOpenshiftVersionsHandler sets the operation handler for the list supported openshift versions operation
	VersionsListSupportedOpenshiftVersionsHandler versions.ListSupportedOpenshiftVersionsHandler
	// OperatorsListSupportedOperatorsHandler sets the operation handler for the list supported operators operation
	OperatorsListSupportedOperatorsHandler operators.ListSupportedOperatorsHandler
	// InstallerRegisterAddHostsClusterHandler sets the operation handler for the register add hosts cluster operation
	InstallerRegisterAddHostsClusterHandler installer.RegisterAddHostsClusterHandler
	// InstallerRegisterClusterHandler sets the operation handler for the register cluster operation
	InstallerRegisterClusterHandler installer.RegisterClusterHandler
	// InstallerRegisterInfraEnvHandler sets the operation handler for the register infra env operation
	InstallerRegisterInfraEnvHandler installer.RegisterInfraEnvHandler
	// OperatorsReportMonitoredOperatorStatusHandler sets the operation handler for the report monitored operator status operation
	OperatorsReportMonitoredOperatorStatusHandler operators.ReportMonitoredOperatorStatusHandler
	// InstallerResetClusterHandler sets the operation handler for the reset cluster operation
	InstallerResetClusterHandler installer.ResetClusterHandler
	// InstallerResetHostHandler sets the operation handler for the reset host operation
	InstallerResetHostHandler installer.ResetHostHandler
	// InstallerResetHostValidationHandler sets the operation handler for the reset host validation operation
	InstallerResetHostValidationHandler installer.ResetHostValidationHandler
	// InstallerUnbindHostHandler sets the operation handler for the unbind host operation
	InstallerUnbindHostHandler installer.UnbindHostHandler
	// InstallerUpdateClusterHandler sets the operation handler for the update cluster operation
	InstallerUpdateClusterHandler installer.UpdateClusterHandler
	// InstallerUpdateClusterInstallConfigHandler sets the operation handler for the update cluster install config operation
	InstallerUpdateClusterInstallConfigHandler installer.UpdateClusterInstallConfigHandler
	// InstallerUpdateClusterLogsProgressHandler sets the operation handler for the update cluster logs progress operation
	InstallerUpdateClusterLogsProgressHandler installer.UpdateClusterLogsProgressHandler
	// InstallerUpdateDiscoveryIgnitionHandler sets the operation handler for the update discovery ignition operation
	InstallerUpdateDiscoveryIgnitionHandler installer.UpdateDiscoveryIgnitionHandler
	// InstallerUpdateHostIgnitionHandler sets the operation handler for the update host ignition operation
	InstallerUpdateHostIgnitionHandler installer.UpdateHostIgnitionHandler
	// InstallerUpdateHostInstallProgressHandler sets the operation handler for the update host install progress operation
	InstallerUpdateHostInstallProgressHandler installer.UpdateHostInstallProgressHandler
	// InstallerUpdateHostInstallerArgsHandler sets the operation handler for the update host installer args operation
	InstallerUpdateHostInstallerArgsHandler installer.UpdateHostInstallerArgsHandler
	// InstallerUpdateHostLogsProgressHandler sets the operation handler for the update host logs progress operation
	InstallerUpdateHostLogsProgressHandler installer.UpdateHostLogsProgressHandler
	// InstallerUpdateInfraEnvHandler sets the operation handler for the update infra env operation
	InstallerUpdateInfraEnvHandler installer.UpdateInfraEnvHandler
	// InstallerUploadClusterIngressCertHandler sets the operation handler for the upload cluster ingress cert operation
	InstallerUploadClusterIngressCertHandler installer.UploadClusterIngressCertHandler
	// InstallerUploadHostLogsHandler sets the operation handler for the upload host logs operation
	InstallerUploadHostLogsHandler installer.UploadHostLogsHandler
	// InstallerUploadLogsHandler sets the operation handler for the upload logs operation
	InstallerUploadLogsHandler installer.UploadLogsHandler
	// InstallerV2CancelInstallationHandler sets the operation handler for the v2 cancel installation operation
	InstallerV2CancelInstallationHandler installer.V2CancelInstallationHandler
	// ManifestsV2CreateClusterManifestHandler sets the operation handler for the v2 create cluster manifest operation
	ManifestsV2CreateClusterManifestHandler manifests.V2CreateClusterManifestHandler
	// ManifestsV2DeleteClusterManifestHandler sets the operation handler for the v2 delete cluster manifest operation
	ManifestsV2DeleteClusterManifestHandler manifests.V2DeleteClusterManifestHandler
	// InstallerV2DownloadClusterCredentialsHandler sets the operation handler for the v2 download cluster credentials operation
	InstallerV2DownloadClusterCredentialsHandler installer.V2DownloadClusterCredentialsHandler
	// InstallerV2DownloadClusterFilesHandler sets the operation handler for the v2 download cluster files operation
	InstallerV2DownloadClusterFilesHandler installer.V2DownloadClusterFilesHandler
	// InstallerV2DownloadClusterLogsHandler sets the operation handler for the v2 download cluster logs operation
	InstallerV2DownloadClusterLogsHandler installer.V2DownloadClusterLogsHandler
	// InstallerV2GetClusterDefaultConfigHandler sets the operation handler for the v2 get cluster default config operation
	InstallerV2GetClusterDefaultConfigHandler installer.V2GetClusterDefaultConfigHandler
	// InstallerV2GetCredentialsHandler sets the operation handler for the v2 get credentials operation
	InstallerV2GetCredentialsHandler installer.V2GetCredentialsHandler
	// InstallerV2GetPresignedForClusterFilesHandler sets the operation handler for the v2 get presigned for cluster files operation
	InstallerV2GetPresignedForClusterFilesHandler installer.V2GetPresignedForClusterFilesHandler
	// ManifestsV2ListClusterManifestsHandler sets the operation handler for the v2 list cluster manifests operation
	ManifestsV2ListClusterManifestsHandler manifests.V2ListClusterManifestsHandler
	// ManagedDomainsV2ListManagedDomainsHandler sets the operation handler for the v2 list managed domains operation
	ManagedDomainsV2ListManagedDomainsHandler managed_domains.V2ListManagedDomainsHandler
	// OperatorsV2ListOfClusterOperatorsHandler sets the operation handler for the v2 list of cluster operators operation
	OperatorsV2ListOfClusterOperatorsHandler operators.V2ListOfClusterOperatorsHandler
	// OperatorsV2ListOperatorPropertiesHandler sets the operation handler for the v2 list operator properties operation
	OperatorsV2ListOperatorPropertiesHandler operators.V2ListOperatorPropertiesHandler
	// OperatorsV2ListSupportedOperatorsHandler sets the operation handler for the v2 list supported operators operation
	OperatorsV2ListSupportedOperatorsHandler operators.V2ListSupportedOperatorsHandler
	// InstallerV2UpdateClusterHandler sets the operation handler for the v2 update cluster operation
	InstallerV2UpdateClusterHandler installer.V2UpdateClusterHandler
	// InstallerV2UploadLogsHandler sets the operation handler for the v2 upload logs operation
	InstallerV2UploadLogsHandler installer.V2UploadLogsHandler
	// InstallerV2CompleteInstallationHandler sets the operation handler for the v2 complete installation operation
	InstallerV2CompleteInstallationHandler installer.V2CompleteInstallationHandler
	// InstallerV2DeregisterClusterHandler sets the operation handler for the v2 deregister cluster operation
	InstallerV2DeregisterClusterHandler installer.V2DeregisterClusterHandler
	// InstallerV2DeregisterHostHandler sets the operation handler for the v2 deregister host operation
	InstallerV2DeregisterHostHandler installer.V2DeregisterHostHandler
	// ManifestsV2DownloadClusterManifestHandler sets the operation handler for the v2 download cluster manifest operation
	ManifestsV2DownloadClusterManifestHandler manifests.V2DownloadClusterManifestHandler
	// InstallerV2DownloadHostIgnitionHandler sets the operation handler for the v2 download host ignition operation
	InstallerV2DownloadHostIgnitionHandler installer.V2DownloadHostIgnitionHandler
	// InstallerV2DownloadInfraEnvFilesHandler sets the operation handler for the v2 download infra env files operation
	InstallerV2DownloadInfraEnvFilesHandler installer.V2DownloadInfraEnvFilesHandler
	// InstallerV2GetClusterHandler sets the operation handler for the v2 get cluster operation
	InstallerV2GetClusterHandler installer.V2GetClusterHandler
	// InstallerV2GetClusterInstallConfigHandler sets the operation handler for the v2 get cluster install config operation
	InstallerV2GetClusterInstallConfigHandler installer.V2GetClusterInstallConfigHandler
	// InstallerV2GetHostHandler sets the operation handler for the v2 get host operation
	InstallerV2GetHostHandler installer.V2GetHostHandler
	// InstallerV2GetHostIgnitionHandler sets the operation handler for the v2 get host ignition operation
	InstallerV2GetHostIgnitionHandler installer.V2GetHostIgnitionHandler
	// InstallerV2GetNextStepsHandler sets the operation handler for the v2 get next steps operation
	InstallerV2GetNextStepsHandler installer.V2GetNextStepsHandler
	// InstallerV2GetPreflightRequirementsHandler sets the operation handler for the v2 get preflight requirements operation
	InstallerV2GetPreflightRequirementsHandler installer.V2GetPreflightRequirementsHandler
	// InstallerV2InstallClusterHandler sets the operation handler for the v2 install cluster operation
	InstallerV2InstallClusterHandler installer.V2InstallClusterHandler
	// InstallerV2InstallHostHandler sets the operation handler for the v2 install host operation
	InstallerV2InstallHostHandler installer.V2InstallHostHandler
	// InstallerV2ListClustersHandler sets the operation handler for the v2 list clusters operation
	InstallerV2ListClustersHandler installer.V2ListClustersHandler
	// VersionsV2ListComponentVersionsHandler sets the operation handler for the v2 list component versions operation
	VersionsV2ListComponentVersionsHandler versions.V2ListComponentVersionsHandler
	// InstallerV2ListHostsHandler sets the operation handler for the v2 list hosts operation
	InstallerV2ListHostsHandler installer.V2ListHostsHandler
	// VersionsV2ListSupportedOpenshiftVersionsHandler sets the operation handler for the v2 list supported openshift versions operation
	VersionsV2ListSupportedOpenshiftVersionsHandler versions.V2ListSupportedOpenshiftVersionsHandler
	// InstallerV2PostStepReplyHandler sets the operation handler for the v2 post step reply operation
	InstallerV2PostStepReplyHandler installer.V2PostStepReplyHandler
	// InstallerV2RegisterClusterHandler sets the operation handler for the v2 register cluster operation
	InstallerV2RegisterClusterHandler installer.V2RegisterClusterHandler
	// InstallerV2RegisterHostHandler sets the operation handler for the v2 register host operation
	InstallerV2RegisterHostHandler installer.V2RegisterHostHandler
	// OperatorsV2ReportMonitoredOperatorStatusHandler sets the operation handler for the v2 report monitored operator status operation
	OperatorsV2ReportMonitoredOperatorStatusHandler operators.V2ReportMonitoredOperatorStatusHandler
	// InstallerV2ResetClusterHandler sets the operation handler for the v2 reset cluster operation
	InstallerV2ResetClusterHandler installer.V2ResetClusterHandler
	// InstallerV2ResetHostHandler sets the operation handler for the v2 reset host operation
	InstallerV2ResetHostHandler installer.V2ResetHostHandler
	// InstallerV2ResetHostValidationHandler sets the operation handler for the v2 reset host validation operation
	InstallerV2ResetHostValidationHandler installer.V2ResetHostValidationHandler
	// InstallerV2UpdateClusterInstallConfigHandler sets the operation handler for the v2 update cluster install config operation
	InstallerV2UpdateClusterInstallConfigHandler installer.V2UpdateClusterInstallConfigHandler
	// InstallerV2UpdateClusterLogsProgressHandler sets the operation handler for the v2 update cluster logs progress operation
	InstallerV2UpdateClusterLogsProgressHandler installer.V2UpdateClusterLogsProgressHandler
	// InstallerV2UpdateHostHandler sets the operation handler for the v2 update host operation
	InstallerV2UpdateHostHandler installer.V2UpdateHostHandler
	// InstallerV2UpdateHostIgnitionHandler sets the operation handler for the v2 update host ignition operation
	InstallerV2UpdateHostIgnitionHandler installer.V2UpdateHostIgnitionHandler
	// InstallerV2UpdateHostInstallProgressHandler sets the operation handler for the v2 update host install progress operation
	InstallerV2UpdateHostInstallProgressHandler installer.V2UpdateHostInstallProgressHandler
	// InstallerV2UpdateHostInstallerArgsHandler sets the operation handler for the v2 update host installer args operation
	InstallerV2UpdateHostInstallerArgsHandler installer.V2UpdateHostInstallerArgsHandler
	// InstallerV2UpdateHostLogsProgressHandler sets the operation handler for the v2 update host logs progress operation
	InstallerV2UpdateHostLogsProgressHandler installer.V2UpdateHostLogsProgressHandler
	// InstallerV2UploadClusterIngressCertHandler sets the operation handler for the v2 upload cluster ingress cert operation
	InstallerV2UploadClusterIngressCertHandler installer.V2UploadClusterIngressCertHandler
	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// PreServerShutdown is called before the HTTP(S) server is shutdown
	// This allows for custom functions to get executed before the HTTP(S) server stops accepting traffic
	PreServerShutdown func()

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// UseRedoc for documentation at /docs
func (o *AssistedInstallAPI) UseRedoc() {
	o.useSwaggerUI = false
}

// UseSwaggerUI for documentation at /docs
func (o *AssistedInstallAPI) UseSwaggerUI() {
	o.useSwaggerUI = true
}

// SetDefaultProduces sets the default produces media type
func (o *AssistedInstallAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *AssistedInstallAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *AssistedInstallAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *AssistedInstallAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *AssistedInstallAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *AssistedInstallAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *AssistedInstallAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the AssistedInstallAPI
func (o *AssistedInstallAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}
	if o.MultipartformConsumer == nil {
		unregistered = append(unregistered, "MultipartformConsumer")
	}

	if o.BinProducer == nil {
		unregistered = append(unregistered, "BinProducer")
	}
	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.AgentAuthAuth == nil {
		unregistered = append(unregistered, "XSecretKeyAuth")
	}
	if o.URLAuthAuth == nil {
		unregistered = append(unregistered, "APIKeyAuth")
	}
	if o.UserAuthAuth == nil {
		unregistered = append(unregistered, "AuthorizationAuth")
	}

	if o.InstallerBindHostHandler == nil {
		unregistered = append(unregistered, "installer.BindHostHandler")
	}
	if o.InstallerCancelInstallationHandler == nil {
		unregistered = append(unregistered, "installer.CancelInstallationHandler")
	}
	if o.InstallerCompleteInstallationHandler == nil {
		unregistered = append(unregistered, "installer.CompleteInstallationHandler")
	}
	if o.ManifestsCreateClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.CreateClusterManifestHandler")
	}
	if o.AssistedServiceIsoCreateISOAndUploadToS3Handler == nil {
		unregistered = append(unregistered, "assisted_service_iso.CreateISOAndUploadToS3Handler")
	}
	if o.ManifestsDeleteClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.DeleteClusterManifestHandler")
	}
	if o.InstallerDeregisterClusterHandler == nil {
		unregistered = append(unregistered, "installer.DeregisterClusterHandler")
	}
	if o.InstallerDeregisterHostHandler == nil {
		unregistered = append(unregistered, "installer.DeregisterHostHandler")
	}
	if o.InstallerDeregisterInfraEnvHandler == nil {
		unregistered = append(unregistered, "installer.DeregisterInfraEnvHandler")
	}
	if o.InstallerDisableHostHandler == nil {
		unregistered = append(unregistered, "installer.DisableHostHandler")
	}
	if o.InstallerDownloadClusterFilesHandler == nil {
		unregistered = append(unregistered, "installer.DownloadClusterFilesHandler")
	}
	if o.InstallerDownloadClusterISOHandler == nil {
		unregistered = append(unregistered, "installer.DownloadClusterISOHandler")
	}
	if o.InstallerDownloadClusterISOHeadersHandler == nil {
		unregistered = append(unregistered, "installer.DownloadClusterISOHeadersHandler")
	}
	if o.InstallerDownloadClusterKubeconfigHandler == nil {
		unregistered = append(unregistered, "installer.DownloadClusterKubeconfigHandler")
	}
	if o.InstallerDownloadClusterLogsHandler == nil {
		unregistered = append(unregistered, "installer.DownloadClusterLogsHandler")
	}
	if o.ManifestsDownloadClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.DownloadClusterManifestHandler")
	}
	if o.InstallerDownloadHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.DownloadHostIgnitionHandler")
	}
	if o.InstallerDownloadHostLogsHandler == nil {
		unregistered = append(unregistered, "installer.DownloadHostLogsHandler")
	}
	if o.AssistedServiceIsoDownloadISOHandler == nil {
		unregistered = append(unregistered, "assisted_service_iso.DownloadISOHandler")
	}
	if o.InstallerDownloadInfraEnvDiscoveryImageHandler == nil {
		unregistered = append(unregistered, "installer.DownloadInfraEnvDiscoveryImageHandler")
	}
	if o.InstallerDownloadInfraEnvDiscoveryImageHeadersHandler == nil {
		unregistered = append(unregistered, "installer.DownloadInfraEnvDiscoveryImageHeadersHandler")
	}
	if o.InstallerDownloadMinimalInitrdHandler == nil {
		unregistered = append(unregistered, "installer.DownloadMinimalInitrdHandler")
	}
	if o.InstallerEnableHostHandler == nil {
		unregistered = append(unregistered, "installer.EnableHostHandler")
	}
	if o.InstallerGenerateClusterISOHandler == nil {
		unregistered = append(unregistered, "installer.GenerateClusterISOHandler")
	}
	if o.InstallerGetClusterHandler == nil {
		unregistered = append(unregistered, "installer.GetClusterHandler")
	}
	if o.InstallerGetClusterDefaultConfigHandler == nil {
		unregistered = append(unregistered, "installer.GetClusterDefaultConfigHandler")
	}
	if o.InstallerGetClusterHostRequirementsHandler == nil {
		unregistered = append(unregistered, "installer.GetClusterHostRequirementsHandler")
	}
	if o.InstallerGetClusterInstallConfigHandler == nil {
		unregistered = append(unregistered, "installer.GetClusterInstallConfigHandler")
	}
	if o.InstallerGetClusterSupportedPlatformsHandler == nil {
		unregistered = append(unregistered, "installer.GetClusterSupportedPlatformsHandler")
	}
	if o.InstallerGetCredentialsHandler == nil {
		unregistered = append(unregistered, "installer.GetCredentialsHandler")
	}
	if o.InstallerGetDiscoveryIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.GetDiscoveryIgnitionHandler")
	}
	if o.InstallerGetFreeAddressesHandler == nil {
		unregistered = append(unregistered, "installer.GetFreeAddressesHandler")
	}
	if o.InstallerGetHostHandler == nil {
		unregistered = append(unregistered, "installer.GetHostHandler")
	}
	if o.InstallerGetHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.GetHostIgnitionHandler")
	}
	if o.InstallerGetInfraEnvHandler == nil {
		unregistered = append(unregistered, "installer.GetInfraEnvHandler")
	}
	if o.InstallerGetPreflightRequirementsHandler == nil {
		unregistered = append(unregistered, "installer.GetPreflightRequirementsHandler")
	}
	if o.AssistedServiceIsoGetPresignedForAssistedServiceISOHandler == nil {
		unregistered = append(unregistered, "assisted_service_iso.GetPresignedForAssistedServiceISOHandler")
	}
	if o.InstallerGetPresignedForClusterFilesHandler == nil {
		unregistered = append(unregistered, "installer.GetPresignedForClusterFilesHandler")
	}
	if o.InstallerInstallClusterHandler == nil {
		unregistered = append(unregistered, "installer.InstallClusterHandler")
	}
	if o.InstallerInstallHostHandler == nil {
		unregistered = append(unregistered, "installer.InstallHostHandler")
	}
	if o.InstallerInstallHostsHandler == nil {
		unregistered = append(unregistered, "installer.InstallHostsHandler")
	}
	if o.ManifestsListClusterManifestsHandler == nil {
		unregistered = append(unregistered, "manifests.ListClusterManifestsHandler")
	}
	if o.InstallerListClustersHandler == nil {
		unregistered = append(unregistered, "installer.ListClustersHandler")
	}
	if o.VersionsListComponentVersionsHandler == nil {
		unregistered = append(unregistered, "versions.ListComponentVersionsHandler")
	}
	if o.EventsListEventsHandler == nil {
		unregistered = append(unregistered, "events.ListEventsHandler")
	}
	if o.InstallerListHostsHandler == nil {
		unregistered = append(unregistered, "installer.ListHostsHandler")
	}
	if o.InstallerListInfraEnvsHandler == nil {
		unregistered = append(unregistered, "installer.ListInfraEnvsHandler")
	}
	if o.ManagedDomainsListManagedDomainsHandler == nil {
		unregistered = append(unregistered, "managed_domains.ListManagedDomainsHandler")
	}
	if o.OperatorsListOfClusterOperatorsHandler == nil {
		unregistered = append(unregistered, "operators.ListOfClusterOperatorsHandler")
	}
	if o.OperatorsListOperatorPropertiesHandler == nil {
		unregistered = append(unregistered, "operators.ListOperatorPropertiesHandler")
	}
	if o.VersionsListSupportedOpenshiftVersionsHandler == nil {
		unregistered = append(unregistered, "versions.ListSupportedOpenshiftVersionsHandler")
	}
	if o.OperatorsListSupportedOperatorsHandler == nil {
		unregistered = append(unregistered, "operators.ListSupportedOperatorsHandler")
	}
	if o.InstallerRegisterAddHostsClusterHandler == nil {
		unregistered = append(unregistered, "installer.RegisterAddHostsClusterHandler")
	}
	if o.InstallerRegisterClusterHandler == nil {
		unregistered = append(unregistered, "installer.RegisterClusterHandler")
	}
	if o.InstallerRegisterInfraEnvHandler == nil {
		unregistered = append(unregistered, "installer.RegisterInfraEnvHandler")
	}
	if o.OperatorsReportMonitoredOperatorStatusHandler == nil {
		unregistered = append(unregistered, "operators.ReportMonitoredOperatorStatusHandler")
	}
	if o.InstallerResetClusterHandler == nil {
		unregistered = append(unregistered, "installer.ResetClusterHandler")
	}
	if o.InstallerResetHostHandler == nil {
		unregistered = append(unregistered, "installer.ResetHostHandler")
	}
	if o.InstallerResetHostValidationHandler == nil {
		unregistered = append(unregistered, "installer.ResetHostValidationHandler")
	}
	if o.InstallerUnbindHostHandler == nil {
		unregistered = append(unregistered, "installer.UnbindHostHandler")
	}
	if o.InstallerUpdateClusterHandler == nil {
		unregistered = append(unregistered, "installer.UpdateClusterHandler")
	}
	if o.InstallerUpdateClusterInstallConfigHandler == nil {
		unregistered = append(unregistered, "installer.UpdateClusterInstallConfigHandler")
	}
	if o.InstallerUpdateClusterLogsProgressHandler == nil {
		unregistered = append(unregistered, "installer.UpdateClusterLogsProgressHandler")
	}
	if o.InstallerUpdateDiscoveryIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.UpdateDiscoveryIgnitionHandler")
	}
	if o.InstallerUpdateHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.UpdateHostIgnitionHandler")
	}
	if o.InstallerUpdateHostInstallProgressHandler == nil {
		unregistered = append(unregistered, "installer.UpdateHostInstallProgressHandler")
	}
	if o.InstallerUpdateHostInstallerArgsHandler == nil {
		unregistered = append(unregistered, "installer.UpdateHostInstallerArgsHandler")
	}
	if o.InstallerUpdateHostLogsProgressHandler == nil {
		unregistered = append(unregistered, "installer.UpdateHostLogsProgressHandler")
	}
	if o.InstallerUpdateInfraEnvHandler == nil {
		unregistered = append(unregistered, "installer.UpdateInfraEnvHandler")
	}
	if o.InstallerUploadClusterIngressCertHandler == nil {
		unregistered = append(unregistered, "installer.UploadClusterIngressCertHandler")
	}
	if o.InstallerUploadHostLogsHandler == nil {
		unregistered = append(unregistered, "installer.UploadHostLogsHandler")
	}
	if o.InstallerUploadLogsHandler == nil {
		unregistered = append(unregistered, "installer.UploadLogsHandler")
	}
	if o.InstallerV2CancelInstallationHandler == nil {
		unregistered = append(unregistered, "installer.V2CancelInstallationHandler")
	}
	if o.ManifestsV2CreateClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.V2CreateClusterManifestHandler")
	}
	if o.ManifestsV2DeleteClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.V2DeleteClusterManifestHandler")
	}
	if o.InstallerV2DownloadClusterCredentialsHandler == nil {
		unregistered = append(unregistered, "installer.V2DownloadClusterCredentialsHandler")
	}
	if o.InstallerV2DownloadClusterFilesHandler == nil {
		unregistered = append(unregistered, "installer.V2DownloadClusterFilesHandler")
	}
	if o.InstallerV2DownloadClusterLogsHandler == nil {
		unregistered = append(unregistered, "installer.V2DownloadClusterLogsHandler")
	}
	if o.InstallerV2GetClusterDefaultConfigHandler == nil {
		unregistered = append(unregistered, "installer.V2GetClusterDefaultConfigHandler")
	}
	if o.InstallerV2GetCredentialsHandler == nil {
		unregistered = append(unregistered, "installer.V2GetCredentialsHandler")
	}
	if o.InstallerV2GetPresignedForClusterFilesHandler == nil {
		unregistered = append(unregistered, "installer.V2GetPresignedForClusterFilesHandler")
	}
	if o.ManifestsV2ListClusterManifestsHandler == nil {
		unregistered = append(unregistered, "manifests.V2ListClusterManifestsHandler")
	}
	if o.ManagedDomainsV2ListManagedDomainsHandler == nil {
		unregistered = append(unregistered, "managed_domains.V2ListManagedDomainsHandler")
	}
	if o.OperatorsV2ListOfClusterOperatorsHandler == nil {
		unregistered = append(unregistered, "operators.V2ListOfClusterOperatorsHandler")
	}
	if o.OperatorsV2ListOperatorPropertiesHandler == nil {
		unregistered = append(unregistered, "operators.V2ListOperatorPropertiesHandler")
	}
	if o.OperatorsV2ListSupportedOperatorsHandler == nil {
		unregistered = append(unregistered, "operators.V2ListSupportedOperatorsHandler")
	}
	if o.InstallerV2UpdateClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateClusterHandler")
	}
	if o.InstallerV2UploadLogsHandler == nil {
		unregistered = append(unregistered, "installer.V2UploadLogsHandler")
	}
	if o.InstallerV2CompleteInstallationHandler == nil {
		unregistered = append(unregistered, "installer.V2CompleteInstallationHandler")
	}
	if o.InstallerV2DeregisterClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2DeregisterClusterHandler")
	}
	if o.InstallerV2DeregisterHostHandler == nil {
		unregistered = append(unregistered, "installer.V2DeregisterHostHandler")
	}
	if o.ManifestsV2DownloadClusterManifestHandler == nil {
		unregistered = append(unregistered, "manifests.V2DownloadClusterManifestHandler")
	}
	if o.InstallerV2DownloadHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.V2DownloadHostIgnitionHandler")
	}
	if o.InstallerV2DownloadInfraEnvFilesHandler == nil {
		unregistered = append(unregistered, "installer.V2DownloadInfraEnvFilesHandler")
	}
	if o.InstallerV2GetClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2GetClusterHandler")
	}
	if o.InstallerV2GetClusterInstallConfigHandler == nil {
		unregistered = append(unregistered, "installer.V2GetClusterInstallConfigHandler")
	}
	if o.InstallerV2GetHostHandler == nil {
		unregistered = append(unregistered, "installer.V2GetHostHandler")
	}
	if o.InstallerV2GetHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.V2GetHostIgnitionHandler")
	}
	if o.InstallerV2GetNextStepsHandler == nil {
		unregistered = append(unregistered, "installer.V2GetNextStepsHandler")
	}
	if o.InstallerV2GetPreflightRequirementsHandler == nil {
		unregistered = append(unregistered, "installer.V2GetPreflightRequirementsHandler")
	}
	if o.InstallerV2InstallClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2InstallClusterHandler")
	}
	if o.InstallerV2InstallHostHandler == nil {
		unregistered = append(unregistered, "installer.V2InstallHostHandler")
	}
	if o.InstallerV2ListClustersHandler == nil {
		unregistered = append(unregistered, "installer.V2ListClustersHandler")
	}
	if o.VersionsV2ListComponentVersionsHandler == nil {
		unregistered = append(unregistered, "versions.V2ListComponentVersionsHandler")
	}
	if o.InstallerV2ListHostsHandler == nil {
		unregistered = append(unregistered, "installer.V2ListHostsHandler")
	}
	if o.VersionsV2ListSupportedOpenshiftVersionsHandler == nil {
		unregistered = append(unregistered, "versions.V2ListSupportedOpenshiftVersionsHandler")
	}
	if o.InstallerV2PostStepReplyHandler == nil {
		unregistered = append(unregistered, "installer.V2PostStepReplyHandler")
	}
	if o.InstallerV2RegisterClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2RegisterClusterHandler")
	}
	if o.InstallerV2RegisterHostHandler == nil {
		unregistered = append(unregistered, "installer.V2RegisterHostHandler")
	}
	if o.OperatorsV2ReportMonitoredOperatorStatusHandler == nil {
		unregistered = append(unregistered, "operators.V2ReportMonitoredOperatorStatusHandler")
	}
	if o.InstallerV2ResetClusterHandler == nil {
		unregistered = append(unregistered, "installer.V2ResetClusterHandler")
	}
	if o.InstallerV2ResetHostHandler == nil {
		unregistered = append(unregistered, "installer.V2ResetHostHandler")
	}
	if o.InstallerV2ResetHostValidationHandler == nil {
		unregistered = append(unregistered, "installer.V2ResetHostValidationHandler")
	}
	if o.InstallerV2UpdateClusterInstallConfigHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateClusterInstallConfigHandler")
	}
	if o.InstallerV2UpdateClusterLogsProgressHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateClusterLogsProgressHandler")
	}
	if o.InstallerV2UpdateHostHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateHostHandler")
	}
	if o.InstallerV2UpdateHostIgnitionHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateHostIgnitionHandler")
	}
	if o.InstallerV2UpdateHostInstallProgressHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateHostInstallProgressHandler")
	}
	if o.InstallerV2UpdateHostInstallerArgsHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateHostInstallerArgsHandler")
	}
	if o.InstallerV2UpdateHostLogsProgressHandler == nil {
		unregistered = append(unregistered, "installer.V2UpdateHostLogsProgressHandler")
	}
	if o.InstallerV2UploadClusterIngressCertHandler == nil {
		unregistered = append(unregistered, "installer.V2UploadClusterIngressCertHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *AssistedInstallAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *AssistedInstallAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {
	result := make(map[string]runtime.Authenticator)
	for name := range schemes {
		switch name {
		case "agentAuth":
			scheme := schemes[name]
			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.AgentAuthAuth)

		case "urlAuth":
			scheme := schemes[name]
			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.URLAuthAuth)

		case "userAuth":
			scheme := schemes[name]
			result[name] = o.APIKeyAuthenticator(scheme.Name, scheme.In, o.UserAuthAuth)

		}
	}
	return result
}

// Authorizer returns the registered authorizer
func (o *AssistedInstallAPI) Authorizer() runtime.Authorizer {
	return o.APIAuthorizer
}

// ConsumersFor gets the consumers for the specified media types.
// MIME type parameters are ignored here.
func (o *AssistedInstallAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {
	result := make(map[string]runtime.Consumer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONConsumer
		case "multipart/form-data":
			result["multipart/form-data"] = o.MultipartformConsumer
		}

		if c, ok := o.customConsumers[mt]; ok {
			result[mt] = c
		}
	}
	return result
}

// ProducersFor gets the producers for the specified media types.
// MIME type parameters are ignored here.
func (o *AssistedInstallAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {
	result := make(map[string]runtime.Producer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/octet-stream":
			result["application/octet-stream"] = o.BinProducer
		case "application/json":
			result["application/json"] = o.JSONProducer
		}

		if p, ok := o.customProducers[mt]; ok {
			result[mt] = p
		}
	}
	return result
}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *AssistedInstallAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the assisted install API
func (o *AssistedInstallAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *AssistedInstallAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened
	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/bind"] = installer.NewBindHost(o.context, o.InstallerBindHostHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/actions/cancel"] = installer.NewCancelInstallation(o.context, o.InstallerCancelInstallationHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/actions/complete_installation"] = installer.NewCompleteInstallation(o.context, o.InstallerCompleteInstallationHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/manifests"] = manifests.NewCreateClusterManifest(o.context, o.ManifestsCreateClusterManifestHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/assisted-service-iso"] = assisted_service_iso.NewCreateISOAndUploadToS3(o.context, o.AssistedServiceIsoCreateISOAndUploadToS3Handler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/clusters/{cluster_id}/manifests"] = manifests.NewDeleteClusterManifest(o.context, o.ManifestsDeleteClusterManifestHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/clusters/{cluster_id}"] = installer.NewDeregisterCluster(o.context, o.InstallerDeregisterClusterHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/clusters/{cluster_id}/hosts/{host_id}"] = installer.NewDeregisterHost(o.context, o.InstallerDeregisterHostHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v2/infra-envs/{infra_env_id}"] = installer.NewDeregisterInfraEnv(o.context, o.InstallerDeregisterInfraEnvHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable"] = installer.NewDisableHost(o.context, o.InstallerDisableHostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/downloads/files"] = installer.NewDownloadClusterFiles(o.context, o.InstallerDownloadClusterFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/downloads/image"] = installer.NewDownloadClusterISO(o.context, o.InstallerDownloadClusterISOHandler)
	if o.handlers["HEAD"] == nil {
		o.handlers["HEAD"] = make(map[string]http.Handler)
	}
	o.handlers["HEAD"]["/v1/clusters/{cluster_id}/downloads/image"] = installer.NewDownloadClusterISOHeaders(o.context, o.InstallerDownloadClusterISOHeadersHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/downloads/kubeconfig"] = installer.NewDownloadClusterKubeconfig(o.context, o.InstallerDownloadClusterKubeconfigHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/logs"] = installer.NewDownloadClusterLogs(o.context, o.InstallerDownloadClusterLogsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/manifests/files"] = manifests.NewDownloadClusterManifest(o.context, o.ManifestsDownloadClusterManifestHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition"] = installer.NewDownloadHostIgnition(o.context, o.InstallerDownloadHostIgnitionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/hosts/{host_id}/logs"] = installer.NewDownloadHostLogs(o.context, o.InstallerDownloadHostLogsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/assisted-service-iso/data"] = assisted_service_iso.NewDownloadISO(o.context, o.AssistedServiceIsoDownloadISOHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/downloads/image"] = installer.NewDownloadInfraEnvDiscoveryImage(o.context, o.InstallerDownloadInfraEnvDiscoveryImageHandler)
	if o.handlers["HEAD"] == nil {
		o.handlers["HEAD"] = make(map[string]http.Handler)
	}
	o.handlers["HEAD"]["/v2/infra-envs/{infra_env_id}/downloads/image"] = installer.NewDownloadInfraEnvDiscoveryImageHeaders(o.context, o.InstallerDownloadInfraEnvDiscoveryImageHeadersHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/downloads/minimal-initrd"] = installer.NewDownloadMinimalInitrd(o.context, o.InstallerDownloadMinimalInitrdHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable"] = installer.NewEnableHost(o.context, o.InstallerEnableHostHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/downloads/image"] = installer.NewGenerateClusterISO(o.context, o.InstallerGenerateClusterISOHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}"] = installer.NewGetCluster(o.context, o.InstallerGetClusterHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/default-config"] = installer.NewGetClusterDefaultConfig(o.context, o.InstallerGetClusterDefaultConfigHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/host-requirements"] = installer.NewGetClusterHostRequirements(o.context, o.InstallerGetClusterHostRequirementsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/install-config"] = installer.NewGetClusterInstallConfig(o.context, o.InstallerGetClusterInstallConfigHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/supported-platforms"] = installer.NewGetClusterSupportedPlatforms(o.context, o.InstallerGetClusterSupportedPlatformsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/credentials"] = installer.NewGetCredentials(o.context, o.InstallerGetCredentialsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/discovery-ignition"] = installer.NewGetDiscoveryIgnition(o.context, o.InstallerGetDiscoveryIgnitionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/free_addresses"] = installer.NewGetFreeAddresses(o.context, o.InstallerGetFreeAddressesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/hosts/{host_id}"] = installer.NewGetHost(o.context, o.InstallerGetHostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/hosts/{host_id}/ignition"] = installer.NewGetHostIgnition(o.context, o.InstallerGetHostIgnitionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}"] = installer.NewGetInfraEnv(o.context, o.InstallerGetInfraEnvHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/preflight-requirements"] = installer.NewGetPreflightRequirements(o.context, o.InstallerGetPreflightRequirementsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/assisted-service-iso/presigned"] = assisted_service_iso.NewGetPresignedForAssistedServiceISO(o.context, o.AssistedServiceIsoGetPresignedForAssistedServiceISOHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/downloads/files-presigned"] = installer.NewGetPresignedForClusterFiles(o.context, o.InstallerGetPresignedForClusterFilesHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/actions/install"] = installer.NewInstallCluster(o.context, o.InstallerInstallClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install"] = installer.NewInstallHost(o.context, o.InstallerInstallHostHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/actions/install_hosts"] = installer.NewInstallHosts(o.context, o.InstallerInstallHostsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/manifests"] = manifests.NewListClusterManifests(o.context, o.ManifestsListClusterManifestsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters"] = installer.NewListClusters(o.context, o.InstallerListClustersHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/component_versions"] = versions.NewListComponentVersions(o.context, o.VersionsListComponentVersionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/events"] = events.NewListEvents(o.context, o.EventsListEventsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/hosts"] = installer.NewListHosts(o.context, o.InstallerListHostsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs"] = installer.NewListInfraEnvs(o.context, o.InstallerListInfraEnvsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/domains"] = managed_domains.NewListManagedDomains(o.context, o.ManagedDomainsListManagedDomainsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/clusters/{cluster_id}/monitored_operators"] = operators.NewListOfClusterOperators(o.context, o.OperatorsListOfClusterOperatorsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/supported-operators/{operator_name}"] = operators.NewListOperatorProperties(o.context, o.OperatorsListOperatorPropertiesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/openshift_versions"] = versions.NewListSupportedOpenshiftVersions(o.context, o.VersionsListSupportedOpenshiftVersionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v1/supported-operators"] = operators.NewListSupportedOperators(o.context, o.OperatorsListSupportedOperatorsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/add_hosts_clusters"] = installer.NewRegisterAddHostsCluster(o.context, o.InstallerRegisterAddHostsClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters"] = installer.NewRegisterCluster(o.context, o.InstallerRegisterClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs"] = installer.NewRegisterInfraEnv(o.context, o.InstallerRegisterInfraEnvHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v1/clusters/{cluster_id}/monitored_operators"] = operators.NewReportMonitoredOperatorStatus(o.context, o.OperatorsReportMonitoredOperatorStatusHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/actions/reset"] = installer.NewResetCluster(o.context, o.InstallerResetClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset"] = installer.NewResetHost(o.context, o.InstallerResetHostHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}"] = installer.NewResetHostValidation(o.context, o.InstallerResetHostValidationHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind"] = installer.NewUnbindHost(o.context, o.InstallerUnbindHostHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}"] = installer.NewUpdateCluster(o.context, o.InstallerUpdateClusterHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}/install-config"] = installer.NewUpdateClusterInstallConfig(o.context, o.InstallerUpdateClusterInstallConfigHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v1/clusters/{cluster_id}/logs_progress"] = installer.NewUpdateClusterLogsProgress(o.context, o.InstallerUpdateClusterLogsProgressHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}/discovery-ignition"] = installer.NewUpdateDiscoveryIgnition(o.context, o.InstallerUpdateDiscoveryIgnitionHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}/hosts/{host_id}/ignition"] = installer.NewUpdateHostIgnition(o.context, o.InstallerUpdateHostIgnitionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v1/clusters/{cluster_id}/hosts/{host_id}/progress"] = installer.NewUpdateHostInstallProgress(o.context, o.InstallerUpdateHostInstallProgressHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args"] = installer.NewUpdateHostInstallerArgs(o.context, o.InstallerUpdateHostInstallerArgsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress"] = installer.NewUpdateHostLogsProgress(o.context, o.InstallerUpdateHostLogsProgressHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/infra-envs/{infra_env_id}"] = installer.NewUpdateInfraEnv(o.context, o.InstallerUpdateInfraEnvHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/uploads/ingress-cert"] = installer.NewUploadClusterIngressCert(o.context, o.InstallerUploadClusterIngressCertHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/hosts/{host_id}/logs"] = installer.NewUploadHostLogs(o.context, o.InstallerUploadHostLogsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v1/clusters/{cluster_id}/logs"] = installer.NewUploadLogs(o.context, o.InstallerUploadLogsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/actions/cancel"] = installer.NewV2CancelInstallation(o.context, o.InstallerV2CancelInstallationHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/manifests"] = manifests.NewV2CreateClusterManifest(o.context, o.ManifestsV2CreateClusterManifestHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v2/clusters/{cluster_id}/manifests"] = manifests.NewV2DeleteClusterManifest(o.context, o.ManifestsV2DeleteClusterManifestHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/downloads/credentials"] = installer.NewV2DownloadClusterCredentials(o.context, o.InstallerV2DownloadClusterCredentialsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/downloads/files"] = installer.NewV2DownloadClusterFiles(o.context, o.InstallerV2DownloadClusterFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/logs"] = installer.NewV2DownloadClusterLogs(o.context, o.InstallerV2DownloadClusterLogsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/default-config"] = installer.NewV2GetClusterDefaultConfig(o.context, o.InstallerV2GetClusterDefaultConfigHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/credentials"] = installer.NewV2GetCredentials(o.context, o.InstallerV2GetCredentialsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/downloads/files-presigned"] = installer.NewV2GetPresignedForClusterFiles(o.context, o.InstallerV2GetPresignedForClusterFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/manifests"] = manifests.NewV2ListClusterManifests(o.context, o.ManifestsV2ListClusterManifestsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/domains"] = managed_domains.NewV2ListManagedDomains(o.context, o.ManagedDomainsV2ListManagedDomainsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/monitored-operators"] = operators.NewV2ListOfClusterOperators(o.context, o.OperatorsV2ListOfClusterOperatorsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/supported-operators/{operator_name}"] = operators.NewV2ListOperatorProperties(o.context, o.OperatorsV2ListOperatorPropertiesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/supported-operators"] = operators.NewV2ListSupportedOperators(o.context, o.OperatorsV2ListSupportedOperatorsHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/clusters/{cluster_id}"] = installer.NewV2UpdateCluster(o.context, o.InstallerV2UpdateClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/logs"] = installer.NewV2UploadLogs(o.context, o.InstallerV2UploadLogsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/actions/complete-installation"] = installer.NewV2CompleteInstallation(o.context, o.InstallerV2CompleteInstallationHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v2/clusters/{cluster_id}"] = installer.NewV2DeregisterCluster(o.context, o.InstallerV2DeregisterClusterHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}"] = installer.NewV2DeregisterHost(o.context, o.InstallerV2DeregisterHostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/manifests/files"] = manifests.NewV2DownloadClusterManifest(o.context, o.ManifestsV2DownloadClusterManifestHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-env/{infra_env_id}/hosts/{host_id}/downloads/ignition"] = installer.NewV2DownloadHostIgnition(o.context, o.InstallerV2DownloadHostIgnitionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/downloads/files"] = installer.NewV2DownloadInfraEnvFiles(o.context, o.InstallerV2DownloadInfraEnvFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}"] = installer.NewV2GetCluster(o.context, o.InstallerV2GetClusterHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/install-config"] = installer.NewV2GetClusterInstallConfig(o.context, o.InstallerV2GetClusterInstallConfigHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}"] = installer.NewV2GetHost(o.context, o.InstallerV2GetHostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition"] = installer.NewV2GetHostIgnition(o.context, o.InstallerV2GetHostIgnitionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions"] = installer.NewV2GetNextSteps(o.context, o.InstallerV2GetNextStepsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters/{cluster_id}/preflight-requirements"] = installer.NewV2GetPreflightRequirements(o.context, o.InstallerV2GetPreflightRequirementsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/actions/install"] = installer.NewV2InstallCluster(o.context, o.InstallerV2InstallClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/install"] = installer.NewV2InstallHost(o.context, o.InstallerV2InstallHostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/clusters"] = installer.NewV2ListClusters(o.context, o.InstallerV2ListClustersHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/component-versions"] = versions.NewV2ListComponentVersions(o.context, o.VersionsV2ListComponentVersionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/infra-envs/{infra_env_id}/hosts"] = installer.NewV2ListHosts(o.context, o.InstallerV2ListHostsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/v2/openshift-versions"] = versions.NewV2ListSupportedOpenshiftVersions(o.context, o.VersionsV2ListSupportedOpenshiftVersionsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions"] = installer.NewV2PostStepReply(o.context, o.InstallerV2PostStepReplyHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters"] = installer.NewV2RegisterCluster(o.context, o.InstallerV2RegisterClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts"] = installer.NewV2RegisterHost(o.context, o.InstallerV2RegisterHostHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v2/clusters/{cluster_id}/monitored-operators"] = operators.NewV2ReportMonitoredOperatorStatus(o.context, o.OperatorsV2ReportMonitoredOperatorStatusHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/actions/reset"] = installer.NewV2ResetCluster(o.context, o.InstallerV2ResetClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset"] = installer.NewV2ResetHost(o.context, o.InstallerV2ResetHostHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset-validation/{validation_id}"] = installer.NewV2ResetHostValidation(o.context, o.InstallerV2ResetHostValidationHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/clusters/{cluster_id}/install-config"] = installer.NewV2UpdateClusterInstallConfig(o.context, o.InstallerV2UpdateClusterInstallConfigHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v2/clusters/{cluster_id}/logs-progress"] = installer.NewV2UpdateClusterLogsProgress(o.context, o.InstallerV2UpdateClusterLogsProgressHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}"] = installer.NewV2UpdateHost(o.context, o.InstallerV2UpdateHostHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition"] = installer.NewV2UpdateHostIgnition(o.context, o.InstallerV2UpdateHostIgnitionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress"] = installer.NewV2UpdateHostInstallProgress(o.context, o.InstallerV2UpdateHostInstallProgressHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/installer-args"] = installer.NewV2UpdateHostInstallerArgs(o.context, o.InstallerV2UpdateHostInstallerArgsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/v2/infra-envs/{infra_env_id}/hosts/{host_id}/logs-progress"] = installer.NewV2UpdateHostLogsProgress(o.context, o.InstallerV2UpdateHostLogsProgressHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/v2/clusters/{cluster_id}/uploads/ingress-cert"] = installer.NewV2UploadClusterIngressCert(o.context, o.InstallerV2UploadClusterIngressCertHandler)
}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *AssistedInstallAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	if o.useSwaggerUI {
		return o.context.APIHandlerSwaggerUI(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middleware as you see fit
func (o *AssistedInstallAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}

// RegisterConsumer allows you to add (or override) a consumer for a media type.
func (o *AssistedInstallAPI) RegisterConsumer(mediaType string, consumer runtime.Consumer) {
	o.customConsumers[mediaType] = consumer
}

// RegisterProducer allows you to add (or override) a producer for a media type.
func (o *AssistedInstallAPI) RegisterProducer(mediaType string, producer runtime.Producer) {
	o.customProducers[mediaType] = producer
}

// AddMiddlewareFor adds a http middleware to existing handler
func (o *AssistedInstallAPI) AddMiddlewareFor(method, path string, builder middleware.Builder) {
	um := strings.ToUpper(method)
	if path == "/" {
		path = ""
	}
	o.Init()
	if h, ok := o.handlers[um][path]; ok {
		o.handlers[method][path] = builder(h)
	}
}
