// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewV2GetPresignedForClusterFilesParams creates a new V2GetPresignedForClusterFilesParams object
// no default values defined in spec.
func NewV2GetPresignedForClusterFilesParams() V2GetPresignedForClusterFilesParams {

	return V2GetPresignedForClusterFilesParams{}
}

// V2GetPresignedForClusterFilesParams contains all the bound params for the v2 get presigned for cluster files operation
// typically these are obtained from a http.Request
//
// swagger:parameters V2GetPresignedForClusterFiles
type V2GetPresignedForClusterFilesParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.
	  In: query
	*/
	AdditionalName *string
	/*The cluster that owns the file that should be downloaded.
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
	/*The file to be downloaded.
	  Required: true
	  In: query
	*/
	FileName string
	/*If downloading a file related to a host, the relevant host.
	  In: query
	*/
	HostID *strfmt.UUID
	/*If downloading logs, the type of logs to download.
	  In: query
	*/
	LogsType *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewV2GetPresignedForClusterFilesParams() beforehand.
func (o *V2GetPresignedForClusterFilesParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qAdditionalName, qhkAdditionalName, _ := qs.GetOK("additional_name")
	if err := o.bindAdditionalName(qAdditionalName, qhkAdditionalName, route.Formats); err != nil {
		res = append(res, err)
	}

	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	qFileName, qhkFileName, _ := qs.GetOK("file_name")
	if err := o.bindFileName(qFileName, qhkFileName, route.Formats); err != nil {
		res = append(res, err)
	}

	qHostID, qhkHostID, _ := qs.GetOK("host_id")
	if err := o.bindHostID(qHostID, qhkHostID, route.Formats); err != nil {
		res = append(res, err)
	}

	qLogsType, qhkLogsType, _ := qs.GetOK("logs_type")
	if err := o.bindLogsType(qLogsType, qhkLogsType, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindAdditionalName binds and validates parameter AdditionalName from query.
func (o *V2GetPresignedForClusterFilesParams) bindAdditionalName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false
	if raw == "" { // empty values pass all other validations
		return nil
	}

	o.AdditionalName = &raw

	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *V2GetPresignedForClusterFilesParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *V2GetPresignedForClusterFilesParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindFileName binds and validates parameter FileName from query.
func (o *V2GetPresignedForClusterFilesParams) bindFileName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("file_name", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false
	if err := validate.RequiredString("file_name", "query", raw); err != nil {
		return err
	}

	o.FileName = raw

	if err := o.validateFileName(formats); err != nil {
		return err
	}

	return nil
}

// validateFileName carries on validations for parameter FileName
func (o *V2GetPresignedForClusterFilesParams) validateFileName(formats strfmt.Registry) error {

	if err := validate.EnumCase("file_name", "query", o.FileName, []interface{}{"bootstrap.ign", "master.ign", "metadata.json", "worker.ign", "install-config.yaml", "logs", "manifests"}, true); err != nil {
		return err
	}

	return nil
}

// bindHostID binds and validates parameter HostID from query.
func (o *V2GetPresignedForClusterFilesParams) bindHostID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false
	if raw == "" { // empty values pass all other validations
		return nil
	}

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("host_id", "query", "strfmt.UUID", raw)
	}
	o.HostID = (value.(*strfmt.UUID))

	if err := o.validateHostID(formats); err != nil {
		return err
	}

	return nil
}

// validateHostID carries on validations for parameter HostID
func (o *V2GetPresignedForClusterFilesParams) validateHostID(formats strfmt.Registry) error {

	if err := validate.FormatOf("host_id", "query", "uuid", o.HostID.String(), formats); err != nil {
		return err
	}
	return nil
}

// bindLogsType binds and validates parameter LogsType from query.
func (o *V2GetPresignedForClusterFilesParams) bindLogsType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false
	if raw == "" { // empty values pass all other validations
		return nil
	}

	o.LogsType = &raw

	if err := o.validateLogsType(formats); err != nil {
		return err
	}

	return nil
}

// validateLogsType carries on validations for parameter LogsType
func (o *V2GetPresignedForClusterFilesParams) validateLogsType(formats strfmt.Registry) error {

	if err := validate.EnumCase("logs_type", "query", *o.LogsType, []interface{}{"host", "controller", "all"}, true); err != nil {
		return err
	}

	return nil
}
