// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"

	"github.com/openshift/assisted-service/models"
)

// NewV2CreateClusterManifestParams creates a new V2CreateClusterManifestParams object
// no default values defined in spec.
func NewV2CreateClusterManifestParams() V2CreateClusterManifestParams {

	return V2CreateClusterManifestParams{}
}

// V2CreateClusterManifestParams contains all the bound params for the v2 create cluster manifest operation
// typically these are obtained from a http.Request
//
// swagger:parameters V2CreateClusterManifest
type V2CreateClusterManifestParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The new manifest to create.
	  Required: true
	  In: body
	*/
	CreateManifestParams *models.CreateManifestParams
	/*The cluster for which a new manifest should be created.
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewV2CreateClusterManifestParams() beforehand.
func (o *V2CreateClusterManifestParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	if runtime.HasBody(r) {
		defer r.Body.Close()
		var body models.CreateManifestParams
		if err := route.Consumer.Consume(r.Body, &body); err != nil {
			if err == io.EOF {
				res = append(res, errors.Required("createManifestParams", "body", ""))
			} else {
				res = append(res, errors.NewParseError("createManifestParams", "body", "", err))
			}
		} else {
			// validate body object
			if err := body.Validate(route.Formats); err != nil {
				res = append(res, err)
			}

			if len(res) == 0 {
				o.CreateManifestParams = &body
			}
		}
	} else {
		res = append(res, errors.Required("createManifestParams", "body", ""))
	}
	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *V2CreateClusterManifestParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *V2CreateClusterManifestParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}
