// Code generated by go-swagger; DO NOT EDIT.

package operators

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"

	"github.com/openshift/assisted-service/models"
)

// NewV2ReportMonitoredOperatorStatusParams creates a new V2ReportMonitoredOperatorStatusParams object
// no default values defined in spec.
func NewV2ReportMonitoredOperatorStatusParams() V2ReportMonitoredOperatorStatusParams {

	return V2ReportMonitoredOperatorStatusParams{}
}

// V2ReportMonitoredOperatorStatusParams contains all the bound params for the v2 report monitored operator status operation
// typically these are obtained from a http.Request
//
// swagger:parameters v2ReportMonitoredOperatorStatus
type V2ReportMonitoredOperatorStatusParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The cluster whose operators are being monitored.
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
	/*The operators monitor report.
	  Required: true
	  In: body
	*/
	ReportParams *models.OperatorMonitorReport
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewV2ReportMonitoredOperatorStatusParams() beforehand.
func (o *V2ReportMonitoredOperatorStatusParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	if runtime.HasBody(r) {
		defer r.Body.Close()
		var body models.OperatorMonitorReport
		if err := route.Consumer.Consume(r.Body, &body); err != nil {
			if err == io.EOF {
				res = append(res, errors.Required("reportParams", "body", ""))
			} else {
				res = append(res, errors.NewParseError("reportParams", "body", "", err))
			}
		} else {
			// validate body object
			if err := body.Validate(route.Formats); err != nil {
				res = append(res, err)
			}

			if len(res) == 0 {
				o.ReportParams = &body
			}
		}
	} else {
		res = append(res, errors.Required("reportParams", "body", ""))
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *V2ReportMonitoredOperatorStatusParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *V2ReportMonitoredOperatorStatusParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}
