// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver endpoint that you want to delete.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteResolverEndpointInput"}

	if s.ResolverEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteResolverEndpoint = "DeleteResolverEndpoint"

// DeleteResolverEndpointRequest returns a request value for making API operation for
// Amazon Route 53 Resolver.
//
// Deletes a resolver endpoint. The effect of deleting a resolver endpoint depends
// on whether it's an inbound or an outbound resolver endpoint:
//
//    * Inbound: DNS queries from your network or another VPC are no longer
//    routed to the DNS service for the specified VPC.
//
//    * Outbound: DNS queries from a VPC are no longer routed to your network
//    or to another VPC.
//
//    // Example sending a request using DeleteResolverEndpointRequest.
//    req := client.DeleteResolverEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Client) DeleteResolverEndpointRequest(input *DeleteResolverEndpointInput) DeleteResolverEndpointRequest {
	op := &aws.Operation{
		Name:       opDeleteResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverEndpointInput{}
	}

	req := c.newRequest(op, input, &DeleteResolverEndpointOutput{})
	return DeleteResolverEndpointRequest{Request: req, Input: input, Copy: c.DeleteResolverEndpointRequest}
}

// DeleteResolverEndpointRequest is the request type for the
// DeleteResolverEndpoint API operation.
type DeleteResolverEndpointRequest struct {
	*aws.Request
	Input *DeleteResolverEndpointInput
	Copy  func(*DeleteResolverEndpointInput) DeleteResolverEndpointRequest
}

// Send marshals and sends the DeleteResolverEndpoint API request.
func (r DeleteResolverEndpointRequest) Send(ctx context.Context) (*DeleteResolverEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteResolverEndpointResponse{
		DeleteResolverEndpointOutput: r.Request.Data.(*DeleteResolverEndpointOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteResolverEndpointResponse is the response type for the
// DeleteResolverEndpoint API operation.
type DeleteResolverEndpointResponse struct {
	*DeleteResolverEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteResolverEndpoint request.
func (r *DeleteResolverEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
