"use strict";

var _mongodb = require("mongodb");

var _MongoMemoryServer = _interopRequireDefault(require("../MongoMemoryServer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

jasmine.DEFAULT_TIMEOUT_INTERVAL = 60000;
let con;
let db;
let mongoServer;
beforeAll(
/*#__PURE__*/
_asyncToGenerator(function* () {
  mongoServer = new _MongoMemoryServer.default();
  const mongoUri = yield mongoServer.getConnectionString();
  con = yield _mongodb.MongoClient.connect(mongoUri);
  db = con.db((yield mongoServer.getDbName()));
}));
afterAll(() => {
  con.close();
  mongoServer.stop();
});
describe('Single mongoServer', () => {
  it('should start mongo server',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    expect(db).toBeDefined();
    const col = db.collection('test');
    const result = yield col.insert([{
      a: 1
    }, {
      b: 1
    }]);
    expect(result.result).toMatchSnapshot();
    expect((yield col.count({}))).toBe(2);
  }));
});