"use strict";

var _tmp = _interopRequireDefault(require("tmp"));

var _MongoBinary = _interopRequireDefault(require("../MongoBinary"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

_tmp.default.setGracefulCleanup();

jasmine.DEFAULT_TIMEOUT_INTERVAL = 160000;
describe('MongoBinary', () => {
  it('should download binary and keep it in cache',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const tmpDir = _tmp.default.dirSync({
      prefix: 'mongo-mem-bin-',
      unsafeCleanup: true
    }); // download


    const version = 'latest';
    const binPath = yield _MongoBinary.default.getPath({
      downloadDir: tmpDir.name,
      version
    }); // eg. /tmp/mongo-mem-bin-33990ScJTSRNSsFYf/mongodb-download/a811facba94753a2eba574f446561b7e/mongodb-macOS-x86_64-3.5.5-13-g00ee4f5/

    expect(binPath).toMatch(/mongo-mem-bin-.*\/.*\/mongod$/); // reuse cache

    expect(_MongoBinary.default.cache[version]).toBeDefined();
    expect(_MongoBinary.default.cache[version]).toEqual(binPath);
    const binPathAgain = yield _MongoBinary.default.getPath({
      downloadDir: tmpDir.name,
      version
    });
    expect(binPathAgain).toEqual(binPath); // cleanup

    tmpDir.removeCallback();
  }));
  it('should use cache',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    _MongoBinary.default.cache['3.4.2'] = '/bin/mongod';
    yield expect(_MongoBinary.default.getPath({
      version: '3.4.2'
    })).resolves.toEqual('/bin/mongod');
  }));
});