"use strict";

var _MongoBinaryDownload = _interopRequireDefault(require("../MongoBinaryDownload"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

describe('MongoBinaryDownload', () => {
  it('should use direct download',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    process.env['yarn_https-proxy'] = '';
    process.env.yarn_proxy = '';
    process.env['npm_config_https-proxy'] = '';
    process.env.npm_config_proxy = '';
    process.env.https_proxy = '';
    process.env.http_proxy = '';
    const du = new _MongoBinaryDownload.default({}); // $FlowFixMe

    du.httpDownload = jest.fn();
    yield du.download('https://fastdl.mongodb.org/osx/mongodb-osx-ssl-x86_64-3.6.3.tgz');
    expect(du.httpDownload).toHaveBeenCalledTimes(1);
    const callArg1 = du.httpDownload.mock.calls[0][0];
    expect(callArg1.agent).toBeUndefined();
  }));
  it('should pick up proxy from env vars',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    process.env['yarn_https-proxy'] = 'http://user:pass@proxy:8080';
    const du = new _MongoBinaryDownload.default({}); // $FlowFixMe

    du.httpDownload = jest.fn();
    yield du.download('https://fastdl.mongodb.org/osx/mongodb-osx-ssl-x86_64-3.6.3.tgz');
    expect(du.httpDownload).toHaveBeenCalledTimes(1);
    const callArg1 = du.httpDownload.mock.calls[0][0];
    expect(callArg1.agent).toBeDefined();
    expect(callArg1.agent.options.href).toBe('http://user:pass@proxy:8080/');
  }));
});