/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';
/**
 * @private
 */

function createError(type, name, message) {
  var error = new Error(message);
  error.name = name;
  error.type = type;
  error.framesToPop = 2;
  return error;
}

module.exports = {
  create: function create(name, message) {
    return createError('error', name, message);
  },
  createWarning: function createWarning(name, message) {
    return createError('warn', name, message);
  }
};