export declare const NOOP: (...args: any[]) => void;
/**
 * Returns either the source argument when it is a `Function`, or the default
 * `NOOP` function constant
 */
export declare function asFunction<T extends Function>(source: T | any): T;
/**
 * Determines whether the supplied argument is both a function, and is not
 * the `NOOP` function.
 */
export declare function isUserFunction<T extends Function>(source: T | any): source is T;
export declare function splitOn(input: string, char: string): [string, string];
export declare function last<T>(input: T[]): T | undefined;
export declare function toLinesWithContent(input: string, trimmed?: boolean): string[];
declare type LineWithContentCallback<T = void> = (line: string) => T;
export declare function forEachLineWithContent<T>(input: string, callback: LineWithContentCallback<T>): T[];
export declare function folderExists(path: string): boolean;
/**
 * Adds `item` into the `target` `Array` or `Set` when it is not already present.
 */
export declare function append<T>(target: T[] | Set<T>, item: T): typeof item;
export declare function remove<T>(target: Set<T> | T[], item: T): T;
export declare function remover<T>(target: Set<T>): (item: T) => T;
export declare const objectToString: (input: any) => string;
export {};
