import { Headers } from 'apollo-server-env';
import { GraphQLSchema } from 'graphql';
import { Trace } from 'apollo-engine-reporting-protobuf';
import { AddTraceArgs, EngineReportingOptions, SendValuesBaseOptions, VariableValueOptions } from './agent';
import { ApolloServerPlugin } from 'apollo-server-plugin-base';
export declare const plugin: <TContext>(options: EngineReportingOptions<TContext> | undefined, addTrace: (args: AddTraceArgs) => Promise<void>, { startSchemaReporting, executableSchemaIdGenerator, schemaReport, }: {
    startSchemaReporting: ({ executableSchema, executableSchemaId, }: {
        executableSchema: string;
        executableSchemaId: string;
    }) => void;
    executableSchemaIdGenerator: (schema: string | GraphQLSchema) => string;
    schemaReport: boolean;
}) => ApolloServerPlugin<TContext>;
export declare function makeTraceDetails(variables: Record<string, any>, sendVariableValues?: VariableValueOptions, operationString?: string): Trace.Details;
export declare function makeHTTPRequestHeaders(http: Trace.IHTTP, headers: Headers, sendHeaders?: SendValuesBaseOptions): void;
//# sourceMappingURL=plugin.d.ts.map