/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 ****************************************************************************** */
/* Copyright (c) 2020 Red Hat, Inc. */
import _ from 'lodash';

async function getWeaveScopeElements(clusterModel, mongoModel, filter) {
  const clusters = await clusterModel.getClusters();
  let resources = await mongoModel.resource({
    clusters: clusters.filter((c) => !!c.metadata).map((c) => c.metadata.name),
    filter,
  });

  // merge weave pods with kube pod info
  const idMap = {};
  const podMap = {};
  const clusterMap = {};
  const resourceUids = new Set();
  resources.forEach((node) => {
    const {
      name, type, cluster, id, uid,
    } = node;
    if (type === 'cluster') {
      idMap[name] = id;
      clusterMap[id] = name;
    } else if (type === 'pod') {
      _.set(podMap, `${cluster}.${name}`, node);
    }
    resourceUids.add(uid);
  });

  resources = resources.map((node) => {
    const {
      cluster, type,
    } = node;
    if (type !== 'cluster') {
      return Object.assign(node, { clusterName: clusterMap[cluster] });
    }
    return node;
  });

  const relationships = resources.reduce((accum, res) => {
    if (res.relationships && res.relationships.length) {
      res.relationships.forEach((outgoing) => {
        if (resourceUids.has(outgoing.uid)) {
          accum.push({ type: 'calls', from: res, to: outgoing });
        }
      });
    }
    return accum;
  }, []);
  return { resources, relationships };
}
export { getWeaveScopeElements as default };
