'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _windowOrGlobal = require('window-or-global');

var _windowOrGlobal2 = _interopRequireDefault(_windowOrGlobal);

var _DetailPageHeader = require('../DetailPageHeader');

var _DetailPageHeader2 = _interopRequireDefault(_DetailPageHeader);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _Breadcrumb = require('../Breadcrumb');

var _Breadcrumb2 = _interopRequireDefault(_Breadcrumb);

var _BreadcrumbItem = require('../BreadcrumbItem');

var _BreadcrumbItem2 = _interopRequireDefault(_BreadcrumbItem);

var _OverflowMenu = require('../OverflowMenu');

var _OverflowMenu2 = _interopRequireDefault(_OverflowMenu);

var _OverflowMenuItem = require('../OverflowMenuItem');

var _OverflowMenuItem2 = _interopRequireDefault(_OverflowMenuItem);

var _Tab = require('../Tab');

var _Tab2 = _interopRequireDefault(_Tab);

var _Tabs = require('../Tabs');

var _Tabs2 = _interopRequireDefault(_Tabs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('DetailPageHeader', function () {
  describe('component is rendered correctly without tabs', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _DetailPageHeader2.default,
      { title: 'test', statusText: 'Stopped', statusColor: '#BADA55' },
      _react2.default.createElement(_Icon2.default, { description: 'watson', name: 'watson' }),
      _react2.default.createElement(
        _Breadcrumb2.default,
        null,
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 1'
        ),
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 2'
        ),
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 3'
        )
      ),
      _react2.default.createElement(
        _OverflowMenu2.default,
        null,
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Stop App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Restart App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Rename App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Edit Routes and Access' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Delete App', isDelete: true })
      )
    ));

    it('should render wrapper with the correct class', function () {
      expect(wrapper.children().hasClass('bx--detail-page-header')).toEqual(true);
      expect(wrapper.children().hasClass('bx--detail-page-header--no-tabs')).toEqual(true);
    });

    it('should render an icon', function () {
      var container = wrapper.find('.bx--detail-page-header-icon-container');
      var icon = container.find(_Icon2.default);
      var hasIcon = icon.length === 1;
      expect(hasIcon).toEqual(true);
    });

    it('should render an icon, even without one passed in', function () {
      var noIcon = (0, _enzyme.shallow)(_react2.default.createElement(_DetailPageHeader2.default, { title: 'test' }));
      var container = noIcon.find('.bx--detail-page-header-icon-container');
      var icon = container.find('svg');
      var hasIcon = icon.length === 1;
      expect(hasIcon).toEqual(true);
    });

    it('should render correct icon', function () {
      expect(wrapper.find(_Icon2.default).at(0).props().name).toEqual('watson');
    });

    it('should render Breadcrumb', function () {
      var breadcrumb = wrapper.find(_Breadcrumb2.default).length === 1;
      expect(breadcrumb).toEqual(true);
    });

    it('should render BreadcrumbItem', function () {
      var breadcrumbItem = wrapper.find(_BreadcrumbItem2.default).length === 3;
      expect(breadcrumbItem).toEqual(true);
    });

    it('should render OverflowMenu', function () {
      var overflow = wrapper.find(_OverflowMenu2.default).length === 1;
      expect(overflow).toEqual(true);
    });

    it('should render an element with a title class', function () {
      var hasTitle = wrapper.find('.bx--detail-page-header-title').length === 1;
      expect(hasTitle).toEqual(true);
    });

    it('should render the correct title', function () {
      expect(wrapper.props().title).toEqual('test');
    });

    it('should render the correct status text', function () {
      expect(wrapper.props().statusText).toEqual('Stopped');
    });

    it('should render the correct status color', function () {
      expect(wrapper.props().statusColor).toEqual('#BADA55');
    });
  });

  describe('component is rendered correctly with tabs', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _DetailPageHeader2.default,
      { hasTabs: true, title: 'test' },
      _react2.default.createElement(_Icon2.default, { description: 'watson', name: 'watson' }),
      _react2.default.createElement(
        _Breadcrumb2.default,
        null,
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 1'
        ),
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 2'
        ),
        _react2.default.createElement(
          _BreadcrumbItem2.default,
          { href: 'www.google.com' },
          'Breadcrumb 3'
        )
      ),
      _react2.default.createElement(
        _OverflowMenu2.default,
        null,
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Stop App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Restart App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Rename App' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Edit Routes and Access' }),
        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Delete App', isDelete: true })
      ),
      _react2.default.createElement(
        _Tabs2.default,
        null,
        _react2.default.createElement(_Tab2.default, { label: 'Overview' }),
        _react2.default.createElement(_Tab2.default, { label: 'Apple' }),
        _react2.default.createElement(_Tab2.default, { label: 'Banana' }),
        _react2.default.createElement(_Tab2.default, { label: 'Orange' })
      )
    ));

    it('should render a wrapper with the correct class', function () {
      expect(wrapper.hasClass('bx--detail-page-header--with-tabs')).toEqual(true);
    });

    it('should render Tabs', function () {
      var tabs = wrapper.find(_Tabs2.default).length === 1;
      expect(tabs).toEqual(true);
    });

    it('should render 4 Tab', function () {
      var tabs = wrapper.find(_Tab2.default).length === 4;
      expect(tabs).toEqual(true);
    });
  });

  describe('scroll event listener', function () {
    var addEvent = void 0;
    var removeEvent = void 0;
    var spyAddEventListener = jest.fn();
    var spyRemoveEventListener = jest.fn();

    beforeEach(function () {
      addEvent = jest.spyOn(_windowOrGlobal2.default, 'addEventListener').mockImplementation(function (type) {
        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        if (type === 'scroll') {
          spyAddEventListener.apply(undefined, [type].concat(args));
        }
      });
      removeEvent = jest.spyOn(_windowOrGlobal2.default, 'removeEventListener').mockImplementation(function (type) {
        for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        if (type === 'scroll') {
          spyRemoveEventListener.apply(undefined, [type].concat(args));
        }
      });
    });

    afterEach(function () {
      addEvent.mockRestore();
      removeEvent.mockRestore();
    });

    it('should pass in the same method when adding and removing the scroll event listener', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_DetailPageHeader2.default, { title: 'test' }));
      wrapper.unmount();
      expect(spyAddEventListener.mock.calls.length).toBe(1);
      expect(spyRemoveEventListener.mock.calls.length).toBe(1);
      var addArgs = spyAddEventListener.mock.calls[0];
      var removeArgs = spyRemoveEventListener.mock.calls[0];
      expect(addArgs[1]).toBe(removeArgs[1]); // the scroll handler function
    });
  });
});