'use strict'
var __createBinding =
	(this && this.__createBinding) ||
	(Object.create
		? function (o, m, k, k2) {
				if (k2 === undefined) k2 = k
				Object.defineProperty(o, k2, {
					enumerable: true,
					get: function () {
						return m[k]
					},
				})
		  }
		: function (o, m, k, k2) {
				if (k2 === undefined) k2 = k
				o[k2] = m[k]
		  })
var __setModuleDefault =
	(this && this.__setModuleDefault) ||
	(Object.create
		? function (o, v) {
				Object.defineProperty(o, 'default', { enumerable: true, value: v })
		  }
		: function (o, v) {
				o['default'] = v
		  })
var __importStar =
	(this && this.__importStar) ||
	function (mod) {
		if (mod && mod.__esModule) return mod
		var result = {}
		if (mod != null)
			for (var k in mod)
				if (k !== 'default' && Object.hasOwnProperty.call(mod, k))
					__createBinding(result, mod, k)
		__setModuleDefault(result, mod)
		return result
	}
var __importDefault =
	(this && this.__importDefault) ||
	function (mod) {
		return mod && mod.__esModule ? mod : { default: mod }
	}
Object.defineProperty(exports, '__esModule', { value: true })
exports.isIgnoredPath = void 0
// Import
const pathUtil = __importStar(require('path'))
const ignorepatterns_1 = __importDefault(require('ignorepatterns'))
/**
 * Is Ignored Path
 * Check to see if a path, either a full path or basename, should be ignored
 * @param path A full path or basename of a file or directory
 * @param opts Configurations options
 * @returns Whether or not the path should be ignored
 */
function isIgnoredPath(path, opts = {}) {
	// Prepare
	const basename = pathUtil.basename(path)
	// Test Paths
	if (opts.ignorePaths) {
		for (let i = 0; i < opts.ignorePaths.length; ++i) {
			const ignorePath = opts.ignorePaths[i]
			if (path.indexOf(ignorePath) === 0) {
				return true
			}
		}
	}
	// Test Hidden Files
	if (opts.ignoreHiddenFiles && basename[0] === '.') {
		return true
	}
	// Test Common Patterns
	if (opts.ignoreCommonPatterns == null || opts.ignoreCommonPatterns === true) {
		return (
			ignorepatterns_1.default.test(path) ||
			(path !== basename && ignorepatterns_1.default.test(basename))
		)
	} else if (opts.ignoreCommonPatterns) {
		const ignoreCommonPatterns /* :RegExp */ = opts.ignoreCommonPatterns
		return (
			ignoreCommonPatterns.test(path) ||
			(path !== basename && ignoreCommonPatterns.test(basename))
		)
	}
	// Test Custom Patterns
	if (opts.ignoreCustomPatterns) {
		const ignoreCustomPatterns /* :RegExp */ = opts.ignoreCustomPatterns
		return (
			ignoreCustomPatterns.test(path) ||
			(path !== basename && ignoreCustomPatterns.test(basename))
		)
	}
	// Return
	return false
}
exports.isIgnoredPath = isIgnoredPath
