/** Determines if the passed value is of a specific type */
export declare type TypeTester = (value: any) => boolean
/**
 * The interface for a type mapping (key => function) to use for {@link getType}.
 export * The key represents the name of the type. The function represents the {@link TypeTester test method}.
 * The map should be ordered by testing preference, with more specific tests first.
 * If a test returns true, it is selected, and the key is returned as the type.
 */
export interface TypeMap {
	[type: string]: TypeTester
}
/** Get the object type string */
export declare function getObjectType(value?: any): string
/** Checks to see if a value is an object */
export declare function isObject(value?: any): boolean
/** Checks to see if a value is an object and only an object */
export declare function isPlainObject(value?: any): boolean
/**
 * Is ES6+ class */
export declare function isNativeClass(value?: any): boolean
/**
 * Is Conventional Class
 export * Looks for function with capital first letter MyClass
 * First letter is the 9th character
 * If changed, isClass must also be updated */
export declare function isConventionalClass(value?: any): boolean
export declare function isClass(value?: any): boolean
/** Checks to see if a value is an error */
export declare function isError(value?: any): boolean
/** Checks to see if a value is a date */
export declare function isDate(value?: any): boolean
/** Checks to see if a value is an arguments object */
export declare function isArguments(value?: any): boolean
/**
 export * Checks to see if a value is a function but not an asynchronous function */
export declare function isSyncFunction(value?: any): boolean
/** Checks to see if a value is an asynchronous function */
export declare function isAsyncFunction(value?: any): boolean
/** Checks to see if a value is a function */
export declare function isFunction(value?: any): boolean
/** Checks to see if a value is an regex */
export declare function isRegExp(value?: any): boolean
/** Checks to see if a value is an array */
export declare function isArray(value?: any): boolean
/** Checks to see if a valule is a number */
export declare function isNumber(value?: any): boolean
/** Checks to see if a value is a string */
export declare function isString(value?: any): boolean
/** Checks to see if a valule is a boolean */
export declare function isBoolean(value?: any): boolean
/** Checks to see if a value is null */
export declare function isNull(value?: any): boolean
/** Checks to see if a value is undefined */
export declare function isUndefined(value?: any): boolean
/** Checks to see if a value is a Map */
export declare function isMap(value?: any): boolean
/** Checks to see if a value is a WeakMap */
export declare function isWeakMap(value?: any): boolean
/** Checks to see if a value is nullish */
export declare function isNullish(value?: any): boolean
/**
 * Is empty array
 * Will throw if the value was not an array
 */
export declare function isEmptyArray(value: Array<any>): boolean
/**
 * Is empty plain object
 * Will throw if the value was not a plain object
 */
export declare function isEmptyPlainObject(value: object): boolean
/**
 * Is empty map
 * Will throw if the value was not a map
 */
export declare function isEmptyMap(value: any): boolean
/**
 * Is empty weak map
 * Will throw if the value was not a weak map
 */
export declare function isEmptyWeakMap(value: any): boolean
/**
 * Is empty keys
 */
export declare function isEmptyKeys(value: any): boolean
/**
 * The default {@link TypeMap} for {@link getType}.
 export * AsyncFunction and SyncFunction are missing, as they are more specific types that people can detect afterwards.
 * @readonly
 */
export declare const typeMap: TypeMap
/**
 * Cycle through the passed {@link TypeMap} testing the value, returning the first type that passes, otherwise `null`.
 * @param value the value to test
 * @param customTypeMap defaults to {@link typeMap}
 */
export declare function getType(
	value: any,
	customTypeMap?: TypeMap
): string | null
//# sourceMappingURL=index.d.ts.map
