function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

import { buildHierarchy, findParent } from './sorting';

export var getAllChildren = function getAllChildren(item, items) {
  var results = [];
  var children = items.filter(function (theItem) {
    return theItem.parentId && theItem.parentId === item.id;
  });

  if (children.length > 0) {
    results.push.apply(results, _toConsumableArray(children));

    children.forEach(function (child) {
      results.push.apply(results, _toConsumableArray(getAllChildren(child, items)));
    });
  }

  return results;
};

export var defaultFilterItems = function defaultFilterItems(items, _ref) {
  var itemToString = _ref.itemToString,
      inputValue = _ref.inputValue,
      expandedItems = _ref.expandedItems;
  return items.filter(function (item) {
    var parents = buildHierarchy(item, items);
    parents.pop();

    if (parents.length > 0 && expandedItems) {
      // If any parent item is not expanded, the child item should not be shown
      var isExpanded = !parents.some(function (parent) {
        return !expandedItems.some(function (expandedItem) {
          return expandedItem.id === parent.id;
        });
      });
      if (!isExpanded) {
        return false;
      }
    }

    if (!inputValue) {
      return true;
    }

    var children = getAllChildren(item, items).filter(function (theItem) {
      return itemToString(theItem).toLowerCase().includes(inputValue.toLowerCase());
    });
    if (children.length > 0) {
      // if any of the child item matches, the parent item should be shown
      return true;
    }

    if (parents.length > 0) {
      var isVisible = parents.some(function (parent) {
        return itemToString(parent).toLowerCase().includes(inputValue.toLowerCase());
      });
      if (isVisible) {
        // if it matches any of the parents, all sub items should be shown
        return true;
      }
    }

    return itemToString(item).toLowerCase().includes(inputValue.toLowerCase());
  });
};