function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text } from '@storybook/addon-knobs';
import Checkbox from '../Checkbox';
import CheckboxSkeleton from '../Checkbox/Checkbox.Skeleton';

var props = function props() {
  return {
    className: 'some-class',
    labelText: text('Label text (labelText)', 'Checkbox label'),
    indeterminate: boolean('Intermediate (indeterminate)', false),
    disabled: boolean('Disabled (disabled)', false),
    hideLabel: boolean('No label (hideLabel)', false),
    wrapperClassName: text('Wrapper CSS class name (wrapperClassName)', ''),
    onChange: action('onChange')
  };
};

storiesOf('Checkbox', module).addDecorator(withKnobs).add('checked', function () {
  var checkboxProps = props();
  return React.createElement("fieldset", {
    className: "bx--fieldset"
  }, React.createElement("legend", {
    className: "bx--label"
  }, "Checkbox heading"), React.createElement(Checkbox, _extends({
    defaultChecked: true
  }, checkboxProps, {
    id: "checkbox-label-1"
  })), React.createElement(Checkbox, _extends({
    defaultChecked: true
  }, checkboxProps, {
    id: "checkbox-label-2"
  })));
}, {
  info: {
    text: "\n        Checkboxes are used when there is a list of options and the user may select multiple options, including all or none.\n        The example below shows how the Checkbox component can be used as an uncontrolled component that is initially checked\n        by setting the defaultChecked property to true. To use the component in a controlled way, you should set the\n        checked property instead.\n      "
  }
}).add('unchecked', function () {
  var checkboxProps = props();
  return React.createElement("fieldset", {
    className: "bx--fieldset"
  }, React.createElement("legend", {
    className: "bx--label"
  }, "Checkbox heading"), React.createElement(Checkbox, _extends({}, checkboxProps, {
    id: "checkbox-label-1"
  })), React.createElement(Checkbox, _extends({}, checkboxProps, {
    id: "checkbox-label-2"
  })));
}, {
  info: {
    text: "\n          Checkboxes are used when there is a list of options and the user may select multiple options, including all or none.\n          The example below shows how the Checkbox component can be used as an uncontrolled component that is initially\n          unchecked. To use the component in a controlled way, you should set the checked property instead.\n        "
  }
}).add('skeleton', function () {
  return React.createElement("div", null, React.createElement(CheckboxSkeleton, null));
}, {
  info: {
    text: "\n          Placeholder skeleton state to use when content is loading.\n        "
  }
});